/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.wrapper;

import com.bes.enterprise.gjc.spi.ConnectionHolderStatementWrapper;
import com.bes.enterprise.gjc.spi.cache.impl.BesJdbcCache;
import com.bes.enterprise.gjc.spi.cache.resultset.ConnectionHolderStatementWrapperImpl;
import com.bes.enterprise.gjc.spi.cache.wrapper.ConnectionWrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionCacheWrapper
extends ConnectionWrapper {
    private ConnectionHolderStatementWrapper statementWrapper = new ConnectionHolderStatementWrapperImpl();
    private BesJdbcCache resultSetCache;

    public ConnectionCacheWrapper(Connection connection, String cacheName) {
        super(connection);
        this.resultSetCache = BesJdbcCache.createInstance(cacheName);
    }

    public ConnectionCacheWrapper(Connection connection, Object obj) {
        super(connection);
        this.resultSetCache = BesJdbcCache.getObjRefBindingCache(obj);
    }

    private Statement wrapperStatement(Statement stmt) {
        return this.statementWrapper.wrapperStatement(stmt, this.resultSetCache);
    }

    private PreparedStatement wrapperPreparedStatement(PreparedStatement stmt, String sql) {
        return this.statementWrapper.wrapperPreparedStatement(stmt, sql, this.resultSetCache);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt = super.prepareStatement(sql, columnNames);
        stmt = this.wrapperPreparedStatement(stmt, sql);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt = super.prepareStatement(sql, columnIndexes);
        stmt = this.wrapperPreparedStatement(stmt, sql);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement stmt = super.prepareStatement(sql, autoGeneratedKeys);
        stmt = this.wrapperPreparedStatement(stmt, sql);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        stmt = this.wrapperPreparedStatement(stmt, sql);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt = super.prepareStatement(sql, resultSetType, resultSetConcurrency);
        stmt = this.wrapperPreparedStatement(stmt, sql);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt = super.prepareStatement(sql);
        stmt = this.wrapperPreparedStatement(stmt, sql);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        stmt = this.wrapperStatement(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = super.createStatement(resultSetType, resultSetConcurrency);
        stmt = this.wrapperStatement(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = super.createStatement();
        stmt = this.wrapperStatement(stmt);
        return stmt;
    }
}

