/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.datasources;

import com.bes.enterprise.gjc.spi.datasources.ExceptionUtils;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.IntrospectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

public class DataSourceConvertUtils {
    private static final Log log = LogFactory.getLog(DataSourceConvertUtils.class);
    private static List<String> EXPECTED_ATTRIBUTES = new ArrayList<String>();

    public static void convert(DataSource dataSource, Properties props) {
        for (Object key : props.keySet()) {
            String value = props.get(key).toString();
            DataSourceConvertUtils.setProperty(dataSource, key.toString(), value);
        }
    }

    public static boolean setProperty(DataSource dataSource, String name, String value) {
        return DataSourceConvertUtils.setProperty(dataSource, name, value, true);
    }

    public static boolean setProperty(DataSource dataSource, String name, String value, boolean invokeSetProperty) {
        block36: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSourceConvertUtils: setProperty(" + dataSource.getClass() + " " + name + "=" + value + ")"));
            }
            String setter = "set" + IntrospectionUtils.capitalize((String)name);
            try {
                int i;
                Method[] methods = IntrospectionUtils.findMethods(dataSource.getClass());
                Method setPropertyMethodVoid = null;
                Method setPropertyMethodBool = null;
                for (i = 0; i < methods.length; ++i) {
                    Class<?>[] paramT = methods[i].getParameterTypes();
                    if (!setter.equals(methods[i].getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                    methods[i].invoke((Object)dataSource, value);
                    return true;
                }
                for (i = 0; i < methods.length; ++i) {
                    Class<?>[] parameterTypes;
                    boolean ok = true;
                    if (setter.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 1) {
                        Class<?> paramType = methods[i].getParameterTypes()[0];
                        Object[] params = new Object[1];
                        if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                            try {
                                params[0] = Integer.valueOf(value);
                            }
                            catch (NumberFormatException ex) {
                                ok = false;
                            }
                        } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                            try {
                                params[0] = Long.valueOf(value);
                            }
                            catch (NumberFormatException ex) {
                                ok = false;
                            }
                        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                            params[0] = Boolean.valueOf(value);
                        } else if ("java.net.InetAddress".equals(paramType.getName())) {
                            try {
                                params[0] = InetAddress.getByName(value);
                            }
                            catch (UnknownHostException exc) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + value));
                                }
                                ok = false;
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("IntrospectionUtils: Unknown type " + paramType.getName()));
                        }
                        if (ok) {
                            methods[i].invoke((Object)dataSource, params);
                            return true;
                        }
                    }
                    if (!"setProperty".equals(methods[i].getName())) continue;
                    if (methods[i].getReturnType() == Boolean.TYPE) {
                        setPropertyMethodBool = methods[i];
                        parameterTypes = setPropertyMethodBool.getParameterTypes();
                    } else {
                        setPropertyMethodVoid = methods[i];
                        parameterTypes = setPropertyMethodVoid.getParameterTypes();
                    }
                    if (parameterTypes.length == 2 && String.class.isAssignableFrom(parameterTypes[0]) && String.class.isAssignableFrom(parameterTypes[1])) break;
                    setPropertyMethodVoid = null;
                    setPropertyMethodBool = null;
                }
                if (invokeSetProperty && (setPropertyMethodBool != null || setPropertyMethodVoid != null)) {
                    Object[] params = new Object[]{name, value};
                    if (setPropertyMethodBool != null) {
                        try {
                            return (Boolean)setPropertyMethodBool.invoke((Object)dataSource, params);
                        }
                        catch (IllegalArgumentException biae) {
                            if (setPropertyMethodVoid != null) {
                                setPropertyMethodVoid.invoke((Object)dataSource, params);
                                return true;
                            }
                            throw biae;
                        }
                    }
                    setPropertyMethodVoid.invoke((Object)dataSource, params);
                    return true;
                }
            }
            catch (IllegalArgumentException ex2) {
                if (!DataSourceConvertUtils.isExpectedAttribute(name)) {
                    log.warn((Object)("IAE " + dataSource + " " + name + " " + value + " "), (Throwable)ex2);
                }
            }
            catch (SecurityException ex1) {
                if (!DataSourceConvertUtils.isExpectedAttribute(name)) {
                    log.warn((Object)("IntrospectionUtils: SecurityException for " + dataSource.getClass() + " " + name + "=" + value + ") "), (Throwable)ex1);
                }
            }
            catch (IllegalAccessException iae) {
                if (!DataSourceConvertUtils.isExpectedAttribute(name)) {
                    log.warn((Object)("IntrospectionUtils: IllegalAccessException for " + dataSource.getClass() + " " + name + "=" + value + ") "), (Throwable)iae);
                }
            }
            catch (InvocationTargetException ie) {
                ExceptionUtils.handleThrowable(ie.getCause());
                if (DataSourceConvertUtils.isExpectedAttribute(name)) break block36;
                log.warn((Object)("IntrospectionUtils: InvocationTargetException for " + dataSource.getClass() + " " + name + "=" + value + ") "), (Throwable)ie);
            }
        }
        return false;
    }

    private static boolean isExpectedAttribute(String attr) {
        return EXPECTED_ATTRIBUTES.contains(attr);
    }

    static {
        String[] attrs = new String[]{"logSlow", "password", "validateAtmostPeriodInMilliSeconds", "scope", "maxIdle", "maxTotal", "driverClassName", "maxEvictableIdleTimeMillis", "portNumber", "username", "testOnBorrow", "url", "URL", "serverName", "auth", "singleton", "maxOpenPreparedStatements", "logFailed", "timeBetweenEvictionRunsMillis", "initialSize", "maxQueries", "removeAbandonedTimeout", "maxWaitMillis", "minEvictableIdleTimeMillis", "sqlTrace", "databaseName", "poolStatementSize", "user", "minIdle", "accessToUnderlyingConnectionAllowed", "validationQueryTimeout", "defaultFetchSize", "maxConnLifetimeMillis", "testWhileIdle", "defaultQueryTimeout", "poolStatements", "logAbandoned", "removeAbandonedOnBorrow"};
        EXPECTED_ATTRIBUTES.addAll(Arrays.asList(attrs));
    }
}

