/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.datasources;

import com.bes.enterprise.gjc.pool.KeyedObjectPool;
import com.bes.enterprise.gjc.pool.impl.GenericKeyedObjectPool;
import com.bes.enterprise.gjc.pool.impl.GenericKeyedObjectPoolConfig;
import com.bes.enterprise.gjc.spi.datasources.InstanceKeyDataSource;
import com.bes.enterprise.gjc.spi.datasources.InstanceKeyDataSourceFactory;
import com.bes.enterprise.gjc.spi.datasources.KeyedCPDSConnectionFactory;
import com.bes.enterprise.gjc.spi.datasources.PooledConnectionAndInfo;
import com.bes.enterprise.gjc.spi.datasources.PooledConnectionManager;
import com.bes.enterprise.gjc.spi.datasources.SharedPoolDataSourceFactory;
import com.bes.enterprise.gjc.spi.datasources.UserPassKey;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -1458539734480586454L;
    private int maxTotal = -1;
    private transient KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool = null;
    private transient KeyedCPDSConnectionFactory factory = null;

    @Override
    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.assertInitializationAllowed();
        this.maxTotal = maxTotal;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        SharedPoolDataSource sharedPoolDataSource = this;
        synchronized (sharedPoolDataSource) {
            if (this.pool == null) {
                try {
                    this.registerPool(username, password);
                }
                catch (NamingException e) {
                    throw new SQLException("RegisterPool failed", e);
                }
            }
        }
        PooledConnectionAndInfo info = null;
        UserPassKey key = new UserPassKey(username, password);
        try {
            info = this.pool.borrowObject(key);
        }
        catch (Exception e) {
            throw new SQLException("Could not retrieve connection info from pool", e);
        }
        return info;
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey upkey) {
        return this.factory;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), SharedPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return ref;
    }

    private void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        this.factory = new KeyedCPDSConnectionFactory(cpds, this.getValidationQuery(), this.getValidationQueryTimeout(), this.isRollbackAfterValidation());
        this.factory.setMaxConnLifetimeMillis(this.getMaxConnLifetimeMillis());
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setBlockWhenExhausted(this.getDefaultBlockWhenExhausted());
        config.setEvictionPolicyClassName(this.getDefaultEvictionPolicyClassName());
        config.setLifo(this.getDefaultLifo());
        config.setMaxIdlePerKey(this.getDefaultMaxIdle());
        config.setMaxTotal(this.getMaxTotal());
        config.setMaxTotalPerKey(this.getDefaultMaxTotal());
        config.setMaxWaitMillis(this.getDefaultMaxWaitMillis());
        config.setMaxEvictableIdleTimeMillis(this.getDefaultMaxEvictableIdleTimeMillis());
        config.setMinIdlePerKey(this.getDefaultMinIdle());
        config.setNumTestsPerEvictionRun(this.getDefaultNumTestsPerEvictionRun());
        config.setMinEvictableIdleTimeMillis(this.getDefaultMinEvictableIdleTimeMillis());
        config.setTestOnCreate(this.getDefaultTestOnCreate());
        config.setTestOnBorrow(this.getDefaultTestOnBorrow());
        config.setTestOnReturn(this.getDefaultTestOnReturn());
        config.setTestWhileIdle(this.getDefaultTestWhileIdle());
        config.setTimeBetweenEvictionRunsMillis(this.getDefaultTimeBetweenEvictionRunsMillis());
        GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo> tmpPool = new GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo>(this.factory, config);
        this.factory.setPool(tmpPool);
        this.pool = tmpPool;
    }

    @Override
    protected void setupDefaults(Connection con, String username) throws SQLException {
        Boolean defaultReadOnly;
        int defaultTransactionIsolation;
        Boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (defaultAutoCommit != null && con.getAutoCommit() != defaultAutoCommit.booleanValue()) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if ((defaultTransactionIsolation = this.getDefaultTransactionIsolation()) != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        if ((defaultReadOnly = this.isDefaultReadOnly()) != null && con.isReadOnly() != defaultReadOnly.booleanValue()) {
            con.setReadOnly(defaultReadOnly);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            SharedPoolDataSource oldDS = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = oldDS.pool;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }
}

