/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.managed;

import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.ConnectionResult;
import com.bes.enterprise.gjc.spi.managed.TransactionRegistry;
import com.bes.enterprise.gjc.spi.managed.XAConnectionFactory;
import com.bes.enterprise.transaction.LroResource;
import com.bes.enterprise.transaction.manager.WrapperNamedXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LocalXAConnectionFactory
implements XAConnectionFactory {
    private final TransactionRegistry transactionRegistry;
    private final ConnectionFactory connectionFactory;
    private String resourceName;

    public LocalXAConnectionFactory(TransactionManager transactionManager, ConnectionFactory connectionFactory) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is null");
        }
        this.transactionRegistry = new TransactionRegistry(transactionManager);
        this.connectionFactory = connectionFactory;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public ConnectionResult getConnectionResult() throws SQLException {
        ConnectionResult connectionResult = this.connectionFactory.getConnectionResult();
        LocalXAResource xaResource = new LocalXAResource(connectionResult.getConnection());
        if (this.resourceName != null) {
            xaResource = new WrapperNamedXAResource((XAResource)xaResource, this.resourceName);
        }
        this.transactionRegistry.registerConnection(connectionResult.getConnection(), xaResource);
        return connectionResult;
    }

    @Override
    public ConnectionResult getConnectionResult(String username, String password) throws SQLException {
        ConnectionResult connectionResult = this.connectionFactory.getConnectionResult(username, password);
        LocalXAResource xaResource = new LocalXAResource(connectionResult.getConnection());
        if (this.resourceName != null) {
            xaResource = new WrapperNamedXAResource((XAResource)xaResource, this.resourceName);
        }
        this.transactionRegistry.registerConnection(connectionResult.getConnection(), xaResource);
        return connectionResult;
    }

    protected static class LocalXAResource
    implements XAResource,
    LroResource {
        private final Connection connection;
        private Xid currentXid;
        private boolean originalAutoCommit;

        public LocalXAResource(Connection localTransaction) {
            this.connection = localTransaction;
        }

        public synchronized Xid getXid() {
            return this.currentXid;
        }

        @Override
        public synchronized void start(Xid xid, int flag) throws XAException {
            if (flag == 0) {
                if (this.currentXid != null) {
                    throw new XAException("Already enlisted in another transaction with xid " + xid);
                }
                try {
                    this.originalAutoCommit = this.connection.getAutoCommit();
                }
                catch (SQLException ignored) {
                    this.originalAutoCommit = true;
                }
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw (XAException)new XAException("Count not turn off auto commit for a XA transaction").initCause(e);
                }
                this.currentXid = xid;
            } else if (flag == 0x8000000) {
                if (!xid.equals(this.currentXid)) {
                    throw new XAException("Attempting to resume in different transaction: expected " + this.currentXid + ", but was " + xid);
                }
            } else {
                throw new XAException("Unknown start flag " + flag);
            }
        }

        @Override
        public synchronized void end(Xid xid, int flag) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
        }

        @Override
        public synchronized int prepare(Xid xid) {
            try {
                if (this.connection.isReadOnly()) {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    return 3;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 0;
        }

        @Override
        public synchronized void commit(Xid xid, boolean flag) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (this.currentXid == null) {
                throw new XAException("There is no current transaction");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
            try {
                if (this.connection.isClosed()) {
                    throw new XAException("Conection is closed");
                }
                if (!this.connection.isReadOnly()) {
                    this.connection.commit();
                }
            }
            catch (SQLException e) {
                throw (XAException)new XAException().initCause(e);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException sQLException) {}
                this.currentXid = null;
            }
        }

        @Override
        public synchronized void rollback(Xid xid) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (this.currentXid == null) {
                return;
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw (XAException)new XAException().initCause(e);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException sQLException) {}
                this.currentXid = null;
            }
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            return this == xaResource;
        }

        @Override
        public synchronized void forget(Xid xid) {
            if (xid != null && xid.equals(this.currentXid)) {
                this.currentXid = null;
            }
        }

        @Override
        public Xid[] recover(int flag) {
            return new Xid[0];
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        @Override
        public boolean setTransactionTimeout(int transactionTimeout) {
            return false;
        }
    }
}

