/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.managed;

import com.bes.enterprise.gjc.pool.ObjectPool;
import com.bes.enterprise.gjc.spi.PoolingDataSource;
import com.bes.enterprise.gjc.spi.managed.ManagedConnection;
import com.bes.enterprise.gjc.spi.managed.TransactionRegistry;
import java.sql.Connection;
import java.sql.SQLException;

public class ManagedDataSource<C extends Connection>
extends PoolingDataSource<C> {
    private TransactionRegistry transactionRegistry;

    public ManagedDataSource(ObjectPool<C> pool, TransactionRegistry transactionRegistry) {
        super(pool);
        this.transactionRegistry = transactionRegistry;
    }

    public void setTransactionRegistry(TransactionRegistry transactionRegistry) {
        if (this.transactionRegistry != null) {
            throw new IllegalStateException("TransactionRegistry already set");
        }
        if (transactionRegistry == null) {
            throw new NullPointerException("TransactionRegistry is null");
        }
        this.transactionRegistry = transactionRegistry;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.getPool() == null) {
            throw new IllegalStateException("Pool has not been set");
        }
        if (this.transactionRegistry == null) {
            throw new IllegalStateException("TransactionRegistry has not been set");
        }
        ManagedConnection connection = new ManagedConnection(this.getPool(), this.transactionRegistry, this.isAccessToUnderlyingConnectionAllowed());
        return connection;
    }
}

