/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.managed;

import com.bes.enterprise.gjc.spi.managed.BasicManagedDataSource;
import com.bes.enterprise.gjc.spi.managed.TransactionRegistry;
import com.bes.enterprise.transaction.manager.NamedXAResource;
import com.bes.enterprise.transaction.manager.NamedXAResourceFactory;
import com.bes.enterprise.transaction.manager.WrapperNamedXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;

public class NamedDataSourceXAResourceFactory
implements NamedXAResourceFactory {
    private String name;
    private BasicManagedDataSource managedDataSource;
    private final Map<NamedXAResource, Connection> connections = new HashMap<NamedXAResource, Connection>();

    public NamedDataSourceXAResourceFactory(String name, BasicManagedDataSource managedDataSource) {
        this.name = name;
        this.managedDataSource = managedDataSource;
    }

    public String getName() {
        return this.name;
    }

    public NamedXAResource getNamedXAResource() throws SystemException {
        Connection connection = null;
        try {
            connection = this.managedDataSource.getConnection();
            TransactionRegistry txRegistry = this.managedDataSource.getTransactionRegistry();
            XAResource xaResource = txRegistry.getXAResource(connection);
            if (xaResource != null) {
                WrapperNamedXAResource namedXAResource = new WrapperNamedXAResource(xaResource, this.name);
                this.connections.put((NamedXAResource)namedXAResource, connection);
                return namedXAResource;
            }
            return null;
        }
        catch (SQLException sqlEx) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception xaResource) {
                    // empty catch block
                }
            }
            SystemException sysEx = new SystemException("Failure to get NamedXAResource for datasource " + this.name + "!");
            sysEx.initCause((Throwable)sqlEx);
            throw sysEx;
        }
    }

    public void returnNamedXAResource(NamedXAResource namedXAResource) {
        Connection connection = this.connections.remove(namedXAResource);
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

