/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.managed;

import com.bes.enterprise.gjc.pool.PooledObject;
import com.bes.enterprise.gjc.pool.impl.DefaultPooledObject;
import com.bes.enterprise.gjc.spi.ConnectionResult;
import com.bes.enterprise.gjc.spi.PoolableConnection;
import com.bes.enterprise.gjc.spi.PoolableConnectionFactory;
import com.bes.enterprise.gjc.spi.PoolingConnection;
import com.bes.enterprise.gjc.spi.SecurityInfo;
import com.bes.enterprise.gjc.spi.StatementCacheManager;
import com.bes.enterprise.gjc.spi.base.datastructure.Cache;
import com.bes.enterprise.gjc.spi.base.datastructure.CacheFactory;
import com.bes.enterprise.gjc.spi.managed.PoolableManagedConnection;
import com.bes.enterprise.gjc.spi.managed.TransactionRegistry;
import com.bes.enterprise.gjc.spi.managed.XAConnectionFactory;
import com.bes.enterprise.gjc.spi.trace.TracedPoolableManagedConnection;
import java.sql.Connection;
import javax.management.ObjectName;

public class PoolableManagedConnectionFactory
extends PoolableConnectionFactory {
    private final TransactionRegistry transactionRegistry;

    public PoolableManagedConnectionFactory(XAConnectionFactory connFactory, ObjectName dataSourceJmxName) {
        super(connFactory, dataSourceJmxName);
        this.transactionRegistry = connFactory.getTransactionRegistry();
    }

    @Override
    public PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = null;
        ConnectionResult connectionResult = null;
        if (this.matchConnections) {
            String username = SecurityInfo.username.get();
            if (username != null) {
                String password = SecurityInfo.password.get();
                connectionResult = this.getConnectionFactory().getConnectionResult(username, password);
                conn = connectionResult.getConnection();
                if (conn == null) {
                    throw new IllegalStateException("Connection factory returned null from createConnection");
                }
                conn.getClientInfo().put("internal_user", username);
            } else {
                connectionResult = this.getConnectionFactory().getConnectionResult();
                conn = connectionResult.getConnection();
                if (conn == null) {
                    throw new IllegalStateException("Connection factory returned null from createConnection");
                }
            }
        } else {
            connectionResult = this.getConnectionFactory().getConnectionResult();
            conn = connectionResult.getConnection();
            if (conn == null) {
                throw new IllegalStateException("Connection factory returned null from createConnection");
            }
        }
        this.initializeConnection(conn);
        Cache statementCache = null;
        if ((this.getPoolPreparedStatements() || this.getPoolStatements()) && this.getMaxOpenPreparedStatements() > 0) {
            statementCache = CacheFactory.getDataStructure(null, this.getMaxOpenPreparedStatements());
        }
        if (statementCache != null) {
            conn = new PoolingConnection(conn);
            StatementCacheManager manager = new StatementCacheManager((PoolingConnection)conn, statementCache, this.getPoolPreparedStatements(), this.getPoolStatements());
            ((PoolingConnection)conn).setStatementCacheManager(manager);
        }
        long connIndex = this.connectionIndex.getAndIncrement();
        StringBuilder connName = new StringBuilder();
        connName.append("connection_").append(connIndex);
        ObjectName connJmxName = null;
        connJmxName = this.dataSourceJmxName == null ? null : new ObjectName(this.dataSourceJmxName.toString() + ",connectionpool=connections,connection=" + connIndex);
        PoolableManagedConnection pmc = !this.getUsingTrace() ? new PoolableManagedConnection(connName.toString(), this.transactionRegistry, conn, this.getPool(), connJmxName, this.queryReport) : new TracedPoolableManagedConnection(connName.toString(), this.transactionRegistry, conn, this.getPool(), connJmxName, this.queryReport);
        if (conn instanceof PoolingConnection) {
            ((PoolingConnection)conn).setPoolableConnection(pmc);
        }
        pmc.setCacheState(this.getCacheState());
        pmc.setFailAllConnection(this.isFailAllConnection());
        pmc.setWrapStatement(this.isWrapStatement());
        return new DefaultPooledObject<PoolableConnection>(pmc);
    }
}

