/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.trace;

import com.bes.enterprise.gjc.pool.impl.GenericObjectPool;
import com.bes.enterprise.gjc.spi.PoolableConnection;
import com.bes.enterprise.gjc.spi.QueryReport;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.management.ObjectName;

public class TracedPoolableConnection
extends PoolableConnection {
    public TracedPoolableConnection(String name, Connection conn, GenericObjectPool<PoolableConnection> pool, ObjectName jmxName, Collection<String> disconnectSqlCodes, boolean fastFailValidation, QueryReport queryReport) {
        super(name, conn, pool, jmxName, disconnectSqlCodes, fastFailValidation, queryReport);
    }

    public TracedPoolableConnection(String name, Connection conn, GenericObjectPool<PoolableConnection> pool, ObjectName jmxName, QueryReport queryReport) {
        this(name, conn, pool, jmxName, null, false, queryReport);
    }

    @Override
    protected void activate() {
        super.activate();
        if (!this.reallyClosed && log.isInfoEnabled()) {
            if (this._pool == null) {
                log.info((Object)("Borrowed one temporary connection with name " + this.name));
            } else {
                log.info((Object)("The pool " + this._pool.getName() + " borrowed one connection with name " + this.name));
            }
        }
    }

    @Override
    protected void passivate() throws SQLException {
        super.passivate();
        if (!this.reallyClosed && log.isInfoEnabled()) {
            if (this._pool == null) {
                log.info((Object)("Returned one temporary connection with name " + this.name));
            } else {
                log.info((Object)("The pool " + this._pool.getName() + " returned one connection with name " + this.name));
            }
        }
    }
}

