/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.adapter.parse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RaXmlUtils {
    public static final String ID_NAME = "id";
    public static final String CONNECTION_DEFINITION_NAME = "connection-definition";
    public static final String CONNECTION_FACTORY_INTERFACE_NAME = "connectionfactory-interface";
    public static final String RESOURCE_ADAPTER_NAME = "resourceadapter";
    public static final String ADMIN_OBJECT_NAME = "adminobject";
    public static final String ADMIN_OBJECT_INTERFACE_NAME = "adminobject-interface";
    public static final String CONFIG_PROPERTY_NAME = "config-property";
    public static final String CONFIG_PROPERTY_KEY_NAME = "config-property-name";
    public static final String CONFIG_PROPERTY_VALUE_NAME = "config-property-value";

    public static List<String> getAllConnectionFactoryInterfaces(File raXml) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<String> connectionFactoryInterfaces = new ArrayList<String>();
        Document document = RaXmlUtils.getDocument(raXml);
        NodeList connectionFactoryInterfaceList = document.getElementsByTagName(CONNECTION_FACTORY_INTERFACE_NAME);
        for (int i2 = 0; i2 < connectionFactoryInterfaceList.getLength(); ++i2) {
            String connectionFactoryInterface;
            Node item = connectionFactoryInterfaceList.item(i2);
            if (item.getFirstChild() == null || (connectionFactoryInterface = item.getFirstChild().getNodeValue().trim()) == null || connectionFactoryInterface.trim().length() <= 0) continue;
            connectionFactoryInterfaces.add(connectionFactoryInterface);
        }
        return connectionFactoryInterfaces;
    }

    public static String getResourceAdapterId(File raXml, String defaultValue) throws IOException, SAXException, ParserConfigurationException {
        Document document = RaXmlUtils.getDocument(raXml);
        NodeList resourceAdapterList = document.getElementsByTagName(RESOURCE_ADAPTER_NAME);
        for (int i2 = 0; i2 < resourceAdapterList.getLength(); ++i2) {
            Node adapter = resourceAdapterList.item(i2);
            NamedNodeMap attributes = adapter.getAttributes();
            for (int j2 = 0; j2 < attributes.getLength(); ++j2) {
                String key = attributes.item(j2).getNodeName();
                String value = attributes.item(j2).getNodeValue();
                if (!ID_NAME.equals(key)) continue;
                return value;
            }
        }
        return defaultValue;
    }

    public static Map<String, Map<String, String>> getConnectionFactoryInterfaces(File raXml) throws ParserConfigurationException, IOException, SAXException {
        NodeList resourceAdapterList;
        String connectionFacotoryInterface;
        String value;
        String key;
        String name;
        Node child;
        HashMap<String, Map<String, String>> connectionFactoryInterfaces = new HashMap<String, Map<String, String>>();
        Document document = RaXmlUtils.getDocument(raXml);
        NodeList connectionDefinitionList = document.getElementsByTagName(CONNECTION_DEFINITION_NAME);
        for (int i2 = 0; i2 < connectionDefinitionList.getLength(); ++i2) {
            HashMap<String, String> properties = new HashMap<String, String>();
            Node item = connectionDefinitionList.item(i2);
            NodeList children = item.getChildNodes();
            for (int j2 = 0; j2 < children.getLength(); ++j2) {
                child = children.item(j2);
                name = child.getNodeName();
                if (name.equals(CONFIG_PROPERTY_NAME)) {
                    key = RaXmlUtils.getConfigPropertyName(child);
                    value = RaXmlUtils.getConfigPropertyValue(child);
                    properties.put(key, value);
                    continue;
                }
                if (!name.equals(CONNECTION_FACTORY_INTERFACE_NAME) || child.getFirstChild() == null) continue;
                connectionFacotoryInterface = child.getFirstChild().getNodeValue().trim();
                connectionFactoryInterfaces.put(connectionFacotoryInterface, properties);
            }
        }
        if (connectionFactoryInterfaces.size() == 0 && (resourceAdapterList = document.getElementsByTagName(RESOURCE_ADAPTER_NAME)).getLength() == 1) {
            Node resourceAdapter = resourceAdapterList.item(0);
            NodeList children = resourceAdapter.getChildNodes();
            HashMap<String, String> properties = new HashMap<String, String>();
            for (int i3 = 0; i3 < children.getLength(); ++i3) {
                child = children.item(i3);
                name = child.getNodeName();
                if (name.equals(CONFIG_PROPERTY_NAME)) {
                    key = RaXmlUtils.getConfigPropertyName(child);
                    value = RaXmlUtils.getConfigPropertyValue(child);
                    if (key == null) continue;
                    properties.put(key, value);
                    continue;
                }
                if (!name.equals(CONNECTION_FACTORY_INTERFACE_NAME) || child.getFirstChild() == null) continue;
                connectionFacotoryInterface = child.getFirstChild().getNodeValue().trim();
                connectionFactoryInterfaces.put(connectionFacotoryInterface, properties);
            }
        }
        return connectionFactoryInterfaces;
    }

    public static Map<String, Map<String, String>> getAdminObjectInterfaces(File raXml) throws ParserConfigurationException, IOException, SAXException {
        HashMap<String, Map<String, String>> adminObjectInterfaces = new HashMap<String, Map<String, String>>();
        Document document = RaXmlUtils.getDocument(raXml);
        NodeList adminObjectList = document.getElementsByTagName(ADMIN_OBJECT_NAME);
        for (int i2 = 0; i2 < adminObjectList.getLength(); ++i2) {
            HashMap<String, String> properties = new HashMap<String, String>();
            Node item = adminObjectList.item(i2);
            NodeList children = item.getChildNodes();
            for (int j2 = 0; j2 < children.getLength(); ++j2) {
                Node child = children.item(j2);
                String name = child.getNodeName();
                if (name.equals(CONFIG_PROPERTY_NAME)) {
                    String key = RaXmlUtils.getConfigPropertyName(child);
                    String value = RaXmlUtils.getConfigPropertyValue(child);
                    if (key == null) continue;
                    properties.put(key, value);
                    continue;
                }
                if (!name.equals(ADMIN_OBJECT_INTERFACE_NAME) || child.getFirstChild() == null) continue;
                String adminObjectInterface = child.getFirstChild().getNodeValue().trim();
                adminObjectInterfaces.put(adminObjectInterface, properties);
            }
        }
        return adminObjectInterfaces;
    }

    private static String getConfigPropertyName(Node configProperty) {
        NodeList children = configProperty.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            String name = child.getNodeName();
            if (!name.equals(CONFIG_PROPERTY_KEY_NAME) || child.getFirstChild() == null) continue;
            return child.getFirstChild().getNodeValue().trim();
        }
        return null;
    }

    private static String getConfigPropertyValue(Node configProperty) {
        NodeList children = configProperty.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            String name = child.getNodeName();
            if (!name.equals(CONFIG_PROPERTY_VALUE_NAME) || child.getFirstChild() == null) continue;
            return child.getFirstChild().getNodeValue().trim();
        }
        return "";
    }

    private static Document getDocument(File raXml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>".getBytes()));
            }
        });
        Document document = documentBuilder.parse(raXml);
        return document;
    }
}

