/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.aes;

import com.bes.enterprise.appserver.common.aes.AESAlgorithm;
import com.bes.enterprise.cipher.crypto.BlockCipher;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.PBEParametersGenerator;
import com.bes.enterprise.cipher.crypto.engines.AESEngine;
import com.bes.enterprise.cipher.crypto.generators.PKCS5S2ParametersGenerator;
import com.bes.enterprise.cipher.crypto.modes.CFBBlockCipher;
import com.bes.enterprise.cipher.crypto.paddings.PaddedBufferedBlockCipher;
import com.bes.enterprise.cipher.crypto.params.KeyParameter;
import com.bes.enterprise.cipher.crypto.params.ParametersWithIV;

public class GMAES
implements AESAlgorithm {
    @Override
    public byte[] encrypt(String content) throws Exception {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESEngine(), 128));
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(this.getSecretKey()), DEFAULT_IV);
        aes.init(true, (CipherParameters)ivAndKey);
        return this.cipherData(aes, content.getBytes());
    }

    @Override
    public String decrypt(byte[] cipherText) throws Exception {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESEngine(), 128));
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(this.getSecretKey()), DEFAULT_IV);
        aes.init(false, (CipherParameters)ivAndKey);
        byte[] decryptedBytes = this.cipherData(aes, cipherText);
        return new String(decryptedBytes);
    }

    private byte[] cipherData(PaddedBufferedBlockCipher cipher, byte[] data) throws Exception {
        int minSize = cipher.getOutputSize(data.length);
        byte[] outBuf = new byte[minSize];
        int length1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int length2 = cipher.doFinal(outBuf, length1);
        int actualLength = length1 + length2;
        byte[] result = new byte[actualLength];
        System.arraycopy(outBuf, 0, result, 0, result.length);
        return result;
    }

    private byte[] getSecretKey() {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])PASSWORD.toCharArray()), PASSWORD.getBytes(), 1024);
        KeyParameter params = (KeyParameter)generator.generateDerivedParameters(128);
        return params.getKey();
    }
}

