/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class LoginInfo
implements Comparable<LoginInfo> {
    private String host;
    private int port;
    private String user;
    private String password;

    public LoginInfo(String host, int port, String user, String password) {
        if (host == null || port < 0 || user == null || password == null) {
            throw new IllegalArgumentException("null value");
        }
        this.init(host, port, user, password);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object other) {
        boolean same = false;
        if (other instanceof LoginInfo) {
            boolean sameHost;
            LoginInfo that = (LoginInfo)other;
            try {
                InetAddress thatHost = InetAddress.getByName(that.getHost());
                InetAddress thisHost = InetAddress.getByName(this.host);
                sameHost = thatHost.equals(thisHost);
            }
            catch (UnknownHostException e2) {
                sameHost = this.host.equals(that.host);
            }
            same = sameHost && this.port == that.port && this.user.equals(that.user) && this.password.equals(that.password);
        }
        return same;
    }

    public int hashCode() {
        return 31 * this.host.hashCode() + 23 * this.port + 53 * this.user.hashCode() + 13 * this.password.hashCode();
    }

    private void init(String host, int port, String user, String password) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public String toString() {
        return this.host + this.port + this.user + this.password;
    }

    @Override
    public int compareTo(LoginInfo that) {
        String thisKey = this.user + this.host + this.port;
        String thatKey = that.user + that.host + that.port;
        return thisKey.compareTo(thatKey);
    }
}

