/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.digest;

import com.bes.enterprise.appserver.common.digest.ChallengeParseException;
import com.bes.enterprise.appserver.common.digest.Rfc2616AbnfParser;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;

public class DigestChallenge {
    private static final String HTTP_DIGEST_CHALLENGE_PREFIX = "digest";
    private static final Pattern HTTP_DIGEST_CHALLENGE_REGEXP = Pattern.compile("digest\\s", 2);
    private final String quotedRealm;
    private final String quotedNonce;
    private final String quotedOpaque;
    private final String quotedDomain;
    private final String algorithm;
    private final Set<QualityOfProtection> supportedQops;
    private final boolean stale;

    private DigestChallenge(String realm, String nonce, String quotedDomain, String quotedOpaque, String algorithm, Set<QualityOfProtection> supportedQops, boolean stale) {
        this.quotedRealm = realm;
        this.quotedNonce = nonce;
        this.quotedDomain = quotedDomain;
        this.quotedOpaque = quotedOpaque;
        this.algorithm = algorithm;
        this.supportedQops = supportedQops;
        this.stale = stale;
    }

    public static boolean isDigestChallenge(String challenge) {
        return HTTP_DIGEST_CHALLENGE_REGEXP.matcher(challenge).lookingAt();
    }

    public static DigestChallenge parse(String challengeString) throws ChallengeParseException {
        Rfc2616AbnfParser parser = new Rfc2616AbnfParser(challengeString);
        try {
            parser.consumeLiteral(HTTP_DIGEST_CHALLENGE_PREFIX);
            parser.consumeRws();
            String quotedRealm = null;
            String quotedNonce = null;
            String quotedOpaque = null;
            String quotedDomain = null;
            String algorithm = null;
            String qopOptions = null;
            boolean stale = false;
            while (parser.hasMoreData()) {
                String token = parser.consumeToken().get();
                parser.consumeOws().consumeLiteral("=").consumeOws();
                switch (token) {
                    case "realm": {
                        quotedRealm = parser.consumeQuotedString().get();
                        break;
                    }
                    case "nonce": {
                        quotedNonce = parser.consumeQuotedString().get();
                        break;
                    }
                    case "opaque": {
                        quotedOpaque = parser.consumeQuotedString().get();
                        break;
                    }
                    case "algorithm": {
                        algorithm = Rfc2616AbnfParser.unquoteIfQuoted(parser.consumeQuotedStringOrToken().get());
                        break;
                    }
                    case "qop": {
                        qopOptions = Rfc2616AbnfParser.unquoteIfQuoted(parser.consumeQuotedStringOrToken().get());
                        break;
                    }
                    case "domain": {
                        quotedDomain = parser.consumeQuotedString().get();
                        break;
                    }
                    case "stale": {
                        String staleToken = Rfc2616AbnfParser.unquoteIfQuoted(parser.consumeQuotedStringOrToken().get());
                        stale = staleToken.equalsIgnoreCase("true");
                        break;
                    }
                    default: {
                        parser.consumeQuotedStringOrToken();
                    }
                }
                parser.consumeOws();
                if (!parser.hasMoreData()) continue;
                parser.consumeLiteral(",").consumeOws();
            }
            if (quotedRealm == null) {
                throw new ChallengeParseException("Missing directive 'realm' for challenge: " + challengeString);
            }
            if (quotedNonce == null) {
                throw new ChallengeParseException("Missing directive 'nonce' for challenge: " + challengeString);
            }
            if (algorithm != null && algorithm.endsWith("-sess") && qopOptions == null) {
                throw new ChallengeParseException("Session based algorithm (" + algorithm + ") cannot be used if qop is not set");
            }
            return new DigestChallenge(quotedRealm, quotedNonce, quotedDomain, quotedOpaque, algorithm, DigestChallenge.parseSupportedQopsFromQopOptions(qopOptions), stale);
        }
        catch (Rfc2616AbnfParser.ParseException e2) {
            throw new ChallengeParseException("Malformed challenge: " + challengeString, e2);
        }
    }

    private static Set<QualityOfProtection> parseSupportedQopsFromQopOptions(String qopOptions) {
        if (qopOptions == null) {
            return EnumSet.of(QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE);
        }
        EnumSet<QualityOfProtection> result = EnumSet.noneOf(QualityOfProtection.class);
        for (String supportedQop : qopOptions.split(",")) {
            if (supportedQop.trim().equals("auth")) {
                result.add(QualityOfProtection.AUTH);
                continue;
            }
            if (!supportedQop.trim().equals("auth-int")) continue;
            result.add(QualityOfProtection.AUTH_INT);
        }
        return result;
    }

    public String getQuotedRealm() {
        return this.quotedRealm;
    }

    public String getRealm() {
        return Rfc2616AbnfParser.unquote(this.quotedRealm);
    }

    public String getQuotedDomain() {
        return this.quotedDomain;
    }

    public String getDomain() {
        if (this.quotedDomain != null) {
            return Rfc2616AbnfParser.unquote(this.quotedDomain);
        }
        return null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getQuotedNonce() {
        return this.quotedNonce;
    }

    public String getNonce() {
        return Rfc2616AbnfParser.unquote(this.quotedNonce);
    }

    public String getQuotedOpaque() {
        return this.quotedOpaque;
    }

    public String getOpaque() {
        if (this.quotedOpaque != null) {
            return Rfc2616AbnfParser.unquote(this.quotedOpaque);
        }
        return null;
    }

    public Set<QualityOfProtection> getSupportedQopTypes() {
        return this.supportedQops;
    }

    public boolean isStale() {
        return this.stale;
    }

    public String toString() {
        return "DigestChallenge{realm=" + this.quotedRealm + ", nonce=" + this.quotedNonce + ", opaque=" + this.quotedOpaque + ", algorithm=" + this.algorithm + ", qop=" + this.supportedQops + ", stale=" + this.stale + '}';
    }

    public static enum QualityOfProtection {
        AUTH("auth"),
        AUTH_INT("auth-int"),
        UNSPECIFIED_RFC2069_COMPATIBLE(null);

        private final String qopValue;

        private QualityOfProtection(String qopValue) {
            this.qopValue = qopValue;
        }

        public String getQopValue() {
            return this.qopValue;
        }
    }
}

