/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.digest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Rfc2616AbnfParser {
    private static final boolean[] VALID_TOKEN_CHARS;
    private static final boolean[] VALID_TOKEN68_CHARS_EXCLUDING_EQUALS;
    private static final Pattern QUOTE_PATTERN;
    private static final Pattern UNQUOTE_PATTERN;
    private final String input;
    private int eltStart;
    private int eltEnd;

    public Rfc2616AbnfParser(String input) {
        this.input = input;
    }

    public String get() {
        return this.input.substring(this.eltStart, this.eltEnd);
    }

    public String getInput() {
        return this.input;
    }

    public String getRemainingInput() {
        return this.input.substring(this.eltEnd);
    }

    public int getPos() {
        return this.eltEnd;
    }

    public void setPos(int pos) {
        this.eltStart = this.eltEnd = pos;
    }

    public boolean hasMoreData() {
        return this.eltEnd < this.input.length();
    }

    public boolean isLookingAtLiteral(String literal) {
        if (this.input.length() < this.eltEnd + literal.length()) {
            return false;
        }
        String substring = this.input.substring(this.eltEnd, this.eltEnd + literal.length());
        return substring.equalsIgnoreCase(literal);
    }

    public Rfc2616AbnfParser consumeLiteral(String literal) throws ParseException {
        if (!this.isLookingAtLiteral(literal)) {
            throw new ParseException("Expected literal '" + literal + "'", this);
        }
        this.eltStart = this.eltEnd;
        this.eltEnd += literal.length();
        return this;
    }

    public Rfc2616AbnfParser consumeOws() {
        this.eltStart = this.eltEnd;
        while (this.hasMoreData() && (this.input.charAt(this.eltEnd) == ' ' || this.input.charAt(this.eltEnd) == '\t' || this.input.charAt(this.eltEnd) == '\r' || this.input.charAt(this.eltEnd) == '\n')) {
            ++this.eltEnd;
        }
        return this;
    }

    public Rfc2616AbnfParser consumeRws() throws ParseException {
        if (this.consumeOws().get().length() == 0) {
            throw new ParseException("Expected whitespace", this);
        }
        return this;
    }

    public Rfc2616AbnfParser consumeToken() throws ParseException {
        int tokenEnd;
        for (tokenEnd = this.eltEnd; tokenEnd < this.input.length() && this.isValidTokenChar(this.input.charAt(tokenEnd)); ++tokenEnd) {
        }
        if (this.eltEnd == tokenEnd) {
            throw new ParseException("Expected token", this);
        }
        this.eltStart = this.eltEnd;
        this.eltEnd = tokenEnd;
        return this;
    }

    private boolean isValidTokenChar(char c2) {
        return c2 < VALID_TOKEN_CHARS.length && VALID_TOKEN_CHARS[c2];
    }

    public Rfc2616AbnfParser consumeToken68() throws ParseException {
        int tokenEnd;
        for (tokenEnd = this.eltEnd; tokenEnd < this.input.length() && this.isValidToken68CharExcludingEquals(this.input.charAt(tokenEnd)); ++tokenEnd) {
        }
        while (tokenEnd < this.input.length() && this.input.charAt(tokenEnd) == '=') {
            ++tokenEnd;
        }
        if (this.eltEnd == tokenEnd) {
            throw new ParseException("Expected token68", this);
        }
        this.eltStart = this.eltEnd;
        this.eltEnd = tokenEnd;
        return this;
    }

    private boolean isValidToken68CharExcludingEquals(char c2) {
        return c2 < VALID_TOKEN68_CHARS_EXCLUDING_EQUALS.length && VALID_TOKEN68_CHARS_EXCLUDING_EQUALS[c2];
    }

    public Rfc2616AbnfParser consumeQuotedString() throws ParseException {
        int pos = this.eltEnd;
        if (pos >= this.input.length() || this.input.charAt(pos) != '\"') {
            throw new ParseException("Expected quoted string", this);
        }
        ++pos;
        boolean closingQuoteFound = false;
        while (!closingQuoteFound) {
            int nextQuote = this.input.indexOf("\"", pos);
            if (nextQuote == -1) {
                throw new ParseException("Expected quoted string", this);
            }
            int precedingBackslashes = 0;
            while (this.input.charAt(nextQuote - precedingBackslashes - 1) == '\\') {
                ++precedingBackslashes;
            }
            if (precedingBackslashes % 2 == 0) {
                closingQuoteFound = true;
            }
            pos = nextQuote + 1;
        }
        this.eltStart = this.eltEnd;
        this.eltEnd = pos;
        return this;
    }

    public Rfc2616AbnfParser consumeQuotedStringOrToken() throws ParseException {
        if (this.eltEnd >= this.input.length()) {
            throw new ParseException("Expected token or quoted string", this);
        }
        if (this.input.charAt(this.eltEnd) == '\"') {
            return this.consumeQuotedString();
        }
        return this.consumeToken();
    }

    public static String quote(String str) {
        Matcher matcher = QUOTE_PATTERN.matcher(str);
        return "\"" + matcher.replaceAll("\\\\$0") + "\"";
    }

    public static String unquote(String str) {
        if (str.length() < 2) {
            return str;
        }
        Matcher matcher = UNQUOTE_PATTERN.matcher(str.substring(1, str.length() - 1));
        return matcher.replaceAll("$1");
    }

    public static String unquoteIfQuoted(String str) {
        if (str.startsWith("\"")) {
            return Rfc2616AbnfParser.unquote(str);
        }
        return str;
    }

    public String toString() {
        return "Rfc2616AbnfParser{input='" + this.input + '\'' + ", pos=" + this.eltEnd + ", lastConsumed=" + this.get() + ", remainingInput='" + this.getRemainingInput() + "'" + '}';
    }

    static {
        int c2;
        VALID_TOKEN_CHARS = new boolean[127];
        VALID_TOKEN68_CHARS_EXCLUDING_EQUALS = new boolean[127];
        QUOTE_PATTERN = Pattern.compile("[\"\\\\]");
        UNQUOTE_PATTERN = Pattern.compile("\\\\(.)");
        String separators = "()<>@,;:\\\"/[]?={} \t";
        for (c2 = 0; c2 < VALID_TOKEN_CHARS.length; c2 = (int)((char)(c2 + 1))) {
            Rfc2616AbnfParser.VALID_TOKEN_CHARS[c2] = c2 >= 32 && c2 < 127 && separators.indexOf(c2) == -1;
        }
        String token68Chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~+/";
        for (c2 = 0; c2 < VALID_TOKEN68_CHARS_EXCLUDING_EQUALS.length; c2 = (int)((char)(c2 + 1))) {
            Rfc2616AbnfParser.VALID_TOKEN68_CHARS_EXCLUDING_EQUALS[c2] = token68Chars.indexOf(c2) != -1;
        }
    }

    public static final class ParseException
    extends Exception {
        ParseException(String message) {
            super(message);
        }

        ParseException(String message, Rfc2616AbnfParser parser) {
            this(message + " at pos " + parser.getPos() + ", remaining input: " + parser.getRemainingInput());
        }
    }
}

