/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.digest;

import com.bes.enterprise.appserver.common.digest.ChallengeParseException;
import com.bes.enterprise.appserver.common.digest.Rfc2616AbnfParser;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WwwAuthenticateHeader {
    public static final String HTTP_HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";

    private WwwAuthenticateHeader() {
    }

    public static List<String> extractChallenges(HttpURLConnection connection) throws ChallengeParseException {
        return WwwAuthenticateHeader.extractChallenges(connection.getHeaderFields());
    }

    public static <T extends Iterable<String>> List<String> extractChallenges(Map<String, T> headers) throws ChallengeParseException {
        if (headers.containsKey(HTTP_HEADER_WWW_AUTHENTICATE)) {
            return WwwAuthenticateHeader.extractChallenges((Iterable)headers.get(HTTP_HEADER_WWW_AUTHENTICATE));
        }
        for (String headerName : headers.keySet()) {
            if (!HTTP_HEADER_WWW_AUTHENTICATE.equalsIgnoreCase(headerName)) continue;
            return WwwAuthenticateHeader.extractChallenges((Iterable)headers.get(headerName));
        }
        return Collections.emptyList();
    }

    public static List<String> extractChallenges(Iterable<String> wwwAuthenticateHeaders) throws ChallengeParseException {
        ArrayList<String> result = new ArrayList<String>();
        for (String header : wwwAuthenticateHeaders) {
            WwwAuthenticateHeader.extractChallenges(header, result);
        }
        return result;
    }

    public static List<String> extractChallenges(String wwwAuthenticateHeader) throws ChallengeParseException {
        ArrayList<String> result = new ArrayList<String>();
        WwwAuthenticateHeader.extractChallenges(wwwAuthenticateHeader, result);
        return result;
    }

    private static void extractChallenges(String header, List<String> result) throws ChallengeParseException {
        Rfc2616AbnfParser parser = new Rfc2616AbnfParser(header);
        while (parser.hasMoreData()) {
            try {
                int startOfChallenge = parser.getPos();
                WwwAuthenticateHeader.consumeChallenge(parser);
                result.add(parser.getInput().substring(startOfChallenge, parser.getPos()));
                parser.consumeOws();
                if (!parser.hasMoreData()) continue;
                parser.consumeLiteral(",").consumeOws();
            }
            catch (Rfc2616AbnfParser.ParseException e2) {
                throw new ChallengeParseException(e2);
            }
        }
    }

    private static void consumeChallenge(Rfc2616AbnfParser parser) throws Rfc2616AbnfParser.ParseException {
        parser.consumeToken();
        int savedPos = parser.getPos();
        try {
            WwwAuthenticateHeader.consumeToEndOfEmptyOrAuthParamBasedChallenge(parser);
            return;
        }
        catch (Rfc2616AbnfParser.ParseException parseException) {
            parser.setPos(savedPos);
            try {
                WwwAuthenticateHeader.consumeToEndOfSchemeOnlyChallenge(parser);
                return;
            }
            catch (Rfc2616AbnfParser.ParseException parseException2) {
                parser.setPos(savedPos);
                WwwAuthenticateHeader.consumeToEndOfToken68BasedChallenge(parser);
                return;
            }
        }
    }

    private static void consumeToEndOfSchemeOnlyChallenge(Rfc2616AbnfParser parser) throws Rfc2616AbnfParser.ParseException {
        int pos = parser.getPos();
        try {
            parser.consumeOws();
            if (!WwwAuthenticateHeader.isLookingAtCommaOrStringEnd(parser)) {
                parser.consumeLiteral(",");
            }
        }
        finally {
            parser.setPos(pos);
        }
    }

    private static void consumeToEndOfToken68BasedChallenge(Rfc2616AbnfParser parser) throws Rfc2616AbnfParser.ParseException {
        parser.consumeRws().consumeToken68();
        if (!WwwAuthenticateHeader.isLookingAtCommaOrStringEnd(parser)) {
            parser.consumeLiteral(",");
        }
    }

    private static boolean isLookingAtCommaOrStringEnd(Rfc2616AbnfParser parser) {
        int pos = parser.getPos();
        try {
            parser.consumeOws();
            boolean bl = !parser.hasMoreData() || parser.isLookingAtLiteral(",");
            return bl;
        }
        finally {
            parser.setPos(pos);
        }
    }

    private static void consumeToEndOfEmptyOrAuthParamBasedChallenge(Rfc2616AbnfParser parser) throws Rfc2616AbnfParser.ParseException {
        WwwAuthenticateHeader.consumeAuthParam(parser);
        while (parser.hasMoreData()) {
            int possibleEndOfChallenge = parser.getPos();
            parser.consumeOws();
            if (!parser.hasMoreData()) {
                parser.setPos(possibleEndOfChallenge);
                return;
            }
            parser.consumeLiteral(",").consumeOws();
            if (WwwAuthenticateHeader.tryToConsumeAuthParam(parser)) continue;
            parser.setPos(possibleEndOfChallenge);
            return;
        }
    }

    private static void consumeAuthParam(Rfc2616AbnfParser parser) throws Rfc2616AbnfParser.ParseException {
        parser.consumeOws().consumeToken().consumeOws().consumeLiteral("=").consumeOws().consumeQuotedStringOrToken();
    }

    private static boolean tryToConsumeAuthParam(Rfc2616AbnfParser parser) {
        int originalPos = parser.getPos();
        try {
            WwwAuthenticateHeader.consumeAuthParam(parser);
        }
        catch (Rfc2616AbnfParser.ParseException e2) {
            parser.setPos(originalPos);
            return false;
        }
        return true;
    }
}

