/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocalStringsImpl {
    private ResourceBundle bundle;
    private String propsName = "LocalStrings";
    private static final String thisPackage = "com.bes.enterprise.appserver.common.i18n";
    private static final ResourceBundle.Control rbcontrol = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);

    public LocalStringsImpl() {
        this.setBundle();
    }

    public LocalStringsImpl(Class clazz) {
        this.setBundle(clazz);
    }

    public LocalStringsImpl(Class clazz, Locale locale) {
        this.setBundle(clazz, locale);
    }

    public LocalStringsImpl(String packageName, String propsName) {
        this.propsName = propsName;
        int len = packageName.length();
        if (packageName.charAt(len - 1) != '.') {
            packageName = packageName + '.';
        }
        this.setBundle(packageName);
    }

    public LocalStringsImpl(String packageName) {
        this(packageName, "LocalStrings");
    }

    public String get(String indexString) {
        try {
            return this.getBundle().getString(indexString);
        }
        catch (Exception e2) {
            return indexString;
        }
    }

    public String get(String indexString, Object ... objects) {
        indexString = this.get(indexString);
        try {
            MessageFormat mf = new MessageFormat(indexString);
            return mf.format(objects);
        }
        catch (Exception e2) {
            return indexString;
        }
    }

    public String getString(String indexString, String defaultValue) {
        try {
            return this.getBundle().getString(indexString);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public int getInt(String indexString, int defaultValue) {
        try {
            String s2 = this.getBundle().getString(indexString);
            return Integer.parseInt(s2);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String indexString, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.getBundle().getString(indexString));
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    private ResourceBundle getBundle() {
        return this.bundle;
    }

    private void setBundle() {
        try {
            StackTraceElement[] items = Thread.currentThread().getStackTrace();
            int lastMeOnStack = -1;
            for (int i2 = 0; i2 < items.length; ++i2) {
                StackTraceElement item = items[i2];
                if (!item.getClassName().startsWith(thisPackage)) continue;
                lastMeOnStack = i2;
            }
            String className = items[lastMeOnStack + 1].getClassName();
            this.setBundle(className);
        }
        catch (Exception e2) {
            this.bundle = null;
        }
    }

    private void setBundle(Class clazz, Locale locale) {
        try {
            String className = clazz.getName();
            this.setBundle(className, locale);
            if (this.bundle == null) {
                String props = className.substring(0, className.lastIndexOf(46)) + "." + this.propsName;
                this.bundle = ResourceBundle.getBundle(props, Locale.getDefault(), clazz.getClassLoader(), rbcontrol);
            }
        }
        catch (Exception e2) {
            this.bundle = null;
        }
    }

    private void setBundle(Class clazz) {
        this.setBundle(clazz, null);
    }

    private void setBundle(String className) {
        this.setBundle(className, null);
    }

    private void setBundle(String className, Locale locale) {
        try {
            String props = className.substring(0, className.lastIndexOf(46)) + "." + this.propsName;
            this.bundle = locale == null ? ResourceBundle.getBundle(props, rbcontrol) : ResourceBundle.getBundle(props, locale, rbcontrol);
        }
        catch (Exception e2) {
            this.bundle = null;
        }
    }
}

