/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.loader.parse;

import com.bes.enterprise.appserver.common.loader.ApplicationsVo;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ApplicationsXmlParser {
    private static Logger logger = Logger.getLogger(ApplicationsXmlParser.class.getName());
    private JAXBContext jaxbContext;
    private static ApplicationsXmlParser parser = new ApplicationsXmlParser();

    private ApplicationsXmlParser() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationsVo.class});
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
    }

    public static ApplicationsXmlParser getInstance() {
        return parser;
    }

    private Marshaller makeMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.fragment", (Object)false);
        return marshaller;
    }

    private Unmarshaller makeUnmarshaller() throws JAXBException {
        return this.jaxbContext.createUnmarshaller();
    }

    public ApplicationsVo unmarshal(String data) {
        ApplicationsVo applicationsVo = null;
        try {
            applicationsVo = (ApplicationsVo)this.makeUnmarshaller().unmarshal((Reader)new StringReader(data));
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        return applicationsVo;
    }

    public String marshal(ApplicationsVo applicationsVo) {
        StringWriter writer = new StringWriter();
        try {
            this.makeMarshaller().marshal((Object)applicationsVo, (Writer)writer);
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        return writer.toString();
    }
}

