/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.loader.parse;

import com.bes.enterprise.appserver.common.loader.ClassLoaderInfoVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ClassLoaderInfoXmlParser {
    private static Logger logger = Logger.getLogger(ClassLoaderInfoXmlParser.class.getName());
    private JAXBContext jaxbContext;
    private static ClassLoaderInfoXmlParser parser = new ClassLoaderInfoXmlParser();

    private ClassLoaderInfoXmlParser() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ClassLoaderInfoVo.class});
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
    }

    public static ClassLoaderInfoXmlParser getInstance() {
        return parser;
    }

    private Marshaller makeMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.fragment", (Object)false);
        return marshaller;
    }

    private Unmarshaller makeUnmarshaller() throws JAXBException {
        return this.jaxbContext.createUnmarshaller();
    }

    public ClassLoaderInfoVo unmarshal(String data) {
        ClassLoaderInfoVo ClassLoaderInfoVo2 = null;
        try {
            ClassLoaderInfoVo2 = (ClassLoaderInfoVo)this.makeUnmarshaller().unmarshal((Reader)new StringReader(data));
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        return ClassLoaderInfoVo2;
    }

    public String marshal(ClassLoaderInfoVo ClassLoaderInfoVo2) {
        StringWriter writer = new StringWriter();
        try {
            this.makeMarshaller().marshal((Object)ClassLoaderInfoVo2, (Writer)writer);
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoaderInfoVo unmarshal(File file) {
        ClassLoaderInfoVo ClassLoaderInfoVo2 = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            ClassLoaderInfoVo2 = (ClassLoaderInfoVo)this.makeUnmarshaller().unmarshal((InputStream)inputStream);
        }
        catch (FileNotFoundException | JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ClassLoaderInfoVo2;
    }

    public static void main(String[] args) {
        ClassLoaderInfoVo vo = ClassLoaderInfoXmlParser.getInstance().unmarshal(new File("e:/test/classloader.xml"));
        System.out.println(vo);
        System.out.println(ClassLoaderInfoXmlParser.getInstance().marshal(vo));
    }
}

