/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;
    private ThreadLocal reentrant = new ThreadLocal();

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String record = null;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            record = this.toString();
            super.reset();
        }
        if (record != null) {
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            if (this.reentrant.get() != null) {
                return;
            }
            try {
                this.reentrant.set(this);
                this.logger.logp(this.level, "", "", record);
            }
            finally {
                this.reentrant.set(null);
            }
        }
    }

    public static class NullPrintStream
    extends PrintStream {
        public static final NullPrintStream instance = new NullPrintStream();

        public NullPrintStream() {
            super(new ByteArrayOutputStream(0), false);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean checkError() {
            return false;
        }

        @Override
        protected void setError() {
        }

        @Override
        public void write(int b2) {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
        }

        @Override
        public void print(boolean b2) {
        }

        @Override
        public void print(char c2) {
        }

        @Override
        public void print(int i2) {
        }

        @Override
        public void print(long l2) {
        }

        @Override
        public void print(float f2) {
        }

        @Override
        public void print(double d2) {
        }

        @Override
        public void print(char[] s2) {
        }

        @Override
        public void print(String s2) {
        }

        @Override
        public void print(Object obj) {
        }

        @Override
        public void println() {
        }

        @Override
        public void println(boolean x2) {
        }

        @Override
        public void println(char x2) {
        }

        @Override
        public void println(int x2) {
        }

        @Override
        public void println(long x2) {
        }

        @Override
        public void println(float x2) {
        }

        @Override
        public void println(double x2) {
        }

        @Override
        public void println(char[] x2) {
        }

        @Override
        public void println(String x2) {
        }

        @Override
        public void println(Object x2) {
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream printf(Locale l2, String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream format(Locale l2, String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq) {
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            return this;
        }

        @Override
        public PrintStream append(char c2) {
            return this;
        }
    }

    private class StackTraceObjects {
        private ByteArrayOutputStream stackTraceBuf = new ByteArrayOutputStream();
        private PrintStream stStream = new PrintStream(this.stackTraceBuf, true);
        private String stString;
        private ByteArrayOutputStream comparisonBuf = new ByteArrayOutputStream();
        private int comparisonBufIndex = 0;
        private PrintStream cbStream = new PrintStream(this.comparisonBuf, true);
        private int stackTraceBufBytes = 0;
        private int charsIgnored = 0;

        private StackTraceObjects(Throwable x2) {
            x2.printStackTrace(this.stStream);
            this.stString = this.stackTraceBuf.toString();
            this.stackTraceBufBytes = this.stackTraceBuf.size();
            this.cbStream.println(x2);
        }

        public String toString() {
            return this.stString;
        }

        boolean ignorePrintln(String str) {
            this.cbStream.println(str);
            String cbString = this.comparisonBuf.toString();
            int cbLen = cbString.length();
            if (this.stString.regionMatches(this.charsIgnored, cbString, 0, cbLen)) {
                this.charsIgnored += cbLen;
                this.comparisonBuf.reset();
                return true;
            }
            return false;
        }

        boolean checkCompletion() {
            return this.charsIgnored >= this.stackTraceBufBytes;
        }
    }

    public class LoggingPrintStream
    extends PrintStream {
        LogManager logManager;
        private ThreadLocal perThreadStObjects;
        private ThreadLocal<StringBuilder> perThreadLogger;
        private boolean enableLongLogInLine;

        public LoggingPrintStream(ByteArrayOutputStream os) {
            super(os, true);
            this.logManager = LogManager.getLogManager();
            this.perThreadStObjects = new ThreadLocal();
            this.perThreadLogger = new ThreadLocal();
            this.enableLongLogInLine = Boolean.getBoolean("com.bes.enterprise.log.enableLongLogInLine");
        }

        public void setLogger(Logger l2) {
            LoggingOutputStream.this.logger = l2;
        }

        @Override
        public void println(Object x2) {
            if (x2 == null) {
                return;
            }
            if (x2 instanceof String) {
                this.println((String)x2);
                return;
            }
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects stObject = (StackTraceObjects)this.perThreadStObjects.get();
            if (stObject != null) {
                this.perThreadStObjects.set(null);
            }
            if (!(x2 instanceof Throwable)) {
                this.println(String.valueOf(x2));
                return;
            }
            stObject = new StackTraceObjects((Throwable)x2);
            this.perThreadStObjects.set(stObject);
            LoggingOutputStream.this.logger.log(LoggingOutputStream.this.level, stObject.toString());
        }

        @Override
        public void println(String str) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects stObject = (StackTraceObjects)this.perThreadStObjects.get();
            if (stObject == null) {
                LoggingOutputStream.this.logger.log(LoggingOutputStream.this.level, str);
                return;
            }
            if (!stObject.ignorePrintln(str)) {
                this.perThreadStObjects.set(null);
                LoggingOutputStream.this.logger.log(LoggingOutputStream.this.level, str);
                return;
            }
            if (stObject.checkCompletion()) {
                this.perThreadStObjects.set(null);
                return;
            }
        }

        @Override
        public PrintStream printf(String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format(str, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream printf(Locale locale, String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, locale);
            formatter.format(str, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format(Locale.getDefault(), format, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream format(Locale locale, String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, locale);
            formatter.format(locale, format, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public void print(String x2) {
            this.println(x2);
        }

        @Override
        public void print(Object x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(boolean x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(boolean x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(char x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(char x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(int x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(int x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(long x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(long x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(float x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(float x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(double x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(double x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void print(char[] x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println(char[] x2) {
            this.print(String.valueOf(x2));
        }

        @Override
        public void println() {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (this.enableLongLogInLine) {
                StringBuilder logBuffer = this.perThreadLogger.get();
                if (logBuffer == null) {
                    logBuffer = new StringBuilder(258);
                    this.perThreadLogger.set(logBuffer);
                }
                logBuffer.append(new String(buf, off, len));
                int logBufferLength = logBuffer.length();
                int logEndWithSeparator = logBuffer.lastIndexOf(LoggingOutputStream.this.lineSeparator);
                if (logEndWithSeparator != -1) {
                    this.println(logBuffer.substring(0, logEndWithSeparator).toString());
                    this.perThreadLogger.remove();
                    if (logBufferLength - logEndWithSeparator != 1) {
                        StringBuilder newLogBuffer = new StringBuilder(logBuffer.substring(logEndWithSeparator + 1, logBufferLength));
                        this.perThreadLogger.set(newLogBuffer);
                    }
                }
            } else {
                this.println(new String(buf, off, len));
            }
        }

        @Override
        public void write(int b2) {
            this.println(String.valueOf(b2));
        }

        private boolean checkLocks() {
            Thread t2 = Thread.currentThread();
            if (!Thread.holdsLock(LoggingOutputStream.this.logger)) {
                if (!Thread.holdsLock(this.logManager)) {
                    return true;
                }
            }
            return false;
        }
    }
}

