/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.process;

import com.bes.enterprise.appserver.common.process.ExecException;
import com.bes.enterprise.appserver.common.process.FlusherThread;
import com.bes.enterprise.appserver.common.util.OSUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ProcessExecutor {
    public static final long kDefaultTimeoutMillis = 600000L;
    public static final long kSleepTime = 2000L;
    private static final long DEFAULT_TIMEOUT_SEC = 600L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private long mTimeoutMilliseconds = 0L;
    protected String[] mCmdStrings = null;
    protected File mOutFile = null;
    protected File mErrFile = null;
    private OutputStream mOutStream = null;
    private OutputStream mErrStream = null;
    private File mWorkingDir = null;
    private String[] mEnv = null;
    private String[] mInputLines = null;
    private int mExitValue = -1;
    private Process mSubProcess = null;
    private boolean mVerboseMode = false;
    private boolean retainExecutionLogs = false;
    private String lastExecutionOutputString = null;
    private String lastExecutionErrorString = null;
    private static boolean bDebug = false;

    public ProcessExecutor(String[] cmd) {
        this(cmd, 600L, null);
    }

    public ProcessExecutor(String[] cmd, String[] inputLines) {
        this(cmd, 600L, inputLines);
    }

    public ProcessExecutor(String[] cmd, long timeoutSeconds) {
        this(cmd, timeoutSeconds, null);
    }

    public ProcessExecutor(String[] cmd, long timeoutSeconds, String[] inputLines) {
        this(cmd, timeoutSeconds, inputLines, null, null);
    }

    public ProcessExecutor(String[] cmd, long timeoutSeconds, String[] inputLines, String[] env, File workingDir) {
        this.mCmdStrings = cmd;
        this.mInputLines = inputLines;
        this.mEnv = env;
        this.mWorkingDir = workingDir;
        char fwdSlashChar = '/';
        char backSlashChar = '\\';
        if (System.getProperty("Debug") != null) {
            bDebug = true;
        }
        for (int i2 = 0; i2 < this.mCmdStrings.length; ++i2) {
            this.mCmdStrings[i2] = OSUtils.isUnix() ? this.mCmdStrings[i2].replace(backSlashChar, fwdSlashChar) : this.mCmdStrings[i2].replace(fwdSlashChar, backSlashChar);
        }
        this.mTimeoutMilliseconds = timeoutSeconds * 1000L;
    }

    public void setExecutionRetentionFlag(boolean s2) {
        this.retainExecutionLogs = s2;
    }

    public boolean getExecutionRetentionFlag() {
        return this.retainExecutionLogs;
    }

    public String getLastExecutionError() {
        return this.lastExecutionErrorString;
    }

    public String getLastExecutionOutput() {
        return this.lastExecutionOutputString;
    }

    private void init() throws ExecException {
        try {
            this.mOutFile = File.createTempFile("stdout", null);
            this.mOutFile.deleteOnExit();
            this.mErrFile = File.createTempFile("stderr", null);
            this.mErrFile.deleteOnExit();
        }
        catch (IllegalArgumentException iae) {
            this.deleteTempFiles();
            throw new ExecException("Internal error (util.ProcessExecutor.init()): " + iae.getMessage());
        }
        catch (IOException ioe) {
            this.deleteTempFiles();
            throw new ExecException(ProcessExecutor.cannotCreateTempFiles());
        }
    }

    private static final String cannotCreateTempFiles() {
        return "Could not create temporary files - check " + System.getProperty("java.io.tmpdir") + " to see if its writeable and not-full";
    }

    private void deleteTempFiles() {
        if (this.mOutStream != null) {
            try {
                this.mOutStream.flush();
                this.mOutStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mErrStream != null) {
            try {
                this.mErrStream.flush();
                this.mErrStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mOutFile != null) {
            this.mOutFile.delete();
        }
        if (this.mErrFile != null) {
            this.mErrFile.delete();
        }
    }

    public void execute() throws ExecException {
        this.execute(false);
    }

    public String[] execute(boolean bReturnOutputLines) throws ExecException {
        return this.execute(bReturnOutputLines, true);
    }

    protected String getExceptionMessage() {
        String errorMessage = this.getFileBuffer(this.mErrFile);
        if (errorMessage.length() == 0) {
            errorMessage = "The Process Output: " + this.getLatestOutput(this.mOutFile);
        }
        return "abnormal subprocess termination: Detailed Message:" + errorMessage;
    }

    public String[] execute(boolean bReturnOutputLines, boolean bStartUpTimeLimit) throws ExecException {
        InputStream inputStream;
        block21: {
            this.init();
            inputStream = null;
            try {
                if (bDebug) {
                    System.out.println("\n**** Executing command:");
                    for (int ii = 0; ii < this.mCmdStrings.length; ++ii) {
                        System.out.println(this.mCmdStrings[ii]);
                    }
                }
                this.mSubProcess = Runtime.getRuntime().exec(this.mCmdStrings, this.mEnv, this.mWorkingDir);
                if (this.mInputLines != null) {
                    this.addInputLinesToProcessInput(this.mSubProcess);
                }
                if (!bReturnOutputLines) {
                    this.mOutStream = this.redirectProcessOutput(this.mSubProcess);
                } else {
                    inputStream = this.mSubProcess.getInputStream();
                }
                this.mErrStream = this.redirectProcessError(this.mSubProcess);
                if (!bStartUpTimeLimit) break block21;
                long timeBefore = System.currentTimeMillis();
                boolean timeoutReached = false;
                boolean isSubProcessFinished = false;
                boolean shouldBeDone = false;
                IllegalThreadStateException ex = null;
                while (!shouldBeDone) {
                    block22: {
                        this.sleep(2000L);
                        long timeAfter = System.currentTimeMillis();
                        timeoutReached = timeAfter - timeBefore >= this.mTimeoutMilliseconds;
                        try {
                            this.mExitValue = this.mSubProcess.exitValue();
                            isSubProcessFinished = true;
                        }
                        catch (IllegalThreadStateException itse) {
                            isSubProcessFinished = false;
                            if (!timeoutReached) break block22;
                            ex = itse;
                        }
                    }
                    shouldBeDone = timeoutReached || isSubProcessFinished;
                }
                if (!isSubProcessFinished) {
                    this.mSubProcess.destroy();
                    this.mExitValue = -255;
                    String errorMsg = "Subprocess timed out after " + this.mTimeoutMilliseconds + "ms.";
                    if (ex != null) {
                        errorMsg = errorMsg + "May be reason : " + ex.getMessage();
                    }
                    throw new ExecException(errorMsg);
                }
                this.mExitValue = this.mSubProcess.exitValue();
                if (this.debug()) {
                    System.out.println("Subprocess command line = " + this.a2s(this.mCmdStrings));
                    System.out.println("Subprocess exit value = " + this.mExitValue);
                }
                if (this.mExitValue != 0) {
                    this.mExitValue = this.mSubProcess.exitValue();
                    if (this.mExitValue != 0) {
                        throw new ExecException(this.getExceptionMessage());
                    }
                }
            }
            catch (SecurityException se) {
                throw new ExecException(se.getMessage());
            }
            catch (IOException ioe) {
                throw new ExecException(ioe.getMessage());
            }
            finally {
                this.retainBuffers();
                if (bStartUpTimeLimit) {
                    this.deleteTempFiles();
                }
            }
        }
        if (bReturnOutputLines) {
            return this.getInputStrings(inputStream);
        }
        return null;
    }

    public int getProcessExitValue() {
        return this.mExitValue;
    }

    private void addInputLinesToProcessInput(Process subProcess) throws ExecException {
        if (this.mInputLines == null) {
            return;
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(subProcess.getOutputStream())));
            for (int i2 = 0; i2 < this.mInputLines.length; ++i2) {
                if (bDebug) {
                    System.out.println("InputLine ->" + this.mInputLines[i2] + "<-");
                }
                out.println(this.mInputLines[i2]);
            }
            out.flush();
        }
        catch (Exception e2) {
            throw new ExecException(e2.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private String[] getInputStrings(InputStream inputStream) throws ExecException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader in = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            String str;
            in = new BufferedReader(new InputStreamReader(inputStream));
            while ((str = in.readLine()) != null) {
                list.add(str);
            }
            if (list.size() < 1) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (Exception e2) {
            throw new ExecException(e2.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private OutputStream redirectProcessOutput(Process subProcess) throws ExecException {
        OutputStream out = null;
        try {
            InputStream in = subProcess.getInputStream();
            out = this.mVerboseMode ? System.err : new FileOutputStream(this.mOutFile);
            new FlusherThread(in, out).start();
        }
        catch (Exception e2) {
            throw new ExecException(e2.getMessage());
        }
        return out;
    }

    private OutputStream redirectProcessError(Process subProcess) throws ExecException {
        OutputStream out = null;
        try {
            InputStream in = subProcess.getErrorStream();
            out = this.mVerboseMode ? System.err : new FileOutputStream(this.mErrFile);
            new FlusherThread(in, out).start();
        }
        catch (Exception e2) {
            throw new ExecException(e2.getMessage());
        }
        return out;
    }

    public void setVerbose(boolean verbose) {
        this.mVerboseMode = verbose;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileBuffer(File file) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(NEWLINE);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    protected String getLatestOutput(File f2) {
        return new RAFileReader(f2).readLastBytesAsString();
    }

    public void retainBuffers() {
        if (this.retainExecutionLogs) {
            this.lastExecutionErrorString = this.getLatestOutput(this.mErrFile);
            this.lastExecutionOutputString = this.getLatestOutput(this.mOutFile);
        }
    }

    private boolean debug() {
        String td = System.getProperty("java.io.tmpdir");
        String n2 = "BES_DEBUG_process_executor";
        File f2 = new File(td, "BES_DEBUG_process_executor");
        return f2.exists();
    }

    private String a2s(String[] a2) {
        StringBuffer s2 = new StringBuffer();
        if (a2 != null) {
            for (int i2 = 0; i2 < a2.length; ++i2) {
                s2.append(a2[i2]);
                s2.append(' ');
            }
        }
        return s2.toString();
    }

    public Process getSubProcess() {
        return this.mSubProcess;
    }

    public static void main(String[] args) {
        ProcessExecutor.testProcessError();
    }

    private static void testProcessError() {
        ProcessExecutor executor = new ProcessExecutor(new String[]{"/usr/bin/ls", "-wrongPARAMS123"});
        try {
            executor.execute();
        }
        catch (ExecException ee) {
            System.out.println(ee.getMessage());
        }
    }

    private static class RAFileReader {
        final File file;
        final int LAST_BYTES = 16384;
        final String RMODE = "r";

        RAFileReader(File file) {
            this.file = file;
        }

        String readLastBytesAsString() {
            int n2 = this.getNumberOfBytes(16384);
            StringBuffer sb = new StringBuffer();
            long ln = this.file.length();
            if (ln == 0L) {
                return sb.toString();
            }
            assert ((long)n2 <= ln) : "Asked to read number of bytes more than size of file";
            long s2 = ln - (long)n2;
            return this.readWithoutCheck(s2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readWithoutCheck(long seekPos) {
            StringBuffer sb = new StringBuffer();
            RandomAccessFile rf = null;
            long ln = 0L;
            int lines = 0;
            try {
                rf = new RandomAccessFile(this.file, "r");
                ln = rf.length();
                rf.seek(seekPos);
                String tmp = rf.readLine();
                while (tmp != null) {
                    ++lines;
                    sb.append(tmp);
                    sb.append('\n');
                    tmp = rf.readLine();
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (rf != null) {
                        rf.close();
                    }
                }
                catch (Exception exception) {}
            }
            return sb.toString();
        }

        private int getNumberOfBytes(int max) {
            long ln = this.file.length();
            return (long)max >= ln ? (int)ln : max;
        }
    }
}

