/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.process;

import com.bes.enterprise.appserver.common.i18n.LocalStringsImpl;
import com.bes.enterprise.appserver.common.process.ExecResult;
import com.bes.enterprise.appserver.common.process.ProcessManager;
import com.bes.enterprise.appserver.common.process.ProcessManagerException;
import com.bes.enterprise.appserver.common.util.OSUtils;
import com.bes.enterprise.appserver.common.util.SanitizeFile;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class ProcessUtils {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ProcessUtils.class);
    private static boolean debug;
    private static final int pid;
    private static Date startTime;
    private static final String[] paths;

    public static Date getStartTime() {
        return startTime;
    }

    public static void setStartTime(Date startTime) {
        ProcessUtils.startTime = startTime;
    }

    private ProcessUtils() {
    }

    public static File getExe(String name) {
        for (String path : paths) {
            File f2 = new File(path + "/" + name);
            if (!f2.canExecute()) continue;
            return SanitizeFile.sanitize(f2);
        }
        return null;
    }

    public static final int getPid() {
        return pid;
    }

    public static String kill(int pid) {
        try {
            String cmdline;
            String pidString = Integer.toString(pid);
            ProcessManager pm = null;
            if (OSUtils.isWindowsForSure()) {
                pm = new ProcessManager("taskkill", "/F", "/T", "/pid", pidString);
                cmdline = "taskkill /F /T /pid " + pidString;
            } else {
                pm = new ProcessManager("kill", "-9", "" + pidString);
                cmdline = "kill -9 " + pidString;
            }
            pm.setEcho(false);
            pm.execute();
            int exitValue = pm.getExitValue();
            if (exitValue == 0) {
                return null;
            }
            return strings.get("ProcessUtils.killerror", cmdline, pm.getStderr() + pm.getStdout(), "" + exitValue);
        }
        catch (ProcessManagerException ex) {
            return ex.getMessage();
        }
    }

    public static final Boolean isProcessRunning(int aPid) {
        try {
            if (OSUtils.isWindowsForSure()) {
                return ProcessUtils.isProcessRunningWindows(aPid);
            }
            return ProcessUtils.isProcessRunningUnix(aPid);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static boolean isProcessRunningWindows(int aPid) throws ProcessManagerException {
        String pidString = Integer.toString(aPid);
        ProcessManager pm = new ProcessManager("tasklist", "/FI", "\"pid eq " + pidString + "\"");
        pm.setEcho(false);
        pm.execute();
        String out = pm.getStdout() + pm.getStderr();
        if (debug) {
            System.out.println("------------   Output from tasklist   ----------");
            System.out.println(out);
            System.out.println("------------------------------------------------");
        }
        if (StringUtils.ok(out)) {
            return out.indexOf("" + aPid) >= 0;
        }
        throw new ProcessManagerException("unknown");
    }

    private static Boolean isProcessRunningUnix(int aPid) throws ProcessManagerException {
        ProcessManager pm = new ProcessManager("kill", "-0", "" + aPid);
        pm.setEcho(false);
        pm.execute();
        int retval = pm.getExitValue();
        return retval == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static ExecResult jstack(List<String> options) {
        return ProcessUtils.execJavaTools(ProcessUtils.tryGetRuntimeJavaExec("jstack"), options);
    }

    public static ExecResult jmap(List<String> options) {
        return ProcessUtils.execJavaTools(ProcessUtils.tryGetRuntimeJavaExec("jmap"), options);
    }

    public static String tryGetRuntimeJavaExec(String exec) {
        String javaHome = System.getProperty("com.bes.javaRoot");
        String javaExec = ProcessUtils.validateJavaExec(javaHome, exec);
        if (javaExec != null) {
            return javaExec;
        }
        javaHome = System.getenv("JAVA_HOME");
        javaExec = ProcessUtils.validateJavaExec(javaHome, exec);
        if (javaExec != null) {
            return javaExec;
        }
        return exec;
    }

    public static String validateJavaExec(String fileStr, String exec) {
        File javaBinDir = new File(fileStr, "bin");
        if (javaBinDir.exists() && javaBinDir.isDirectory()) {
            File execFile;
            String binName = exec;
            if (OSUtils.isWindows()) {
                binName = binName + ".exe";
            }
            if ((execFile = new File(javaBinDir, binName)).exists() && execFile.isFile() && execFile.canExecute()) {
                return execFile.getAbsolutePath();
            }
        }
        return null;
    }

    public static ExecResult execJavaTools(String toolName, List<String> options) {
        options.add(0, toolName);
        return ProcessUtils.execSystemCommad(options);
    }

    public static ExecResult execSystemCommad(List<String> options) {
        ExecResult execResult = new ExecResult();
        try {
            String[] cmdArray = options.toArray(new String[0]);
            String cmdString = StringUtils.cat(" ", cmdArray);
            ProcessManager pm = new ProcessManager(cmdArray);
            pm.setEcho(false);
            pm.execute();
            int exitValue = pm.getExitValue();
            String stdout = pm.getStdout();
            String stderr = pm.getStderr();
            execResult.setExitValue(exitValue);
            execResult.setStdout(stdout);
            execResult.setStderr(stderr);
            if (exitValue == 0) {
                execResult.setOk(true);
                return execResult;
            }
            execResult.setOk(false);
            execResult.setErrorMessage(strings.get("ProcessUtils.execerror", cmdString, pm.getStderr() + pm.getStdout(), "" + exitValue));
            return execResult;
        }
        catch (ProcessManagerException ex) {
            execResult.setOk(false);
            execResult.setErrorMessage(ex.getMessage());
            return execResult;
        }
    }

    public static boolean checkGdb() {
        boolean installed = false;
        if (!OSUtils.isWindows()) {
            ArrayList<String> commandOption = new ArrayList<String>();
            commandOption.add("gdb");
            commandOption.add("-v");
            ExecResult execResult = ProcessUtils.execSystemCommad(commandOption);
            String outMsg = execResult.getStdout();
            installed = outMsg.contains("This GDB was configured as") || outMsg.contains("GNU gdb (GDB)");
        }
        return installed;
    }

    public static void main(String[] args) {
        debug = true;
        for (String s2 : args) {
            System.out.println(s2 + " ===> " + ProcessUtils.isProcessRunning(Integer.parseInt(s2)));
        }
    }

    static {
        startTime = new Date(ManagementFactory.getRuntimeMXBean().getStartTime());
        int tempPid = -1;
        try {
            String pids = ManagementFactory.getRuntimeMXBean().getName();
            int index = -1;
            if (StringUtils.ok(pids) && (index = pids.indexOf(64)) >= 0) {
                tempPid = Integer.parseInt(pids.substring(0, index));
            }
        }
        catch (Exception e2) {
            tempPid = -1;
        }
        pid = tempPid;
        String tempPaths = null;
        if (OSUtils.isWindows()) {
            tempPaths = System.getenv("Path");
            if (!StringUtils.ok(tempPaths)) {
                tempPaths = System.getenv("PATH");
            }
        } else {
            tempPaths = System.getenv("PATH");
        }
        paths = StringUtils.ok(tempPaths) ? tempPaths.split(File.pathSeparator) : new String[0];
    }
}

