/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.resource;

import com.bes.enterprise.appserver.common.resource.SharableKey;
import com.bes.enterprise.appserver.common.resource.SharableResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharableResourceContext<K extends SharableKey> {
    private static Logger logger = Logger.getLogger(SharableResourceContext.class.getName());
    private final AtomicInteger depth = new AtomicInteger();
    private Map<K, SharableResource> resources = new HashMap<K, SharableResource>();
    private boolean closed = false;

    public void enlistResource(K resourceKey, SharableResource resource) {
        if (!this.resources.containsKey(resourceKey)) {
            this.resources.put(resourceKey, resource);
        }
    }

    public SharableResource getResource(K resourceKey) {
        SharableResource resource = this.resources.get(resourceKey);
        return resource;
    }

    public void preInvoke() {
        this.depth.incrementAndGet();
    }

    public void postInvoke() {
        int val = this.depth.decrementAndGet();
        if (val <= 0) {
            this.closeResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeResources() {
        try {
            Collection<SharableResource> resourceSet = this.resources.values();
            for (SharableResource shareResource : resourceSet) {
                shareResource.close();
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, th.getMessage(), th);
        }
        finally {
            this.resources.clear();
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

