/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.security;

import com.bes.enterprise.appserver.common.i18n.LocalStringsImpl;
import com.bes.enterprise.appserver.common.security.PrincipalImpl;
import com.bes.enterprise.appserver.common.security.SSHA;
import com.bes.enterprise.appserver.common.security.SharedSecureRandomImpl;
import com.bes.enterprise.appserver.common.security.Utility;
import com.bes.enterprise.appserver.common.util.MD5Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class FileRealmHelper {
    public static final String PARAM_KEYFILE = "file";
    private static final String FIELD_SEP = ";";
    private static final String GROUP_SEP = ",";
    private static final String COMMENT = "#";
    public static final String MISC_VALID_CHARS = "_-.=,";
    private static final int SALT_SIZE = 8;
    private final HashMap<String, User> userTable = new HashMap();
    private final HashMap<String, Integer> groupSizeMap = new HashMap();
    private File keyfile;
    private String keyfileName;
    private static final String DIGEST_SEP = ":";
    private static final String SSHA_TAG = "{SSHA}";
    private static final String SSHA_256_TAG = "{SSHA256}";
    private static final String algoSHA = "SHA";
    private static final String algoSHA256 = "SHA-256";
    private static final String resetKey = "RESET";
    private static final LocalStringsImpl strings = new LocalStringsImpl(FileRealmHelper.class);

    public FileRealmHelper(String realmName, String keyfileName) throws IOException {
        File parent;
        this.keyfileName = realmName;
        this.keyfile = new File(keyfileName);
        if (!this.keyfile.isAbsolute()) {
            String userDir = System.getProperty("com.bes.instanceRoot") + File.separator + "conf" + File.separator + "security";
            this.keyfile = new File(userDir, keyfileName);
        }
        if ((parent = this.keyfile.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (!this.keyfile.exists()) {
            this.keyfile.createNewFile();
        }
        this.loadKeyFile();
    }

    public Set<String> getUserNames() {
        return this.userTable.keySet();
    }

    public User getUser(String name) {
        return this.userTable.get(name);
    }

    public Set<String> getGroupNames() {
        return this.groupSizeMap.keySet();
    }

    public String[] getGroupNames(String username) {
        User ud = this.userTable.get(username);
        if (ud == null) {
            return null;
        }
        return ud.getGroups();
    }

    public String getDescription(String username) {
        User ud = this.userTable.get(username);
        if (ud == null) {
            return null;
        }
        return ud.getDescription();
    }

    public String[] authenticate(String user, char[] password) {
        User ud = this.userTable.get(user);
        if (ud == null) {
            return null;
        }
        if (resetKey.equals(ud.getAlgo())) {
            return null;
        }
        boolean ok = false;
        try {
            ok = SSHA.verify(ud.getSalt(), ud.getHash(), Utility.convertCharArrayToByteArray(password, Charset.defaultCharset().displayName()), ud.getAlgo());
        }
        catch (Exception e2) {
            return null;
        }
        if (!ok) {
            return null;
        }
        return ud.getGroups();
    }

    public boolean hasAuthenticatableUser() {
        for (User ud : this.userTable.values()) {
            if (resetKey.equals(ud.getAlgo())) continue;
            return true;
        }
        return false;
    }

    private static boolean isValid(String s2, boolean userName) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (Character.isLetterOrDigit(c2) || Character.isWhitespace(c2) || MISC_VALID_CHARS.indexOf(c2) != -1 || userName && c2 == '@') continue;
            return false;
        }
        return true;
    }

    public static void validateUserName(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            String msg = strings.get("filerealm.noname");
            throw new IllegalArgumentException(msg);
        }
        if (name.contains(FIELD_SEP)) {
            String msg = strings.get("filerealm.badname", name);
            throw new IllegalArgumentException(msg);
        }
        if (!name.equals(name.trim())) {
            String msg = strings.get("filerealm.badspaces", name);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validatePassword(char[] pwd) throws IllegalArgumentException {
        if (Arrays.equals(null, pwd)) {
            String msg = strings.get("filerealm.emptypwd");
            throw new IllegalArgumentException(msg);
        }
        for (char c2 : pwd) {
            if (!Character.isSpaceChar(c2)) continue;
            String msg = strings.get("filerealm.badspacespwd");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validateGroupName(String group) throws IllegalArgumentException {
        if (group == null || group.length() == 0) {
            String msg = strings.get("filerealm.nogroup");
            throw new IllegalArgumentException(msg);
        }
        if (!FileRealmHelper.isValid(group, false)) {
            String msg = strings.get("filerealm.badchars", group);
            throw new IllegalArgumentException(msg);
        }
        if (!group.equals(group.trim())) {
            String msg = strings.get("filerealm.badspaces", group);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validateGroupList(String[] groupList) throws IllegalArgumentException {
        if (groupList == null || groupList.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < groupList.length; ++i2) {
            FileRealmHelper.validateGroupName(groupList[i2]);
        }
    }

    public synchronized void addUser(String name, String password, String[] groupList, String description) throws IllegalArgumentException {
        FileRealmHelper.validateUserName(name);
        FileRealmHelper.validatePassword(password.toCharArray());
        FileRealmHelper.validateGroupList(groupList);
        if (this.userTable.containsKey(name)) {
            String msg = strings.get("filerealm.dupuser");
            throw new IllegalArgumentException(msg);
        }
        this.addGroupNames(groupList);
        User ud = FileRealmHelper.createNewUser(this, name, password.toCharArray(), groupList, description);
        this.userTable.put(name, ud);
    }

    public synchronized void addUser(User user) {
        this.addGroupNames(user.getGroups());
        this.userTable.put(user.getName(), user);
    }

    public synchronized void addUser(String name, String password, String[] groupList) throws IllegalArgumentException {
        this.addUser(name, password, groupList, "");
    }

    public synchronized void removeUser(String name) throws IllegalArgumentException {
        if (!this.userTable.containsKey(name)) {
            String msg = strings.get("filerealm.nouser", name);
            throw new IllegalArgumentException(msg);
        }
        User oldUser = this.userTable.get(name);
        this.userTable.remove(name);
        this.reduceGroups(oldUser.getGroups());
    }

    public synchronized void updateUser(String name, String newName, String password, String[] groups) throws IllegalArgumentException {
        this.updateUser(name, newName, password, groups, "");
    }

    public synchronized void updateUser(String name, String newName, String password, String[] groups, String description) throws IllegalArgumentException {
        FileRealmHelper.validateUserName(name);
        if (!this.userTable.containsKey(name)) {
            String msg = strings.get("filerealm.nouser", name);
            throw new IllegalArgumentException(msg);
        }
        FileRealmHelper.validateUserName(newName);
        FileRealmHelper.validateGroupList(groups);
        if (null != password && !"".equals(password)) {
            FileRealmHelper.validatePassword(password.toCharArray());
        }
        if (!name.equals(newName) && this.userTable.containsKey(newName)) {
            String msg = strings.get("filerealm.dupuser");
            throw new IllegalArgumentException(msg);
        }
        User oldUser = this.userTable.get(name);
        assert (oldUser != null);
        User newUser = new User(newName);
        if (groups != null) {
            this.changeGroups(oldUser.getGroups(), groups);
            newUser.setGroups(groups);
        } else {
            newUser.setGroups(oldUser.getGroups());
        }
        if (password == null || "".equals(password)) {
            newUser.setSalt(oldUser.getSalt());
            newUser.setHash(oldUser.getHash());
            if (oldUser.getAlgo().equals(resetKey)) {
                newUser.setAlgo(algoSHA256);
            } else {
                newUser.setAlgo(oldUser.getAlgo());
            }
        } else {
            FileRealmHelper.setPassword(this, newUser, password.toCharArray());
            newUser.setAlgo(algoSHA256);
        }
        if (description != null) {
            newUser.setDescription(description);
        } else {
            newUser.setDescription(oldUser.getDescription());
        }
        this.userTable.remove(name);
        this.userTable.put(newName, newUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws IOException {
        Class<FileRealmHelper> clazz = FileRealmHelper.class;
        synchronized (FileRealmHelper.class) {
            try (FileOutputStream out = null;){
                out = new FileOutputStream(this.keyfile);
                for (Map.Entry<String, User> uval : this.userTable.entrySet()) {
                    String algo = uval.getValue().getAlgo();
                    String entry = FileRealmHelper.encodeUser(uval.getKey(), uval.getValue(), algo);
                    out.write(entry.getBytes());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void addGroupNames(String[] groupList) {
        if (groupList != null) {
            for (int i2 = 0; i2 < groupList.length; ++i2) {
                Integer groupSize = this.groupSizeMap.get(groupList[i2]);
                this.groupSizeMap.put(groupList[i2], groupSize != null ? groupSize + 1 : 1);
            }
        }
    }

    private void reduceGroups(String[] groupList) {
        if (groupList != null) {
            for (int i2 = 0; i2 < groupList.length; ++i2) {
                Integer groupSize = this.groupSizeMap.get(groupList[i2]);
                if (groupSize == null) continue;
                int gpSize = groupSize - 1;
                if (gpSize > 0) {
                    this.groupSizeMap.put(groupList[i2], gpSize);
                    continue;
                }
                this.groupSizeMap.remove(groupList[i2]);
            }
        }
    }

    private void changeGroups(String[] oldGroupList, String[] newGroupList) {
        this.addGroupNames(newGroupList);
        this.reduceGroups(oldGroupList);
    }

    private void loadKeyFile() throws IOException {
        File filePath = this.keyfile;
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(filePath));
            while (input.ready()) {
                String line = input.readLine();
                if (line.startsWith(COMMENT) || line.indexOf(FIELD_SEP) <= 0) continue;
                User ud = FileRealmHelper.decodeUser(line, this.groupSizeMap);
                this.userTable.put(ud.getName(), ud);
            }
        }
        catch (Exception e2) {
            throw new IOException(e2.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String encodeUser(String name, User ud, String algo) {
        StringBuilder sb = new StringBuilder();
        Object cryptPwd = null;
        sb.append(name);
        sb.append(FIELD_SEP);
        if (resetKey.equals(algo)) {
            sb.append(resetKey);
        } else {
            String ssha = SSHA.encode(ud.getSalt(), ud.getHash(), algo);
            sb.append(ssha);
        }
        sb.append(FIELD_SEP);
        String[] groups = ud.getGroups();
        if (groups != null) {
            for (int grp = 0; grp < groups.length; ++grp) {
                if (grp > 0) {
                    sb.append(GROUP_SEP);
                }
                sb.append(groups[grp]);
            }
        }
        if (null != ud.getDescription() && !"".equals(ud.getDescription())) {
            sb.append(FIELD_SEP);
            sb.append(ud.getDescription());
        }
        sb.append("\n");
        return sb.toString();
    }

    private static User decodeUser(String encodedLine, Map newGroupSizeMap) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(encodedLine, FIELD_SEP);
        String algo = algoSHA256;
        String user = null;
        String pwdInfo = null;
        String groupList = null;
        String description = null;
        try {
            user = st.nextToken();
            pwdInfo = st.nextToken();
        }
        catch (Exception e2) {
            String msg = strings.get("filerealm.syntaxerror", encodedLine);
            throw new IllegalArgumentException(msg);
        }
        if (st.hasMoreTokens()) {
            groupList = st.nextToken();
        }
        if (st.hasMoreElements()) {
            description = st.nextToken();
        }
        User ud = new User(user);
        if (resetKey.equals(pwdInfo)) {
            ud.setAlgo(resetKey);
        } else {
            if (encodedLine.contains(SSHA_TAG)) {
                algo = algoSHA;
            }
            int resultLength = 32;
            if (algoSHA.equals(algo)) {
                resultLength = 20;
            }
            byte[] hash = new byte[resultLength];
            byte[] salt = SSHA.decode(pwdInfo, hash, algo);
            ud.setHash(hash);
            ud.setSalt(salt);
            ud.setAlgo(algo);
        }
        ArrayList<String> membership = new ArrayList<String>();
        if (groupList != null) {
            StringTokenizer gst = new StringTokenizer(groupList, GROUP_SEP);
            while (gst.hasMoreTokens()) {
                String g2 = gst.nextToken();
                membership.add(g2);
                Integer groupSize = (Integer)newGroupSizeMap.get(g2);
                newGroupSizeMap.put(g2, groupSize != null ? groupSize + 1 : 1);
            }
        }
        ud.setGroups(membership.toArray(new String[0]));
        ud.setDescription(description);
        return ud;
    }

    private static User createNewUser(FileRealmHelper helper, String name, char[] pwd, String[] groups, String description) {
        User ud = new User(name);
        if (groups == null) {
            groups = new String[]{};
        }
        ud.setGroups(groups);
        ud.setDescription(description);
        ud.setAlgo(algoSHA256);
        FileRealmHelper.setPassword(helper, ud, pwd);
        return ud;
    }

    public static String encodePassword(String password) {
        byte[] pwdBytes = null;
        try {
            pwdBytes = Utility.convertCharArrayToByteArray(password.toCharArray(), Charset.defaultCharset().displayName());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        SecureRandom rng = SharedSecureRandomImpl.get();
        byte[] salt = new byte[8];
        rng.nextBytes(salt);
        byte[] hash = SSHA.compute(salt, pwdBytes, algoSHA256);
        String encodePassword = SSHA.encode(salt, hash, algoSHA256);
        return encodePassword;
    }

    private static void setPassword(FileRealmHelper helper, User user, char[] pwd) throws IllegalArgumentException {
        assert (user != null);
        byte[] pwdBytes = null;
        try {
            pwdBytes = Utility.convertCharArrayToByteArray(pwd, Charset.defaultCharset().displayName());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        byte[] salt = FileRealmHelper.getUserSalt(helper, user.getName(), pwdBytes);
        user.setSalt(salt);
        String algo = user.getAlgo();
        if (algo == null) {
            algo = algoSHA256;
        }
        byte[] hash = SSHA.compute(salt, pwdBytes, algo);
        user.setHash(hash);
    }

    private static byte[] getUserSalt(FileRealmHelper helper, String user, byte[] pwdBytes) {
        return FileRealmHelper.getUserSalt(helper.keyfileName, user, pwdBytes);
    }

    public static byte[] getUserSalt(String realmName, String user, byte[] pwdBytes) {
        byte[] colonBytes = DIGEST_SEP.getBytes(Charset.defaultCharset());
        byte[] userBytes = user.getBytes(Charset.defaultCharset());
        byte[] realmBytes = realmName.getBytes(Charset.defaultCharset());
        byte[] combinedBytes = new byte[userBytes.length + colonBytes.length + realmBytes.length + colonBytes.length + pwdBytes.length];
        int index = 0;
        System.arraycopy(userBytes, 0, combinedBytes, index, userBytes.length);
        System.arraycopy(colonBytes, 0, combinedBytes, index += userBytes.length, colonBytes.length);
        System.arraycopy(realmBytes, 0, combinedBytes, index += colonBytes.length, realmBytes.length);
        System.arraycopy(colonBytes, 0, combinedBytes, index += realmBytes.length, colonBytes.length);
        System.arraycopy(pwdBytes, 0, combinedBytes, index += colonBytes.length, pwdBytes.length);
        byte[] salt = MD5Util.md5Byte(combinedBytes);
        return salt;
    }

    private static byte[] getRandomSalt() {
        SecureRandom rng = SharedSecureRandomImpl.get();
        byte[] salt = new byte[8];
        rng.nextBytes(salt);
        return salt;
    }

    public static class User
    extends PrincipalImpl {
        private String[] groups;
        private String realm;
        private byte[] salt;
        private byte[] hash;
        private String algo;
        private String description;

        public User(String name) {
            super(name);
        }

        public User(String name, String[] groups, String realm, byte[] salt, byte[] hash, String algo) {
            super(name);
            this.groups = groups;
            this.realm = realm;
            this.hash = hash;
            this.salt = salt;
            this.algo = algo;
        }

        public User(String name, String[] groups, String realm, byte[] salt, byte[] hash, String algo, String description) {
            super(name);
            this.groups = groups;
            this.realm = realm;
            this.hash = hash;
            this.salt = salt;
            this.algo = algo;
            this.description = description;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public void setSalt(byte[] salt) {
            this.salt = salt;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public void setHash(byte[] hash) {
            this.hash = hash;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public void setGroups(String[] grp) {
            this.groups = grp;
        }

        public String getAlgo() {
            return this.algo;
        }

        public void setAlgo(String algo) {
            this.algo = algo;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

