/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RoleMapper {
    private String appName;
    private String realmName;
    private final Map<String, Set<String>> roleToPrincipal = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> roleToGroup = new HashMap<String, Set<String>>();

    public RoleMapper(String appName) {
        this.appName = appName;
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void addPrincipals(String roleName, Set<String> principals) {
        if (roleName != null && principals != null) {
            this.roleToPrincipal.put(roleName, principals);
        }
    }

    public void addGroups(String roleName, Set<String> groups) {
        if (roleName != null && groups != null) {
            this.roleToGroup.put(roleName, groups);
        }
    }

    public void removeRole(String roleName) {
        if (roleName != null) {
            this.roleToGroup.remove(roleName);
            this.roleToPrincipal.remove(roleName);
        }
    }

    public boolean mappingGroup(String roleName, Set<String> groups) {
        Set<String> mappingGroups = this.roleToGroup.get(roleName);
        if (groups == null || mappingGroups == null) {
            return false;
        }
        for (String mappingGroup : mappingGroups) {
            if (mappingGroup == null || mappingGroup.isEmpty() || !groups.contains(mappingGroup)) continue;
            return true;
        }
        return false;
    }

    public boolean mappingPrincipal(String roleName, String principal) {
        Set<String> mappingPrincipals = this.roleToPrincipal.get(roleName);
        boolean find = false;
        if (principal != null && mappingPrincipals != null) {
            for (String mappingPrincipal : mappingPrincipals) {
                if (!principal.equals(mappingPrincipal)) continue;
                find = true;
                break;
            }
        }
        return find;
    }

    public Set<String> getRoleToPrincipals(String roleName) {
        if (roleName == null) {
            return Collections.emptySet();
        }
        Set<String> mappingPrincipals = this.roleToPrincipal.get(roleName);
        if (mappingPrincipals == null || mappingPrincipals.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(mappingPrincipals);
    }

    public Set<String> getRoleToGroups(String roleName) {
        if (roleName == null) {
            return Collections.emptySet();
        }
        Set<String> mappingGroups = this.roleToGroup.get(roleName);
        if (mappingGroups == null || mappingGroups.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(mappingGroups);
    }
}

