/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.security;

import com.bes.enterprise.appserver.common.security.RoleMapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class RoleMapperFactory {
    private static RoleMapperFactory factory = new RoleMapperFactory();
    private Map CONTEXT_TO_APPNAME = new HashMap();
    private Hashtable ROLEMAPPER = new Hashtable();

    private RoleMapperFactory() {
    }

    public static RoleMapperFactory getInstance() {
        return factory;
    }

    public RoleMapper getRoleMapper(String appName) {
        return this.getRoleMapper(appName, true);
    }

    public RoleMapper getRoleMapper(String appName, boolean create) {
        String contextId = appName;
        String appname = this.getAppNameForContext(appName);
        RoleMapper srm = null;
        if (appname != null) {
            srm = this.getRoleMapper(appname, this, create);
        }
        if (srm == null) {
            srm = this.getRoleMapper(contextId, this, create);
        }
        return srm;
    }

    public void addGlobalRoleMapper(String realmName, String globalRoleName, Set<String> principas, Set<String> groups) {
        if (realmName == null) {
            return;
        }
        for (Map.Entry entry : this.ROLEMAPPER.entrySet()) {
            String appName = (String)entry.getKey();
            RoleMapper roleMapper = (RoleMapper)entry.getValue();
            if (roleMapper == null || !realmName.equals(roleMapper.getRealmName())) continue;
            roleMapper.addGroups(globalRoleName, groups);
            roleMapper.addPrincipals(globalRoleName, principas);
        }
    }

    public void removeGlobalRoleMapper(String realmName, String globalRoleName) {
        if (realmName == null) {
            return;
        }
        for (Map.Entry entry : this.ROLEMAPPER.entrySet()) {
            RoleMapper roleMapper = (RoleMapper)entry.getValue();
            if (roleMapper == null || !realmName.equals(roleMapper.getRealmName())) continue;
            roleMapper.removeRole(globalRoleName);
        }
    }

    public String getAppNameForContext(String contextId) {
        return (String)this.CONTEXT_TO_APPNAME.get(contextId);
    }

    public void setAppNameForContext(String appName, String contextId) {
        this.CONTEXT_TO_APPNAME.put(contextId, appName);
    }

    public void removeAppNameForContext(String contextId) {
        this.CONTEXT_TO_APPNAME.remove(contextId);
    }

    public RoleMapper getRoleMapper(String appName, RoleMapperFactory fact) {
        return this.getRoleMapper(appName, fact, true);
    }

    public RoleMapper getRoleMapper(String appName, RoleMapperFactory fact, boolean create) {
        RoleMapper r2 = (RoleMapper)this.ROLEMAPPER.get(appName);
        if (create && r2 == null) {
            r2 = new RoleMapper(appName);
            this.ROLEMAPPER.put(appName, r2);
        }
        return r2;
    }

    public void setRoleMapper(String appName, RoleMapper rmap) {
        this.ROLEMAPPER.put(appName, rmap);
    }

    public void removeRoleMapper(String appName) {
        if (this.ROLEMAPPER.containsKey(appName)) {
            this.ROLEMAPPER.remove(appName);
        }
    }
}

