/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.security;

import com.bes.enterprise.appserver.common.i18n.LocalStringsImpl;
import com.bes.enterprise.appserver.common.util.SecurityUtil;
import java.security.MessageDigest;
import java.util.Arrays;

public class SSHA {
    private static final String SSHA_TAG = "{SSHA}";
    private static final String SSHA_256_TAG = "{SSHA256}";
    private static final String algoSHA = "SHA";
    private static final String algoSHA256 = "SHA-256";
    public static String defaultAlgo = "SHA-256";
    private static final LocalStringsImpl strings = new LocalStringsImpl(SSHA.class);

    public static byte[] compute(byte[] salt, byte[] password, String algo) throws IllegalArgumentException {
        byte[] buff = new byte[password.length + salt.length];
        System.arraycopy(password, 0, buff, 0, password.length);
        System.arraycopy(salt, 0, buff, password.length, salt.length);
        byte[] hash = null;
        boolean isSHA = false;
        if (algoSHA.equals(algo)) {
            isSHA = true;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algo);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
        assert (md != null);
        md.reset();
        hash = md.digest(buff);
        if (!isSHA) {
            for (int i2 = 2; i2 <= 100; ++i2) {
                md.reset();
                md.update(hash);
                hash = md.digest();
            }
        }
        if (isSHA ? !$assertionsDisabled && hash.length != 20 : !$assertionsDisabled && hash.length != 32) {
            throw new AssertionError();
        }
        return hash;
    }

    public static String encode(byte[] salt, byte[] hash, String algo) {
        boolean isSHA = false;
        if (algoSHA.equals(algo)) {
            isSHA = true;
        }
        if (!isSHA ? !$assertionsDisabled && hash.length != 32 : !$assertionsDisabled && hash.length != 20) {
            throw new AssertionError();
        }
        int resultLength = 32;
        if (isSHA) {
            resultLength = 20;
        }
        byte[] res = new byte[resultLength + salt.length];
        System.arraycopy(hash, 0, res, 0, resultLength);
        System.arraycopy(salt, 0, res, resultLength, salt.length);
        String encoded = SecurityUtil.base64Encode(res);
        String out = SSHA_256_TAG + encoded;
        if (isSHA) {
            out = SSHA_TAG + encoded;
        }
        return out;
    }

    public static boolean verify(String encoded, byte[] password) throws IllegalArgumentException {
        byte[] hash = new byte[20];
        String algo = algoSHA256;
        if (encoded.startsWith(SSHA_TAG)) {
            algo = algoSHA;
        }
        byte[] salt = SSHA.decode(encoded, hash, algo);
        return SSHA.verify(salt, hash, password, algo);
    }

    public static boolean verify(byte[] salt, byte[] hash, byte[] password, String algo) throws IllegalArgumentException {
        byte[] newHash = SSHA.compute(salt, password, algo);
        return Arrays.equals(hash, newHash);
    }

    public static byte[] decode(String encoded, byte[] hashResult, String algo) throws IllegalArgumentException {
        boolean isSHA = false;
        if (algoSHA.equals(algo)) {
            isSHA = true;
        }
        if (isSHA ? !$assertionsDisabled && hashResult.length != 20 : !$assertionsDisabled && hashResult.length != 32) {
            throw new AssertionError();
        }
        if (!encoded.startsWith(SSHA_TAG) && !encoded.startsWith(SSHA_256_TAG)) {
            String msg = strings.getString("ssha.badformat", encoded);
            throw new IllegalArgumentException(msg);
        }
        String ssha = encoded.substring(SSHA_256_TAG.length());
        if (isSHA) {
            ssha = encoded.substring(SSHA_TAG.length());
        }
        byte[] result = SecurityUtil.base64Decode(ssha);
        int resultLength = 32;
        if (isSHA) {
            resultLength = 20;
        }
        assert (result.length > resultLength);
        byte[] salt = new byte[result.length - resultLength];
        System.arraycopy(result, 0, hashResult, 0, resultLength);
        System.arraycopy(result, resultLength, salt, 0, result.length - resultLength);
        return salt;
    }
}

