/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.ssl;

import com.bes.enterprise.appserver.common.ssl.UnifiedX509KeyManager;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class J2EEKeyManager
extends X509ExtendedKeyManager {
    private X509KeyManager delegate;
    private String serverKeyAlias;
    private Map<String, X509KeyManager> tokenName2MgrMap = null;
    private boolean supportTokenAlias = false;

    public J2EEKeyManager(X509KeyManager mgr, String serverKeyAlias) {
        this.delegate = mgr;
        this.serverKeyAlias = serverKeyAlias;
        if (mgr instanceof UnifiedX509KeyManager) {
            UnifiedX509KeyManager umgr = (UnifiedX509KeyManager)mgr;
            X509KeyManager[] mgrs = umgr.getX509KeyManagers();
            String[] tokenNames = umgr.getTokenNames();
            this.tokenName2MgrMap = new HashMap<String, X509KeyManager>();
            for (int i2 = 0; i2 < mgrs.length; ++i2) {
                if (tokenNames[i2] == null) continue;
                this.tokenName2MgrMap.put(tokenNames[i2], mgrs[i2]);
            }
            this.supportTokenAlias = this.tokenName2MgrMap.size() > 0;
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.delegate.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.serverKeyAlias != null) {
            return this.serverKeyAlias;
        }
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509KeyManager keyMgr = this.getManagerFromToken(alias);
        if (keyMgr != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getCertificateChain(aliasName);
        }
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegate.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        X509KeyManager keyMgr = this.getManagerFromToken(alias);
        if (keyMgr != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getPrivateKey(aliasName);
        }
        return this.delegate.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.serverKeyAlias != null) {
            return this.serverKeyAlias;
        }
        return super.chooseEngineServerAlias(keyType, issuers, engine);
    }

    private X509KeyManager getManagerFromToken(String tokenAlias) {
        X509KeyManager keyMgr = null;
        int ind = -1;
        if (this.supportTokenAlias && tokenAlias != null && (ind = tokenAlias.indexOf(58)) != -1) {
            String tokenName = this.serverKeyAlias.substring(0, ind);
            keyMgr = this.tokenName2MgrMap.get(tokenName);
        }
        return keyMgr;
    }
}

