/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.ssl;

import com.bes.enterprise.appserver.common.ssl.UnifiedX509KeyManager;
import com.bes.enterprise.appserver.common.ssl.UnifiedX509TrustManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SecuritySupport {
    private static final Logger _logger = Logger.getLogger(SecuritySupport.class.getName());
    private static final String DEFAULT_KEYSTORE_PASS = "changeit";
    private static final String DEFAULT_TRUSTSTORE_PASS = "changeit";
    private final String keystoreType;
    private final String keystoreFilePath;
    private final char[] keystorePass;
    private final String truststoreType;
    private final String truststoreFilePath;
    private final char[] truststorePass;
    private KeyStore keystore = null;
    private KeyStore truststore = null;
    private Date initDate = new Date();
    private static SecuritySupport defaultSecuritySupport = null;

    public SecuritySupport(String keystoreType, String keystoreFilePath, char[] keystorePass, String truststoreType, String truststoreFilePath, char[] truststorePass) {
        this.keystoreType = keystoreType;
        this.keystoreFilePath = keystoreFilePath;
        this.keystorePass = keystorePass;
        this.truststoreType = truststoreType;
        this.truststoreFilePath = truststoreFilePath;
        this.truststorePass = truststorePass;
    }

    public static SecuritySupport getDefaultSecuritySupport() throws GeneralSecurityException {
        if (defaultSecuritySupport != null) {
            return defaultSecuritySupport;
        }
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
        String keyStoreFileName = System.getProperty("javax.net.ssl.keyStore");
        String trustStoreFileName = System.getProperty("javax.net.ssl.trustStore");
        char[] keyStorePass = null;
        char[] trustStorePass = null;
        String keyStorePassStr = System.getProperty("javax.net.ssl.keyStorePassword");
        String trustStorePassStr = System.getProperty("javax.net.ssl.trustStorePassword");
        keyStorePass = SecuritySupport.isEmpty(keyStorePassStr) ? "changeit".toCharArray() : keyStorePassStr.toCharArray();
        trustStorePass = SecuritySupport.isEmpty(trustStorePassStr) ? "changeit".toCharArray() : trustStorePassStr.toCharArray();
        defaultSecuritySupport = new SecuritySupport(keyStoreType, keyStoreFileName, keyStorePass, trustStoreType, trustStoreFileName, trustStorePass);
        defaultSecuritySupport.init();
        return defaultSecuritySupport;
    }

    public void init() throws GeneralSecurityException {
        try {
            this.keystore = SecuritySupport.loadKeyStore(this.keystoreType, null, this.keystoreFilePath, this.keystorePass);
            this.truststore = SecuritySupport.loadKeyStore(this.truststoreType, null, this.truststoreFilePath, this.truststorePass);
        }
        catch (Exception ex) {
            throw new GeneralSecurityException("Failed to load the keystore manger and trust store manager!", ex);
        }
    }

    public KeyManager[] getKeyManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        this.checkCertificateDates(this.keystore);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm != null ? algorithm : KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.keystore, this.keystorePass);
        KeyManager[] kmgrs = kmf.getKeyManagers();
        if (kmgrs != null) {
            keyManagers.addAll(Arrays.asList(kmgrs));
        }
        UnifiedX509KeyManager keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), new String[]{null});
        return new KeyManager[]{keyManager};
    }

    public TrustManager[] getTrustManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException {
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        this.checkCertificateDates(this.truststore);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm != null ? algorithm : TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.truststore);
        TrustManager[] tmgrs = tmf.getTrustManagers();
        if (tmgrs != null) {
            trustManagers.addAll(Arrays.asList(tmgrs));
        }
        TrustManager trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
        return new TrustManager[]{trustManager};
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String keyStoreType, Provider provider, String keyStoreFile, char[] keyStorePass) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = null;
        ks = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        char[] passphrase = keyStorePass;
        FileInputStream istream = null;
        BufferedInputStream bstream = null;
        try {
            if (keyStoreFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Loading keystoreFile = {0}, keystorePass = {1}", new Object[]{keyStoreFile, keyStorePass});
                }
                istream = new FileInputStream(keyStoreFile);
                bstream = new BufferedInputStream(istream);
            }
            ks.load(bstream, passphrase);
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        return ks;
    }

    private void checkCertificateDates(KeyStore store) throws KeyStoreException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = store.getCertificate(alias);
            if (!(cert instanceof X509Certificate) || !((X509Certificate)cert).getNotAfter().before(this.initDate)) continue;
            _logger.log(Level.FINEST, "The certificate with alias {0} has expired!", alias);
            _logger.log(Level.FINEST, "java_security.expired_certificate", cert);
        }
    }

    private static boolean isEmpty(String str) {
        boolean result = false;
        if (str == null || "".equals(str.trim())) {
            result = true;
        }
        return result;
    }
}

