/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509KeyManager;

class UnifiedX509KeyManager
implements X509KeyManager {
    private X509KeyManager[] mgrs = null;
    private String[] tokenNames = null;

    public UnifiedX509KeyManager(X509KeyManager[] mgrs, String[] tokenNames) {
        if (mgrs == null || tokenNames == null) {
            throw new IllegalArgumentException("Null array of X509KeyManagers or tokenNames");
        }
        if (mgrs.length != tokenNames.length) {
            throw new IllegalArgumentException("Size of X509KeyManagers array and tokenNames array do not match.");
        }
        this.mgrs = mgrs;
        this.tokenNames = tokenNames;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        for (int i2 = 0; i2 < this.mgrs.length && (alias = this.mgrs[i2].chooseClientAlias(keyType, issuers, socket)) == null; ++i2) {
        }
        return alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        for (int i2 = 0; i2 < this.mgrs.length && (alias = this.mgrs[i2].chooseServerAlias(keyType, issuers, socket)) == null; ++i2) {
        }
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] chain = null;
        for (int i2 = 0; i2 < this.mgrs.length && (chain = this.mgrs[i2].getCertificateChain(alias)) == null; ++i2) {
        }
        return chain;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> clientAliases = new ArrayList<String>();
        for (int i2 = 0; i2 < this.mgrs.length; ++i2) {
            String[] clAliases = this.mgrs[i2].getClientAliases(keyType, issuers);
            if (clAliases == null || clAliases.length <= 0) continue;
            for (int j2 = 0; j2 < clAliases.length; ++j2) {
                clientAliases.add(clAliases[j2]);
            }
        }
        return clientAliases.size() == 0 ? null : clientAliases.toArray(new String[clientAliases.size()]);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey privKey = null;
        for (int i2 = 0; i2 < this.mgrs.length && (privKey = this.mgrs[i2].getPrivateKey(alias)) == null; ++i2) {
        }
        return privKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList<String> serverAliases = new ArrayList<String>();
        for (int i2 = 0; i2 < this.mgrs.length; ++i2) {
            String[] serAliases = this.mgrs[i2].getClientAliases(keyType, issuers);
            if (serAliases == null || serAliases.length <= 0) continue;
            for (int j2 = 0; j2 < serAliases.length; ++j2) {
                serverAliases.add(serAliases[j2]);
            }
        }
        return serverAliases.size() == 0 ? null : serverAliases.toArray(new String[serverAliases.size()]);
    }

    public X509KeyManager[] getX509KeyManagers() {
        X509KeyManager[] kmgrs = new X509KeyManager[this.mgrs.length];
        System.arraycopy(this.mgrs, 0, kmgrs, 0, this.mgrs.length);
        return kmgrs;
    }

    public String[] getTokenNames() {
        String[] tokens = new String[this.tokenNames.length];
        System.arraycopy(this.tokenNames, 0, tokens, 0, this.tokenNames.length);
        return tokens;
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }
}

