/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;

class UnifiedX509TrustManager
implements X509TrustManager {
    private X509TrustManager[] mgrs = null;
    private X509Certificate[] issuers = new X509Certificate[0];

    public UnifiedX509TrustManager(X509TrustManager[] mgrs) {
        if (mgrs == null) {
            throw new IllegalArgumentException("Null array of X509TrustManagers");
        }
        this.mgrs = mgrs;
        HashSet<X509Certificate> tset = new HashSet<X509Certificate>();
        for (int i2 = 0; i2 < mgrs.length; ++i2) {
            X509Certificate[] tcerts = mgrs[i2].getAcceptedIssuers();
            if (tcerts == null || tcerts.length <= 0) continue;
            for (int j2 = 0; j2 < tcerts.length; ++j2) {
                tset.add(tcerts[j2]);
            }
        }
        this.issuers = new X509Certificate[tset.size()];
        Iterator iter = tset.iterator();
        int i3 = 0;
        while (iter.hasNext()) {
            this.issuers[i3] = (X509Certificate)iter.next();
            ++i3;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateException cex = null;
        for (int i2 = 0; i2 < this.mgrs.length; ++i2) {
            try {
                cex = null;
                this.mgrs[i2].checkClientTrusted(chain, authType);
                break;
            }
            catch (CertificateException ex) {
                cex = ex;
                continue;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateException cex = null;
        for (int i2 = 0; i2 < this.mgrs.length; ++i2) {
            try {
                cex = null;
                this.mgrs[i2].checkServerTrusted(chain, authType);
                break;
            }
            catch (CertificateException ex) {
                cex = ex;
                continue;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.issuers;
    }
}

