/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.user.parse;

import com.bes.enterprise.appserver.common.user.RolesVo;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class RolesXmlParser {
    private static Logger logger = Logger.getLogger(RolesXmlParser.class.getName());
    private JAXBContext jaxbContext;
    private static RolesXmlParser parser = new RolesXmlParser();
    private static File roleFile = new File(System.getProperty("com.bes.instanceRoot") + File.separator + "conf" + File.separator + "security" + File.separator + "role.xml");

    private RolesXmlParser() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RolesVo.class});
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
    }

    public static RolesXmlParser getInstance() {
        return parser;
    }

    private Marshaller makeMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.fragment", (Object)false);
        return marshaller;
    }

    private Unmarshaller makeUnmarshaller() throws JAXBException {
        return this.jaxbContext.createUnmarshaller();
    }

    public RolesVo unmarshal() {
        RolesVo rolesVo = null;
        try {
            rolesVo = (RolesVo)this.makeUnmarshaller().unmarshal(roleFile);
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        return rolesVo;
    }

    public void marshal(RolesVo rolesVo) {
        try {
            this.makeMarshaller().marshal((Object)rolesVo, roleFile);
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
    }
}

