/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.SystemPropertyConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CollectionUtils {
    public static Map<String, String> propertiesToStringMap(Properties p2) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : p2.entrySet()) {
            Object name = entry.getKey();
            if (name == null) continue;
            Object value = entry.getValue();
            if (value == null) {
                map.put(name.toString(), null);
                continue;
            }
            map.put(name.toString(), value.toString());
        }
        return map;
    }

    public static void copyProperties(Map<?, ?> fromProps, Map<String, String> dstProps) {
        CollectionUtils.copyProperties(fromProps, dstProps, null);
    }

    public static void copyProperties(Map<?, ?> fromProps, Map<String, String> dstProps, String prefix) {
        for (Map.Entry<?, ?> entry : fromProps.entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            if (prefix != null && !key.startsWith(prefix) || !((value = entry.getValue()) instanceof String)) continue;
            dstProps.put(key, (String)value);
        }
    }

    public static String toString(Map<String, String> map) {
        String[] arr = CollectionUtils.toStringArray(map);
        StringBuilder sb = new StringBuilder();
        for (String s2 : arr) {
            sb.append(s2);
            sb.append(SystemPropertyConstants.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(String[] arr) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : arr) {
            sb.append(s2);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String toString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : list) {
            sb.append(s2);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String[] toStringArray(Map<String, String> map) {
        String[] ss = new String[map.size()];
        int i2 = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            String s2 = entry.getKey();
            if (value != null) {
                s2 = s2 + "=" + value;
            }
            ss[i2++] = s2;
        }
        return ss;
    }
}

