/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;

public class CommonUtils {
    public static List<Class> getAllClasses(Class cl) {
        ArrayList<Class> classes = new ArrayList<Class>();
        while (cl != null && !cl.getCanonicalName().startsWith("java.")) {
            classes.add(cl);
            cl = cl.getSuperclass();
        }
        return classes;
    }

    public static Collection instantiationCollection(Class collectionClazz) throws InstantiationException, IllegalAccessException {
        if (List.class.isAssignableFrom(collectionClazz)) {
            try {
                return (Collection)collectionClazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return (Collection)ArrayList.class.newInstance();
            }
        }
        if (Set.class.isAssignableFrom(collectionClazz)) {
            try {
                return (Collection)collectionClazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return (Collection)HashSet.class.newInstance();
            }
        }
        throw new InstantiationException(String.format("Could not instantiation class <%s>.", collectionClazz));
    }

    public static Map instantiationMap(Class mapClazz) throws InstantiationException, IllegalAccessException {
        try {
            return (Map)mapClazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return (Map)HashMap.class.newInstance();
        }
    }

    public static byte[] convertCharArrayToByteArray(char[] charArray, String strCharset) throws CharacterCodingException {
        Charset charSet;
        if (charArray == null) {
            return null;
        }
        char[] chArray = (char[])charArray.clone();
        CharBuffer charBuffer = CharBuffer.wrap(chArray);
        if (strCharset == null || "".equals(strCharset)) {
            charSet = Charset.defaultCharset();
        } else if (Charset.isSupported(strCharset)) {
            charSet = Charset.forName(strCharset);
        } else {
            CharacterCodingException e2 = new CharacterCodingException();
            e2.initCause(new UnsupportedCharsetException(strCharset));
            throw e2;
        }
        CharsetEncoder encoder = charSet.newEncoder();
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = encoder.encode(charBuffer);
        }
        catch (CharacterCodingException cce) {
            throw cce;
        }
        catch (Throwable t2) {
            CharacterCodingException e3 = new CharacterCodingException();
            e3.initCause(t2);
            throw e3;
        }
        byte[] result = new byte[byteBuffer.remaining()];
        byteBuffer.get(result);
        CommonUtils.clear(byteBuffer);
        CommonUtils.clear(charBuffer);
        return (byte[])result.clone();
    }

    private static void clear(ByteBuffer byteBuffer) {
        byte[] bytes = byteBuffer.array();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = 0;
        }
    }

    private static void clear(CharBuffer charBuffer) {
        char[] chars = charBuffer.array();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            chars[i2] = 48;
        }
    }

    public static void removeNullValueForMap(Map<String, String> map) {
        if (map != null) {
            Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                if (!StringUtils.isBlank(entry.getValue())) continue;
                it.remove();
            }
        }
    }

    public static void removeNullValueForMap(Map<String, String> map, boolean needEmptyString) {
        if (!needEmptyString) {
            CommonUtils.removeNullValueForMap(map);
        } else if (map != null) {
            Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                if (entry.getValue() != null) continue;
                it.remove();
            }
        }
    }

    public static List<String> findNullValueForMap(Map<String, String> removedHasNullValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (removedHasNullValue != null) {
            for (Map.Entry<String, String> entry : removedHasNullValue.entrySet()) {
                if (!StringUtils.isBlank(entry.getValue())) continue;
                list.add(entry.getKey());
            }
        }
        return list;
    }

    public static String convert2Path(URL url) {
        String path = url.toExternalForm();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    public static XMLInputFactory newXMLInputFactory() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CommonUtils.class.getClassLoader());
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XMLInputFactory xMLInputFactory = factory;
            return xMLInputFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

