/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.JarInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class EmbeddedClassPreventUtil {
    private static Map<String, JarInfo> jarInfos = new HashMap<String, JarInfo>();
    private static Map<String, HashSet<String>> conflictJars = new HashMap<String, HashSet<String>>();

    public static void check() throws Exception {
        StringBuilder conflictJarsInfo;
        try {
            String classpaths = System.getProperty("java.class.path");
            if (classpaths == null || classpaths.isEmpty()) {
                return;
            }
            for (String path : classpaths.split(File.pathSeparator)) {
                File file = new File(path);
                if (!file.exists()) continue;
                EmbeddedClassPreventUtil.traverseFile(file);
            }
            if (conflictJars.size() == 0) {
                return;
            }
            conflictJarsInfo = new StringBuilder();
            conflictJarsInfo.append("The following jar files conflict, please confirm:").append(System.lineSeparator());
            Set<String> JarskeySet = conflictJars.keySet();
            for (String jarName : JarskeySet) {
                HashSet<String> jarTempList = conflictJars.get(jarName);
                for (String jarTemp : jarTempList) {
                    conflictJarsInfo.append(jarTemp).append(System.lineSeparator());
                }
                conflictJarsInfo.append(System.lineSeparator());
            }
        }
        catch (Exception exception) {
            return;
        }
        if (conflictJarsInfo != null) {
            throw new Exception(conflictJarsInfo.toString());
        }
    }

    private static void traverseFile(File file) throws Exception {
        if (file.isDirectory()) {
            for (File listFile : file.listFiles()) {
                EmbeddedClassPreventUtil.traverseFile(listFile);
            }
        } else if (file.getName().endsWith(".jar")) {
            EmbeddedClassPreventUtil.getJarInfos(file);
        }
    }

    private static void getJarInfos(File file) throws Exception {
        try (JarFile jar = new JarFile(file);){
            JarInfo jarInfo = new JarInfo();
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                return;
            }
            Attributes attributes = jar.getManifest().getMainAttributes();
            Set<Object> set = attributes.keySet();
            Object groupIdKey = null;
            Object artifactIdKey = null;
            Object versionKey = null;
            for (Object o2 : set) {
                if ("Implementation-Vendor-Id".equals(o2.toString())) {
                    groupIdKey = o2;
                }
                if ("Implementation-Title".equals(o2.toString())) {
                    artifactIdKey = o2;
                }
                if (!"Implementation-Version".equals(o2.toString())) continue;
                versionKey = o2;
            }
            Object groupId = attributes.get(groupIdKey);
            Object artifactId = attributes.get(artifactIdKey);
            Object version = attributes.get(versionKey);
            if (groupId != null && groupId.equals("com.sun") || artifactId != null && artifactId.equals("Java Runtime Environment")) {
                return;
            }
            if (groupId != null) {
                jarInfo.setGroupId(groupId.toString());
            }
            if (artifactId != null) {
                jarInfo.setArtifactId(artifactId.toString());
            }
            if (version != null) {
                jarInfo.setVersion(version.toString());
            }
            jarInfo.setJarFile(jar);
            if (groupId != null && artifactId != null) {
                String key = groupId + "-" + artifactId;
                if (jarInfos.containsKey(key)) {
                    String existJarName;
                    HashSet<String> conflictJar = conflictJars.get(key);
                    if (conflictJar == null) {
                        conflictJar = new HashSet();
                    }
                    if (!(existJarName = jarInfos.get(key).getJarFile().getName()).equals(jar.getName())) {
                        conflictJar.add(jar.getName());
                        conflictJar.add(existJarName);
                        conflictJars.put(key, conflictJar);
                    }
                }
                jarInfos.put(key, jarInfo);
            }
        }
    }
}

