/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.i18n.LocalStringsImpl;
import com.bes.enterprise.appserver.common.logging.LogDomains;
import com.bes.enterprise.appserver.common.util.OSUtils;
import com.bes.enterprise.appserver.common.util.SanitizeFile;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.security.action.GetPropertyAction;

public class FileUtils {
    static final Logger _logger = Logger.getLogger("javax.enterprise.system.util");
    static final Logger _utillogger = LogDomains.getLogger(FileUtils.class, "javax.enterprise.system.util");
    static final LocalStringsImpl strings = new LocalStringsImpl(FileUtils.class);
    private static final int BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String ILLEGAL_FILENAME_STRING = "\\/:*?\"<>|";
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static String TMPFILENAME = "scratch";
    private static final int FILE_OPERATION_MAX_RETRIES = Integer.getInteger("com.bes.appserv.winFileLockRetryLimit", 5);
    private static final int FILE_OPERATION_SLEEP_DELAY_MS = Integer.getInteger("com.bes.appserv.winFileLockRetryDelay", 1000);
    private static final Level FILE_OPERATION_LOG_LEVEL = Level.FINE;
    private static final String VALID_CHAR_PATTERN = "[^\"'<>&\u4e00-\u9fa5]+";
    public static String WIN_DIR_PATTERN = "[a-zA-Z][:][\\\\//][[^\"'<>&\u4e00-\u9fa5]+[\\\\//]?]*";
    public static String UIX_DIR_PATTERN = "[/][[^\"'<>&\u4e00-\u9fa5]+[/]?]*";
    public static final String WINDOWS_SEPARATOR = "\\";
    public static final String UNIX_SEPARATOR = "/";
    public static final int MAX_BUFFER_SIZE = 65536;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    private static final String JAR_FILE_NAME = "j2ee.jar";
    private static final String HOME_DIR_PROP = "com.bes.enterprise.home";
    private static final String DEFAULT_HOME_DIR = System.getProperty("user.dir");
    public static final char JAR_SEPARATOR_CHAR = '/';
    private static final long JAR_ENTRY_UNKNOWN_VALUE = -1L;
    private static final int BYTE_READ_ERROR = -1;
    private static String basedir = null;
    private static String GENERATE_DIR = System.getProperty("java.io.tmpdir") + File.separator + "generated";
    private static String TMP_DIR = "tmp";

    public static boolean isRelativePath(String path) {
        if (!StringUtils.ok(path)) {
            return false;
        }
        if (path.startsWith(".")) {
            return true;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        return path.indexOf("\\.") >= 0;
    }

    public static List<File> stringToFiles(String cp) {
        ArrayList<File> list = new ArrayList<File>();
        if (StringUtils.ok(cp)) {
            String[] ss;
            cp = SanitizeFile.sanitizePaths(cp);
            for (String s2 : ss = cp.split(File.pathSeparator)) {
                list.add(new File(s2));
            }
        }
        return list;
    }

    public static String fileListToPathString(List<File> files) {
        StringBuilder sb = new StringBuilder();
        boolean firstFile = true;
        for (File f2 : files) {
            if (firstFile) {
                firstFile = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f2.getPath().replace('\\', '/'));
        }
        return sb.toString();
    }

    public static File[] listFiles(File f2) {
        try {
            File[] files = f2.listFiles();
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static File[] listFiles(File f2, FileFilter ff) {
        try {
            File[] files = f2.listFiles(ff);
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static File[] listFiles(File f2, FilenameFilter fnf) {
        try {
            File[] files = f2.listFiles(fnf);
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static boolean safeExists(File f2) {
        return f2 != null && f2.exists();
    }

    public static boolean safeIsDirectory(File f2) {
        return f2 != null && f2.exists() && f2.isDirectory();
    }

    public static boolean safeIsRealDirectory(String s2) {
        return FileUtils.safeIsRealDirectory(new File(s2));
    }

    public static boolean safeIsRealDirectory(File f2) {
        String absolute;
        if (!FileUtils.safeIsDirectory(f2)) {
            return false;
        }
        String canonical = FileUtils.safeGetCanonicalPath(f2);
        if (canonical.equals(absolute = f2.getAbsolutePath())) {
            return true;
        }
        return OSUtils.isWindows() && canonical.equalsIgnoreCase(absolute);
    }

    public static boolean safeIsDirectory(String s2) {
        return FileUtils.safeIsDirectory(new File(s2));
    }

    public static String safeGetCanonicalPath(File f2) {
        if (f2 == null) {
            return null;
        }
        try {
            return f2.getCanonicalPath();
        }
        catch (IOException e2) {
            return f2.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File f2) {
        if (f2 == null) {
            return null;
        }
        try {
            return f2.getCanonicalFile();
        }
        catch (IOException e2) {
            return f2.getAbsoluteFile();
        }
    }

    public static boolean hasExtension(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.endsWith(ext);
    }

    public static boolean hasExtension(File f2, String ext) {
        if (f2 == null || !f2.exists()) {
            return false;
        }
        return f2.getName().endsWith(ext);
    }

    public static boolean hasExtensionIgnoreCase(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.toLowerCase(Locale.ENGLISH).endsWith(ext.toLowerCase(Locale.ENGLISH));
    }

    public static boolean hasExtensionIgnoreCase(File f2, String ext) {
        if (f2 == null || !f2.exists()) {
            return false;
        }
        return f2.getName().toLowerCase(Locale.ENGLISH).endsWith(ext.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isLegalFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        for (int i2 = 0; i2 < ILLEGAL_FILENAME_CHARS.length; ++i2) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i2]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFilePath(String filePath) {
        if (!FileUtils.isValidString(filePath)) {
            return false;
        }
        String formatPath = StringUtils.formatDir(filePath);
        return formatPath.matches(WIN_DIR_PATTERN) || formatPath.matches(UIX_DIR_PATTERN);
    }

    public static boolean isFriendlyFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return FileUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        if (FileUtils.isLegalFilename(filename)) {
            return filename;
        }
        filename = filename.replaceAll("[/" + Pattern.quote(WINDOWS_SEPARATOR) + "]", "__");
        for (int i2 = 0; i2 < ILLEGAL_FILENAME_CHARS.length; ++i2) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i2], '_');
        }
        return filename;
    }

    public static String makeLegalNoBlankFileName(String filename) {
        return FileUtils.makeLegalFilename(filename).replace(' ', '_');
    }

    public static String makeFriendlyFilename(String filename) {
        if (FileUtils.isFriendlyFilename(filename)) {
            return filename;
        }
        String ret = FileUtils.makeLegalFilename(filename).replace(' ', '_');
        ret = ret.replace('.', '_');
        return ret;
    }

    public static String makeFriendlyFilenameByDeployType(boolean isDirectoryDeployed, String filename) {
        if (isDirectoryDeployed) {
            return filename;
        }
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFilenameNoExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            filename = filename.substring(0, index);
        }
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFilenameExtension(String filename) {
        if (filename == null) {
            return null;
        }
        filename = FileUtils.makeLegalNoBlankFileName(filename);
        String extension = "";
        if (filename.endsWith(".ear")) {
            filename = filename.substring(0, filename.indexOf(".ear"));
            extension = "_ear";
        } else if (filename.endsWith(".war")) {
            filename = filename.substring(0, filename.indexOf(".war"));
            extension = "_war";
        } else if (filename.endsWith(".jar")) {
            filename = filename.substring(0, filename.indexOf(".jar"));
            extension = "_jar";
        } else if (filename.endsWith(".rar")) {
            filename = filename.substring(0, filename.indexOf(".rar"));
            extension = "_rar";
        }
        return filename + extension;
    }

    public static String revertFriendlyFilenameExtension(String filename) {
        if (filename == null || !filename.endsWith("_ear") && !filename.endsWith("_war") && !filename.endsWith("_jar") && !filename.endsWith("_rar")) {
            return filename;
        }
        String extension = "";
        if (filename.endsWith("_ear")) {
            filename = filename.substring(0, filename.indexOf("_ear"));
            extension = ".ear";
        } else if (filename.endsWith("_war")) {
            filename = filename.substring(0, filename.indexOf("_war"));
            extension = ".war";
        } else if (filename.endsWith("_jar")) {
            filename = filename.substring(0, filename.indexOf("_jar"));
            extension = ".jar";
        } else if (filename.endsWith("_rar")) {
            filename = filename.substring(0, filename.indexOf("_rar"));
            extension = ".rar";
        }
        return filename + extension;
    }

    public static String revertFriendlyFilename(String filename) {
        String name = FileUtils.revertFriendlyFilenameExtension(filename);
        return name.replaceAll("__", UNIX_SEPARATOR);
    }

    public static void liquidate(File parent) {
        FileUtils.whack(parent);
    }

    public static boolean isJar(String filename) {
        return FileUtils.hasExtension(filename, ".jar");
    }

    public static boolean isZip(String filename) {
        return FileUtils.hasExtensionIgnoreCase(filename, ".zip");
    }

    public static boolean isJar(File f2) {
        return FileUtils.hasExtension(f2, ".jar");
    }

    public static boolean isZip(File f2) {
        return FileUtils.hasExtensionIgnoreCase(f2, ".zip");
    }

    public static boolean whack(File parent) {
        return FileUtils.whack(parent, null);
    }

    public static boolean whack(File parent, Collection<File> undeletedFiles) {
        try {
            return FileUtils.whackResolvedDirectory(parent.getCanonicalFile(), undeletedFiles);
        }
        catch (IOException ioe) {
            _utillogger.log(Level.SEVERE, "iplanet_util.io_exception", ioe);
            return false;
        }
    }

    private static boolean whackResolvedDirectory(File parent, Collection<File> undeletedFiles) {
        if (FileUtils.safeIsRealDirectory(parent)) {
            File[] kids = FileUtils.listFiles(parent);
            for (int i2 = 0; i2 < kids.length; ++i2) {
                File f2 = kids[i2];
                if (f2.isDirectory()) {
                    FileUtils.whackResolvedDirectory(f2, undeletedFiles);
                    continue;
                }
                if (FileUtils.deleteFile(f2) || undeletedFiles == null) continue;
                undeletedFiles.add(f2);
            }
        }
        return FileUtils.deleteFile(parent);
    }

    public static boolean deleteFile(File f2) {
        if (f2.delete()) {
            return true;
        }
        boolean log = _utillogger.isLoggable(FILE_OPERATION_LOG_LEVEL);
        String filePath = f2.getAbsolutePath();
        if (!f2.exists()) {
            if (log) {
                _utillogger.log(Level.FINE, "enterprise_util.delete_failed_absent", filePath);
            }
            return true;
        }
        if (log) {
            _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.error_deleting_file", filePath);
        }
        return false;
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            FileUtils.deleteDirContents(dir);
            return dir.delete();
        }
        return dir.delete();
    }

    public static boolean delete(String file) {
        return FileUtils.delete(new File(file));
    }

    public static boolean deleteDirContents(File dir) {
        boolean deleteStatus = false;
        try {
            File dirCon = dir.getCanonicalFile();
            String[] files = dirCon.list();
            for (int i2 = 0; i2 < files.length; ++i2) {
                File f2 = new File(dir, files[i2]);
                File filePath = f2.getCanonicalFile();
                deleteStatus = filePath.getParentFile().equals(dirCon) ? FileUtils.delete(filePath) : FileUtils.delete(filePath);
            }
        }
        catch (IOException ex) {
            deleteStatus = false;
            throw new SecurityException(ex);
        }
        return deleteStatus;
    }

    public static FileOutputStream openFileOutputStream(File out) throws IOException {
        FileOutputStreamWork work = new FileOutputStreamWork(out);
        int retries = FileUtils.doWithRetry(work);
        if (retries > 0) {
            _utillogger.log(Level.FINE, "Retrying " + retries + " times");
        }
        if (work.workComplete()) {
            return work.getStream();
        }
        IOException ioe = new IOException();
        ioe.initCause(work.getLastError());
        throw ioe;
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        return FileUtils.getAllFilesUnder(directory, filenameFilter, true);
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter, boolean relativize) throws IOException {
        TreeSet allFiles = new TreeSet();
        File relativizingDir = relativize ? directory : null;
        FileUtils.recursiveGetFilesUnder(relativizingDir, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    public static Set getAllFilesAndDirectoriesUnder(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtils.recursiveGetFilesUnder(directory, directory, null, allFiles, true);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = FileUtils.listFiles(directory, filenameFilter);
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory()) {
                FileUtils.recursiveGetFilesUnder(relativizingRoot, files[i2], filenameFilter, set, returnDirectories);
                if (!returnDirectories) continue;
                if (relativizingRoot != null) {
                    set.add(FileUtils.relativize(relativizingRoot, files[i2]));
                    continue;
                }
                set.add(files[i2]);
                continue;
            }
            if (relativizingRoot != null) {
                set.add(FileUtils.relativize(relativizingRoot, files[i2]));
                continue;
            }
            set.add(files[i2]);
        }
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    private static int doWithRetry(RetriableWork work) {
        int retries = 0;
        work.run();
        if (!work.workComplete() && OSUtils.isWindows()) {
            _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.perform_gc");
            while (!work.workComplete() && retries++ < FILE_OPERATION_MAX_RETRIES) {
                try {
                    Thread.currentThread();
                    Thread.sleep(FILE_OPERATION_SLEEP_DELAY_MS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
                work.run();
            }
        }
        return retries;
    }

    public static String formatFileCollection(Collection<File> files) {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        String prefix = "";
        for (File f2 : files) {
            sb.append(prefix).append(f2.getAbsolutePath());
            prefix = lineSep;
        }
        return sb.toString();
    }

    public static File getDirectory(File f2) {
        String filename = f2.getAbsolutePath();
        return new File(new File(filename).getParent());
    }

    public static File createTempFile(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(TMPFILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "iplanet_util.io_exception", ioe);
        }
        f2.deleteOnExit();
        return f2;
    }

    public static File[] listAllFiles(File dirName, String ext) {
        File[] target = null;
        List list = FileUtils.searchDir(dirName, ext);
        if (list != null && list.size() > 0) {
            target = new File[list.size()];
            target = list.toArray(target);
        }
        return target;
    }

    public static List searchDir(File dirName, String ext) {
        ArrayList<File> targetList = null;
        if (dirName.isDirectory()) {
            targetList = new ArrayList<File>();
            File[] list = FileUtils.listFiles(dirName);
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (list[i2].isDirectory()) {
                    targetList.addAll(FileUtils.searchDir(list[i2], ext));
                    continue;
                }
                String name = list[i2].toString();
                if (!FileUtils.hasExtension(name, ext)) continue;
                targetList.add(list[i2]);
            }
        }
        return targetList;
    }

    public static void copy(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("null or empty filename argument");
        }
        File fin = new File(from);
        File fout = new File(to);
        FileUtils.copy(fin, fout);
    }

    public static void copy(File fin, File fout) throws IOException {
        FileUtils.copy(fin, fout, false);
    }

    public static void copy(File fin, File fout, boolean preserveFileDate) throws IOException {
        if (FileUtils.safeIsDirectory(fin)) {
            FileUtils.copyDirectory(fin, fout, preserveFileDate);
            return;
        }
        if (!fin.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (!FileUtils.safeIsDirectory(fout.getParentFile())) {
            fout.getParentFile().mkdirs();
        }
        FileUtils.copyFile(fin, fout, preserveFileDate);
    }

    public static void copyTree(File din, File dout) throws IOException {
        FileUtils.copyTree(din, dout, false);
    }

    public static void copyTree(File din, File dout, boolean preserveFileDate) throws IOException {
        FileUtils.copyDirectory(din, dout, preserveFileDate);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, true);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, null, preserveFileDate);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, filter, true);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter, boolean preserveFileDate) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            File[] srcFiles;
            File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
            if (srcFiles != null && srcFiles.length > 0) {
                exclusionList = new ArrayList<String>(srcFiles.length);
                for (File srcFile : srcFiles) {
                    File copiedFile = new File(destDir, srcFile.getName());
                    exclusionList.add(copiedFile.getCanonicalPath());
                }
            }
        }
        FileUtils.doCopyDirectory(srcDir, destDir, filter, preserveFileDate, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter, boolean preserveFileDate, List<String> exclusionList) throws IOException {
        File[] srcFiles;
        File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtils.doCopyDirectory(srcFile, dstFile, filter, preserveFileDate, exclusionList);
                continue;
            }
            FileUtils.doCopyFile(srcFile, dstFile, preserveFileDate);
        }
        if (preserveFileDate) {
            destDir.setLastModified(srcDir.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > 0x1E00000L ? 0x1E00000L : size - pos;
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(output);
            FileUtils.closeQuietly(fos);
            FileUtils.closeQuietly(input);
            FileUtils.closeQuietly(fis);
            throw throwable;
        }
        FileUtils.closeQuietly(output);
        FileUtils.closeQuietly(fos);
        FileUtils.closeQuietly(input);
        FileUtils.closeQuietly(fis);
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean judgeFilePathValid(String filePath) {
        try {
            filePath = filePath.trim();
            File f2 = new File(filePath);
            if (f2.exists()) {
                if (f2.isDirectory()) {
                    String str = f2.getCanonicalPath();
                    filePath = filePath.toLowerCase();
                    str = str.toLowerCase();
                    return (str = str.replace(WINDOWS_SEPARATOR, UNIX_SEPARATOR)).startsWith(filePath = filePath.replace(WINDOWS_SEPARATOR, UNIX_SEPARATOR));
                }
                return false;
            }
            String str = f2.getCanonicalPath();
            File p2 = f2.getParentFile();
            if (!p2.exists()) {
                return false;
            }
            boolean flag = f2.mkdir();
            if (flag) {
                filePath = filePath.toLowerCase();
                str = str.toLowerCase();
                f2.delete();
                if (!str.startsWith(filePath)) {
                    return false;
                }
            }
            return flag;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String makeForwardSlashes(String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException("null String FileUtils.makeForwardSlashes");
        }
        return inputStr.replace('\\', '/');
    }

    public static String quoteString(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("null string");
        }
        if (!s2.contains("'")) {
            return "'" + s2 + "'";
        }
        if (!s2.contains("\"")) {
            return "\"" + s2 + "\"";
        }
        if (OSUtils.isWindows()) {
            return "\"" + s2 + "\"";
        }
        return s2.replaceAll(" ", "\\ ");
    }

    public static String getIllegalFilenameCharacters() {
        return ILLEGAL_FILENAME_STRING;
    }

    static boolean isValidString(String s2) {
        return s2 != null && s2.length() != 0;
    }

    public static void copyFile(File fin, File fout) throws IOException {
        FileUtils.copyFile(fin, fout, false);
    }

    public static void copyFile(File fin, File fout, boolean preserveFileDate) throws IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fin));
        FileOutputStream fos = FileUtils.openFileOutputStream(fout);
        FileUtils.copy((InputStream)inStream, fos, fin.length());
        if (preserveFileDate) {
            fout.setLastModified(fin.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, FileOutputStream out, long size) throws IOException {
        try {
            FileUtils.copyWithoutClose(in, out, size);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyWithoutClose(InputStream in, FileOutputStream out, long size) throws IOException {
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileChannel outChannel = out.getChannel();
        outChannel.transferFrom(inChannel, 0L, size);
    }

    public static void copy(InputStream in, OutputStream os, long size) throws IOException {
        if (os instanceof FileOutputStream) {
            FileUtils.copy(in, (FileOutputStream)os, size);
        } else {
            ReadableByteChannel inChannel = Channels.newChannel(in);
            WritableByteChannel outChannel = Channels.newChannel(os);
            if (size == 0L) {
                int read;
                ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
                do {
                    if ((read = inChannel.read(byteBuffer)) <= 0) continue;
                    byteBuffer.limit(byteBuffer.position());
                    byteBuffer.rewind();
                    outChannel.write(byteBuffer);
                    byteBuffer.clear();
                } while (read != -1);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(Long.valueOf(size).intValue());
                inChannel.read(byteBuffer);
                byteBuffer.rewind();
                outChannel.write(byteBuffer);
            }
        }
    }

    public static boolean renameFile(File fromFile, File toFile) {
        boolean log = _utillogger.isLoggable(FILE_OPERATION_LOG_LEVEL) || _utillogger.isLoggable(Level.FINE);
        RenameFileWork renameWork = new RenameFileWork(fromFile, toFile);
        int retries = FileUtils.doWithRetry(renameWork);
        boolean result = renameWork.workComplete();
        String fromFilePath = null;
        String toFilePath = null;
        if (log || !result) {
            fromFilePath = fromFile.getAbsolutePath();
            toFilePath = toFile.getAbsolutePath();
        }
        if (result) {
            if (log) {
                if (retries == 0) {
                    if (_utillogger.isLoggable(Level.FINE)) {
                        _utillogger.log(Level.FINE, strings.get("enterprise_util.rename_initial_success", fromFilePath, toFilePath));
                    }
                } else {
                    _utillogger.log(FILE_OPERATION_LOG_LEVEL, strings.get("enterprise_util.retry_rename_success", fromFilePath, toFilePath, retries));
                }
            }
        } else {
            _utillogger.log(Level.WARNING, strings.get("enterprise_util.retry_rename_failure", fromFilePath, toFilePath, retries));
        }
        return result;
    }

    public static void appendText(String fileName, String line) throws RuntimeException {
        RandomAccessFile file = null;
        try {
            String MODE = "rw";
            file = new RandomAccessFile(fileName, "rw");
            file.seek(file.getFilePointer() + file.length());
            file.writeBytes(line);
        }
        catch (Exception e2) {
            throw new RuntimeException("FileUtils.appendText()", e2);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void appendText(String fileName, StringBuffer buffer) throws IOException, FileNotFoundException {
        FileUtils.appendText(fileName, buffer.toString());
    }

    public static String readSmallFile(String fileName) throws IOException, FileNotFoundException {
        return FileUtils.readSmallFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSmallFile(File file) throws IOException {
        BufferedReader bf = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = bf.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
        }
        finally {
            try {
                bf.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    public static void removeFileRecursive(File subdir, List<File> excludeList) {
        if (subdir.exists()) {
            File[] fileLst;
            for (File file : fileLst = subdir.listFiles()) {
                if (excludeList != null && excludeList.size() > 0) {
                    boolean isDelete = true;
                    for (File excludeFile : excludeList) {
                        if (file.isFile()) {
                            if (!excludeFile.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                            isDelete = false;
                            continue;
                        }
                        if (!excludeFile.getAbsolutePath().startsWith(file.getAbsolutePath())) continue;
                        isDelete = false;
                        if (excludeFile.equals(file.getAbsoluteFile())) break;
                        FileUtils.removeFileRecursive(file, excludeList);
                    }
                    if (!isDelete) continue;
                    FileUtils.whack(file);
                    continue;
                }
                FileUtils.whack(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getManagedFile(String file, File dir) throws IOException {
        File f2 = new File(dir, file);
        if (f2.exists()) {
            return f2;
        }
        InputStream bis = null;
        OutputStream os = null;
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            if (is == null) {
                File file2 = null;
                return file2;
            }
            bis = new BufferedInputStream(is);
            f2.getParentFile().mkdirs();
            os = new BufferedOutputStream(FileUtils.openFileOutputStream(f2));
            byte[] buf = new byte[10240];
            int len = 0;
            while ((len = bis.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return f2;
    }

    public static String getTargetPattern(boolean isWin) {
        String pattern = "";
        pattern = isWin ? "[^\"'<>&\u4e00-\u9fa5]+=" + WIN_DIR_PATTERN : "[^\"'<>&\u4e00-\u9fa5]+=" + UIX_DIR_PATTERN;
        return pattern;
    }

    public static String getFilePath(String filePath) {
        if (filePath.matches(WIN_DIR_PATTERN)) {
            if ((filePath = filePath.replace(UNIX_SEPARATOR, WINDOWS_SEPARATOR)).endsWith(WINDOWS_SEPARATOR)) {
                int index = filePath.lastIndexOf(WINDOWS_SEPARATOR);
                filePath = filePath.substring(0, index);
            }
        } else if ((filePath = filePath.replace(WINDOWS_SEPARATOR, UNIX_SEPARATOR)).endsWith(UNIX_SEPARATOR)) {
            int index = filePath.lastIndexOf(UNIX_SEPARATOR);
            filePath = filePath.substring(0, index);
        }
        return filePath;
    }

    public static String getUploadPathPattern() {
        if (File.separatorChar == '\\') {
            return WIN_DIR_PATTERN;
        }
        return UIX_DIR_PATTERN;
    }

    public static boolean hasSubFiles(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                return false;
            }
            return file.isDirectory() && file.listFiles().length > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String s2, File f2) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(f2);
            ((Writer)writer).write(s2);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
                f2.setReadable(true);
                f2.setWritable(true);
            }
        }
    }

    public static File[] findFilesInDir(File dir, final String regexp) {
        try {
            File[] matches = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(regexp);
                }
            });
            if (matches != null) {
                return matches;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(File zipFile, String outputPath) throws IOException {
        File root;
        if (outputPath.endsWith(File.separator)) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        if (!(root = new File(outputPath)).exists()) {
            root.mkdirs();
        }
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || name.endsWith(UNIX_SEPARATOR)) {
                    try {
                        if (name.endsWith(UNIX_SEPARATOR)) {
                            name = name.substring(0, name.length() - 1);
                        }
                        File f2 = new File(outputPath, name);
                        f2.mkdir();
                    }
                    catch (Throwable f2) {}
                    continue;
                }
                File tempfile = new File(outputPath, name);
                tempfile.createNewFile();
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(tempfile);
                    byte[] b2 = new byte[1024];
                    int offsize = 0;
                    int len = 0;
                    while ((len = zip.read(b2, offsize, b2.length)) != -1) {
                        out.write(b2, offsize, len);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                if (entry.getTime() <= 0L) continue;
                tempfile.setLastModified(entry.getTime());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void compressFile(File zipFile, File srcFile) throws Exception {
        FileUtils.compressFile(zipFile, srcFile, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(File zipFile, File srcFile, FileFilter filter, boolean removeOld) throws Exception {
        if (zipFile == null || srcFile == null) {
            return;
        }
        try {
            if (zipFile.exists()) {
                zipFile.delete();
            }
            zipFile.createNewFile();
            FileOutputStream f2 = new FileOutputStream(zipFile, true);
            CheckedOutputStream csum = new CheckedOutputStream(f2, new Adler32());
            ZipOutputStream out = null;
            try {
                out = new ZipOutputStream(new BufferedOutputStream(csum));
                FileUtils.zipFile(out, srcFile, "", filter, removeOld);
                out.flush();
                out.finish();
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void zipFile(ZipOutputStream out, File srcDir, String filePath) throws IOException {
        FileUtils.zipFile(out, srcDir, filePath, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(ZipOutputStream out, File srcDir, String filePath, FileFilter filter, boolean removeOld) throws IOException {
        for (File file : srcDir.listFiles(filter)) {
            if (file.isDirectory()) {
                ZipEntry entry = new ZipEntry(filePath + file.getName() + UNIX_SEPARATOR);
                entry.setTime(srcDir.lastModified());
                entry.setMethod(0);
                entry.setSize(0L);
                entry.setCrc(0L);
                out.putNextEntry(entry);
                out.closeEntry();
                FileUtils.zipFile(out, file, filePath + file.getName() + UNIX_SEPARATOR, filter, removeOld);
                if (!removeOld) continue;
                file.delete();
                continue;
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(filePath + file.getName()));
                byte[] b2 = new byte[1024];
                int off = 0;
                int length = 0;
                while ((length = in.read(b2, off, b2.length)) != -1) {
                    out.write(b2, off, length);
                }
                out.flush();
                out.closeEntry();
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            if (!removeOld) continue;
            file.delete();
        }
    }

    public static boolean isExists(String location) {
        File file = new File(location);
        return file.exists();
    }

    public static boolean isDirectory(String location) {
        File file = new File(location);
        return file.exists() && file.isDirectory();
    }

    public static String convertURI2Path(String uriPath) {
        if (uriPath == null || uriPath.isEmpty()) {
            return uriPath;
        }
        try {
            return new URI(uriPath).getPath();
        }
        catch (URISyntaxException e2) {
            return uriPath;
        }
    }

    public static List<String> convertURI2Path(List<String> uriPaths) {
        if (uriPaths == null) {
            return null;
        }
        ArrayList<String> convertedURIPaths = new ArrayList<String>();
        for (String uriPath : uriPaths) {
            convertedURIPaths.add(FileUtils.convertURI2Path(uriPath));
        }
        return convertedURIPaths;
    }

    public static boolean isJarFile(File file) {
        try {
            boolean result = false;
            if (file.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(file);
                if (jar != null) {
                    result = jar.entries().hasMoreElements();
                }
                jar.close();
                return result;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static String getFileName(String filePath) {
        String name = new File(filePath).getName();
        int index = name.indexOf(".");
        if (index > 0) {
            return name.substring(0, index);
        }
        return filePath;
    }

    public static void copyDir(File srcDir, File destDir) throws Exception {
        File[] fs;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (srcDir.isFile()) {
            FileUtils.copyFile(srcDir, new File(destDir, srcDir.getName()));
            return;
        }
        for (File f2 : fs = srcDir.listFiles()) {
            if (f2.isFile()) {
                FileUtils.copyFile(f2, new File(destDir, f2.getName()));
                continue;
            }
            FileUtils.copyDir(f2, new File(destDir, f2.getName()));
        }
    }

    public static boolean isExistsFilePath(String filePath) {
        File f2 = new File(filePath);
        return f2.exists() && f2.isDirectory();
    }

    public static boolean judgePathHasInValidChars(String path) {
        String regex = "^.*[\\^;%*&#<>',\"?]+.*$";
        return path.matches(regex);
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static String formatInputPath(String fileForm) {
        if (fileForm == null) {
            return "";
        }
        fileForm = fileForm.trim();
        fileForm = fileForm.replace('\\', '/');
        String regEx = "//*";
        Pattern p2 = Pattern.compile(regEx);
        Matcher m2 = p2.matcher(fileForm);
        fileForm = m2.replaceAll(UNIX_SEPARATOR);
        if (fileForm.endsWith(UNIX_SEPARATOR)) {
            fileForm = fileForm.substring(0, fileForm.length() - 1);
        }
        if (FileUtils.isWindows()) {
            fileForm = fileForm.replace('/', '\\');
        }
        return fileForm;
    }

    public static String formatDir(String fileDir) {
        if (fileDir == null) {
            return "";
        }
        fileDir = fileDir.trim();
        fileDir = fileDir.replace('\\', '/');
        String regEx = "//*";
        Pattern p2 = Pattern.compile(regEx);
        Matcher m2 = p2.matcher(fileDir);
        fileDir = m2.replaceAll(UNIX_SEPARATOR);
        if (fileDir.endsWith(UNIX_SEPARATOR)) {
            fileDir = fileDir.substring(0, fileDir.length() - 1);
        }
        return fileDir;
    }

    public static File getTempDirectory() {
        String temp = System.getProperty("java.io.tmpdir");
        String home = System.getProperty("user.name");
        if (home == null) {
            home = "";
        }
        File tmp = null;
        tmp = temp == null ? new File(home, "tmp") : new File(temp, "j2ee-ri-" + home);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        return tmp;
    }

    public static String getAbsolutePath(String relativePath) {
        if (FileUtils.isAbsolute(relativePath)) {
            return relativePath;
        }
        String rpath = relativePath.replace('/', File.separatorChar);
        if (basedir == null) {
            FileUtils.setBaseDir();
        }
        String path = basedir + File.separator + rpath;
        return new File(path).getAbsolutePath();
    }

    private static void setBaseDir() {
        basedir = System.getProperty(HOME_DIR_PROP);
        if (basedir != null) {
            return;
        }
        basedir = DEFAULT_HOME_DIR;
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            if (!filename.endsWith(JAR_FILE_NAME)) continue;
            try {
                String parent = new File(filename).getAbsoluteFile().getParentFile().getParent();
                if (parent != null) {
                    basedir = parent;
                }
                return;
            }
            catch (NullPointerException ex) {
                return;
            }
        }
    }

    private static boolean isAbsolute(String fpath) {
        return new File(fpath).isAbsolute();
    }

    public static String classNameFromEntryName(String entryName) {
        String className = entryName;
        if (entryName.endsWith(".class")) {
            int dotClassIndex = entryName.indexOf(".class");
            className = entryName.substring(0, dotClassIndex);
            className = className.replace('/', '.');
        }
        return className;
    }

    public static String classNameFromFile(File file) {
        String className = file.toString();
        if (className.endsWith(".class")) {
            String contentFileStr = className.replace(File.separatorChar, '.');
            int cutOffPoint = contentFileStr.lastIndexOf(".class");
            className = contentFileStr.substring(0, cutOffPoint);
        }
        return className;
    }

    public static boolean jarEntriesEqual(File file1, String entry1Name, File file2, String entry2Name) throws IOException {
        boolean identical = false;
        JarFile jarFile1 = null;
        ZipFile jarFile2 = null;
        try {
            jarFile1 = new JarFile(file1);
            jarFile2 = new JarFile(file2);
            String jarEntry1Name = entry1Name.replace(File.separatorChar, '/');
            String jarEntry2Name = entry2Name.replace(File.separatorChar, '/');
            JarEntry entry1 = jarFile1.getJarEntry(jarEntry1Name);
            JarEntry entry2 = ((JarFile)jarFile2).getJarEntry(jarEntry2Name);
            if (entry1 == null) {
            } else if (entry2 == null) {
            } else {
                identical = FileUtils.jarEntriesEqual(jarFile1, entry1, (JarFile)jarFile2, entry2);
            }
        }
        catch (IOException e2) {
            throw e2;
        }
        finally {
            if (jarFile1 != null) {
                jarFile1.close();
            }
            if (jarFile2 != null) {
                jarFile2.close();
            }
        }
        return identical;
    }

    public static boolean jarEntriesEqual(JarFile jarFile1, JarEntry entry1, JarFile jarFile2, JarEntry entry2) throws IOException {
        boolean identical = false;
        int entry1Size = (int)entry1.getSize();
        int entry2Size = (int)entry2.getSize();
        if ((long)entry1Size == -1L || (long)entry2Size == -1L || entry1Size == entry2Size) {
            if (entry1Size == 0) {
                return true;
            }
            InputStream inputStream1 = null;
            InputStream inputStream2 = null;
            try {
                inputStream1 = jarFile1.getInputStream(entry1);
                inputStream2 = jarFile2.getInputStream(entry2);
                byte[] file1Bytes = new byte[entry1Size];
                byte[] file2Bytes = new byte[entry2Size];
                int read = 0;
                int numBytesRead1 = 0;
                while ((read = inputStream1.read(file1Bytes, numBytesRead1, entry1Size - numBytesRead1)) != -1 && (numBytesRead1 += read) != entry1Size) {
                }
                int numBytesRead2 = 0;
                while ((read = inputStream2.read(file2Bytes, numBytesRead2, entry2Size - numBytesRead2)) != -1 & (numBytesRead2 += read) != entry2Size) {
                }
                if (numBytesRead1 == -1 || numBytesRead2 == -1) {
                    throw new IOException("Byte read error " + numBytesRead1 + " " + numBytesRead2);
                }
                if (Arrays.equals(file1Bytes, file2Bytes)) {
                    identical = true;
                }
            }
            catch (IOException e2) {
                throw e2;
            }
            finally {
                if (inputStream1 != null) {
                    inputStream1.close();
                }
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
        }
        return identical;
    }

    public static boolean isEARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isWARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("WEB-INF/web.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isEJBJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ejb-jar.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isRARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ra.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isAppClientJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application-client.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean deleteDir(File fileDir) {
        return FileUtils.delete(fileDir);
    }

    public static URL getEntryAsUrl(File moduleLocation, String uri) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e2) {
            url = null;
        }
        if (url != null) {
            return url;
        }
        if (moduleLocation != null) {
            if (moduleLocation.isFile()) {
                url = FileUtils.createJarUrl(moduleLocation, uri);
            } else {
                String path = uri.replace('/', File.separatorChar);
                url = new File(moduleLocation, path).toURI().toURL();
            }
        }
        return url;
    }

    public static URL createJarUrl(File jarFile, String entry) throws MalformedURLException, IOException {
        return new URL("jar:" + jarFile.toURI().toURL() + "!/" + entry);
    }

    public static String makePackageName(String packageName) {
        String rad = "0123456789";
        StringBuffer result = new StringBuffer();
        Random rand = new Random();
        int length = 32;
        for (int i2 = 0; i2 < length; ++i2) {
            int randNum = rand.nextInt(10);
            result.append(rad.substring(randNum, randNum + 1));
        }
        return packageName + result.toString();
    }

    public static void deleteUploadFileFromTmp(String moduleID, boolean deleteLatest) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "generated");
        if (tmpDir.exists()) {
            File find = null;
            for (int i2 = 0; i2 < tmpDir.listFiles().length; ++i2) {
                String fileName = tmpDir.listFiles()[i2].getName();
                if (!fileName.startsWith(moduleID) || !fileName.endsWith(".zip")) continue;
                find = tmpDir.listFiles()[i2];
                break;
            }
            if (find == null) {
                long baseTime = deleteLatest ? 0L : System.currentTimeMillis();
                for (int i3 = 0; i3 < tmpDir.listFiles().length; ++i3) {
                    long lastModifiedTime;
                    int nameLen = tmpDir.listFiles()[i3].getName().length();
                    if (nameLen != moduleID.length() + 32 + 4 || tmpDir.listFiles()[i3].getName().indexOf(moduleID) != 0 || !FileUtils.compareTime(baseTime, lastModifiedTime = tmpDir.listFiles()[i3].lastModified(), deleteLatest)) continue;
                    baseTime = lastModifiedTime;
                    find = tmpDir.listFiles()[i3];
                }
            }
            if (find != null) {
                find.delete();
            }
        }
    }

    private static boolean compareTime(long baseTime, long comparedTime, boolean deleteLatest) {
        if (deleteLatest) {
            return baseTime <= comparedTime;
        }
        return baseTime >= comparedTime;
    }

    public static byte[] getContentByFilePath(String filePath, long offset) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            return new byte[0];
        }
        if (file.isFile()) {
            byte[] bytes = FileUtils.inputstream2Bytes(file, offset);
            return bytes;
        }
        int index = filePath.lastIndexOf(File.separator) + 1;
        String appName = filePath.substring(index);
        File parent = new File(GENERATE_DIR, TMP_DIR);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File tmpFile = new File(parent, appName + ".zip");
        try {
            byte[] bytes;
            if (offset == 0L) {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                tmpFile.createNewFile();
                FileOutputStream f2 = new FileOutputStream(tmpFile, true);
                CheckedOutputStream csum = new CheckedOutputStream(f2, new Adler32());
                ZipOutputStream out = null;
                try {
                    out = new ZipOutputStream(new BufferedOutputStream(csum));
                    FileUtils.zipFile(out, file, "");
                    out.flush();
                }
                catch (Throwable e2) {
                    throw e2;
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((bytes = FileUtils.inputstream2Bytes(tmpFile, offset)).length == 0) {
                tmpFile.delete();
            }
            return bytes;
        }
        catch (Throwable ex) {
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inputstream2Bytes(File tmpFile, long offset) throws IOException {
        BufferedInputStream ins = null;
        try {
            ins = new BufferedInputStream(new FileInputStream(tmpFile));
            byte[] b2 = new byte[65536];
            ins.skip(offset);
            int len = ins.read(b2, 0, b2.length);
            if (len == b2.length) {
                byte[] byArray = b2;
                return byArray;
            }
            if (len > 0) {
                byte[] tmp = new byte[len];
                System.arraycopy(b2, 0, tmp, 0, len);
                byte[] byArray = tmp;
                return byArray;
            }
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void saveContentByFilePath(byte[] bytes, String destFilePath, long offset, boolean isFolder) throws Exception {
        File file = new File(destFilePath);
        if (isFolder) {
            file.mkdirs();
        } else {
            if (bytes == null) {
                return;
            }
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (offset == 0L) {
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            FileUtils.writeFile(bytes, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] bytes, File f2) throws IOException {
        RandomAccessFile raf = null;
        try {
            if (f2.exists()) {
                f2.delete();
            }
            f2.createNewFile();
            raf = new RandomAccessFile(f2, "rw");
            raf.write(bytes);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static boolean judgeReallyFilePathValid(String filePath) throws Exception {
        try {
            filePath = filePath.trim();
            File f2 = new File(filePath);
            return f2.exists() && f2.isFile();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static byte[] getContent(File file) throws Exception {
        if (!file.exists() || !file.isFile()) {
            return new byte[0];
        }
        return FileUtils.file2ByteArr(file);
    }

    public static byte[] getContent(File file, String fromEncoding, String toEncoding) throws Exception {
        if (!file.exists() || !file.isFile()) {
            return new byte[0];
        }
        return FileUtils.convertContent(FileUtils.file2ByteArr(file), fromEncoding, toEncoding);
    }

    public static byte[] getContent(String filePath) throws Exception {
        return FileUtils.getContent(new File(filePath));
    }

    public static String getContentAsString(File file, String fromEncoding) throws Exception {
        byte[] bytes = FileUtils.getContent(file);
        return StringUtils.isBlank(fromEncoding) ? new String(bytes) : new String(bytes, fromEncoding);
    }

    private static byte[] convertContent(byte[] bytes, String fromEncoding, String toEncoding) throws UnsupportedEncodingException {
        if (bytes == null) {
            bytes = new byte[]{};
        } else if (StringUtils.isBlank(fromEncoding)) {
            if (StringUtils.isNotBlank(toEncoding)) {
                bytes = new String(bytes).getBytes(toEncoding);
            }
        } else if (StringUtils.isBlank(toEncoding)) {
            bytes = new String(bytes, fromEncoding).getBytes();
        } else if (!fromEncoding.equals(toEncoding)) {
            bytes = new String(bytes, fromEncoding).getBytes(toEncoding);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2ByteArr(File tmpFile) throws Exception {
        byte[] result = null;
        BufferedInputStream ins = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(65536);
        try {
            ins = new BufferedInputStream(new FileInputStream(tmpFile));
            byte[] b2 = new byte[65536];
            int len = 0;
            while ((len = ins.read(b2)) != -1) {
                bos.write(b2, 0, len);
            }
            bos.close();
            result = bos.toByteArray();
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static List<File> listAllFiles(File dir) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (dir != null && dir.exists() && dir.isDirectory()) {
            FileUtils.listAllFiles(dir, fileList);
        }
        return fileList;
    }

    public static List<File> listAllFiles(String dir) {
        return StringUtils.isBlank(dir) ? FileUtils.listAllFiles((File)null) : FileUtils.listAllFiles(new File(dir));
    }

    private static void listAllFiles(File dir, List<File> fileList) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileUtils.listAllFiles(file, fileList);
            }
        }
    }

    public static File createLicTmp(String dir) {
        File tempDir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")), dir);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            _logger.log(Level.SEVERE, String.format("Failed to create temporary directory %s.", tempDir.getAbsolutePath()));
        }
        return tempDir;
    }

    private static class FileOutputStreamWork
    implements RetriableWork {
        private FileOutputStream fos = null;
        private Throwable lastError = null;
        private File out;

        public FileOutputStreamWork(File out) {
            this.out = out;
        }

        @Override
        public boolean workComplete() {
            return this.fos != null;
        }

        @Override
        public void run() {
            try {
                this.fos = new FileOutputStream(this.out);
                this.lastError = null;
            }
            catch (IOException ioe) {
                this.lastError = ioe;
            }
        }

        public FileOutputStream getStream() {
            return this.fos;
        }

        public Throwable getLastError() {
            return this.lastError;
        }
    }

    private static class RenameFileWork
    implements RetriableWork {
        private File originalFile;
        private File newFile;
        private boolean renameResult = false;

        public RenameFileWork(File originalFile, File newFile) {
            this.originalFile = originalFile;
            this.newFile = newFile;
        }

        @Override
        public boolean workComplete() {
            return this.renameResult;
        }

        @Override
        public void run() {
            this.renameResult = this.originalFile.renameTo(this.newFile);
        }
    }

    private static interface RetriableWork
    extends Runnable {
        public boolean workComplete();
    }
}

