/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.StringUtils;

public final class JDKVersionUtils {
    private static int major;
    private static int minor;
    private static int subminor;
    private static int update;
    private static int jdk9Version;

    private static void initialize() {
        major = 1;
        update = 0;
        subminor = 0;
        minor = 0;
        try {
            String jv = System.getProperty("java.version");
            if (!StringUtils.ok(jv)) {
                return;
            }
            String[] ss = jv.split("\\.");
            if (ss != null || ss.length >= 1) {
                jdk9Version = Integer.parseInt(ss[0]);
            }
            if (ss == null || ss.length < 3 || !ss[0].equals("1")) {
                return;
            }
            major = Integer.parseInt(ss[0]);
            minor = Integer.parseInt(ss[1]);
            if ((ss = ss[2].split("_")) == null || ss.length < 1) {
                return;
            }
            subminor = Integer.parseInt(ss[0]);
            if (ss.length > 1) {
                update = Integer.parseInt(ss[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JDKVersionUtils() {
    }

    public static boolean ok() {
        return major == 1 && minor >= 6;
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getSubMinor() {
        return subminor;
    }

    public static int getUpdate() {
        return update;
    }

    public static boolean isMoreThanJDK9() {
        return jdk9Version >= 9;
    }

    public static boolean isMoreThanJDK9(String javaExeVersion) {
        boolean isMoreThanJDK9 = false;
        if (!StringUtils.ok(javaExeVersion)) {
            isMoreThanJDK9 = JDKVersionUtils.isMoreThanJDK9();
        } else {
            String[] ss = javaExeVersion.split("\\.");
            if (ss != null || ss.length >= 1) {
                isMoreThanJDK9 = Integer.parseInt(ss[0]) >= 9;
            }
        }
        return isMoreThanJDK9;
    }

    public static String toStringStatic() {
        return "major: " + JDKVersionUtils.getMajor() + "\nminor: " + JDKVersionUtils.getMinor() + "\nsubminor: " + JDKVersionUtils.getSubMinor() + "\nupdate: " + JDKVersionUtils.getUpdate() + "\nOK ==>" + JDKVersionUtils.ok();
    }

    static {
        JDKVersionUtils.initialize();
    }
}

