/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.process.ProcessManager;
import com.bes.enterprise.appserver.common.util.OSUtils;
import com.bes.enterprise.appserver.common.util.SanitizeFile;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Jps {
    private Map<String, Integer> pidMap = new HashMap<String, Integer>();
    private static final File jpsExe;
    private static final String jpsName;

    public static void main(String[] args) {
        Set<Map.Entry<String, Integer>> set = Jps.getProcessTable().entrySet();
        System.out.println("** Got " + set.size() + " process entries");
        for (Map.Entry<String, Integer> e2 : set) {
            System.out.printf("%d %s\n", e2.getValue(), e2.getKey());
        }
    }

    public static final Map<String, Integer> getProcessTable() {
        return new Jps().pidMap;
    }

    public static final int getPid(String mainClassName) {
        Jps jps = new Jps();
        Integer integer = jps.pidMap.get(mainClassName);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static final boolean isPid(int apid) {
        return new Jps().pidMap.containsValue(apid);
    }

    private Jps() {
        try {
            String[] ss;
            if (jpsExe == null) {
                return;
            }
            ProcessManager pm = new ProcessManager(jpsExe.getPath(), "-l");
            pm.setEcho(false);
            pm.execute();
            String jpsOutput = pm.getStdout();
            for (String line : ss = jpsOutput.split("[\n\r]")) {
                String[] sublines;
                if (line == null || line.length() <= 0 || (sublines = line.split(" ")) == null || sublines.length != 2) continue;
                int aPid = 0;
                try {
                    aPid = Integer.parseInt(sublines[0]);
                }
                catch (Exception e2) {
                    continue;
                }
                if (this.isJps(sublines[1])) continue;
                this.pidMap.put(sublines[1], aPid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isJps(String id) {
        if (!StringUtils.ok(id)) {
            return false;
        }
        if (id.equals(this.getClass().getName())) {
            return true;
        }
        return id.equals("sun.tools.jps.Jps");
    }

    static {
        jpsName = OSUtils.isWindows() ? "jps.exe" : "jps";
        String javaroot = System.getProperty("java.home");
        String relpath = "/bin/" + jpsName;
        File fhere = new File(javaroot + relpath);
        File fthere = new File(javaroot + "/.." + relpath);
        jpsExe = fhere.isFile() ? SanitizeFile.sanitize(fhere) : (fthere.isFile() ? SanitizeFile.sanitize(fthere) : null);
    }
}

