/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManifestUtils {
    private static final Logger logger = Logger.getLogger(ManifestUtils.class.getName());

    public static List<URL> getManifestClassPathUrls(File appFile) {
        try {
            Manifest manifest = ManifestUtils.getManifest(appFile);
            return ManifestUtils.getManifestClassPathAsURLs(manifest, appFile.getParent());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while getting manifest classpath: ", ioe);
            return new ArrayList<URL>();
        }
    }

    public static Map<String, URL> getManifestClassPath(File appFile) {
        try {
            Manifest manifest = ManifestUtils.getManifest(appFile);
            return ManifestUtils.getManifestClassPath(manifest, appFile.getParent());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while getting manifest classpath: ", ioe);
            return new HashMap<String, URL>();
        }
    }

    private static Map<String, URL> getManifestClassPath(Manifest manifest, String rootPath) {
        Map<String, URL> urlMap = new HashMap<String, URL>();
        if (manifest != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                Attributes.Name key = (Attributes.Name)entry.getKey();
                if (!key.equals(Attributes.Name.CLASS_PATH)) continue;
                String classpathString = (String)entry.getValue();
                urlMap = ManifestUtils.getURLsFromClasspath(classpathString, " ", rootPath);
            }
        }
        return urlMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(File appFile) throws IOException {
        block6: {
            if (appFile.isDirectory()) {
                try (InputStream is = null;){
                    is = ManifestUtils.getEntry(appFile, "META-INF/MANIFEST.MF");
                    if (is != null) {
                        Manifest m2;
                        Manifest manifest = m2 = new Manifest(is);
                        return manifest;
                    }
                    break block6;
                }
            }
            JarFile jarFile = new JarFile(appFile);
            return jarFile.getManifest();
        }
        return null;
    }

    private static InputStream getEntry(File appFile, String name) throws IOException {
        File input = ManifestUtils.getEntryFile(appFile, name);
        if (!input.exists() || input.isDirectory()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(input);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            return bis;
        }
        catch (Throwable tx) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable thr) {
                    throw new IOException("Error closing FileInputStream after error opening BufferedInputStream for entry " + name, thr);
                }
            }
            throw new IOException("Error opening BufferedInputStream for entry " + name, tx);
        }
    }

    private static File getEntryFile(File appFile, String name) {
        name = name.replace('/', File.separatorChar);
        return new File(appFile, name);
    }

    private static List<URL> getManifestClassPathAsURLs(Manifest manifest, String rootPath) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (manifest != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                Attributes.Name key = (Attributes.Name)entry.getKey();
                if (!key.equals(Attributes.Name.CLASS_PATH)) continue;
                String classpathString = (String)entry.getValue();
                urlList = new ArrayList<URL>(ManifestUtils.getURLsFromClasspath(classpathString, " ", rootPath).values());
            }
        }
        return urlList;
    }

    private static Map<String, URL> getURLsFromClasspath(String classpath, String delimiter, String rootPath) {
        HashMap<String, URL> urls = new HashMap<String, URL>();
        if (classpath == null || classpath.length() == 0) {
            return urls;
        }
        StringTokenizer st = new StringTokenizer(classpath, delimiter);
        while (st.hasMoreTokens()) {
            try {
                File f2;
                String path = st.nextToken();
                try {
                    URL url = new URL(path);
                    URI uri = url.toURI();
                    if (uri.isAbsolute()) {
                        urls.put(path, uri.toURL());
                        continue;
                    }
                }
                catch (Exception url) {
                    // empty catch block
                }
                String absolutePath = path;
                if (rootPath != null && rootPath.length() != 0) {
                    absolutePath = rootPath + File.separator + absolutePath;
                }
                if (!(f2 = new File(absolutePath)).exists()) continue;
                urls.put(path, f2.toURI().toURL());
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "unexpected error in getting urls", e2);
            }
        }
        return urls;
    }
}

