/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.BaseHttpConnection;
import com.bes.enterprise.appserver.common.util.SecurityUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultipartFormDataConnection
extends BaseHttpConnection {
    private static final String BOUNDARY = "x-application-bes-form-upload";
    private static final String FILE_UPLOAD_PATH = "sysapp/SysFileUploadServlet";
    private Map<String, String> textParameters = new HashMap<String, String>();
    private Map<String, File> fileParameters = new HashMap<String, File>();

    public MultipartFormDataConnection() {
        this.setRemoteUri(FILE_UPLOAD_PATH);
    }

    public Map<String, String> getTextParameters() {
        return this.textParameters;
    }

    public Map<String, File> getFileParameters() {
        return this.fileParameters;
    }

    public void addTextParameter(String name, String value) {
        this.textParameters.put(name, value);
    }

    public void addFileParameters(String name, File file) {
        this.fileParameters.put(name, file);
    }

    @Override
    protected void sendData(HttpURLConnection conn) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        OutputStream outputStream = conn.getOutputStream();
        DataOutputStream dataOut = new DataOutputStream(outputStream);
        Set<Map.Entry<String, String>> textEntrySet = this.textParameters.entrySet();
        for (Map.Entry<String, String> textEntry : textEntrySet) {
            String name = textEntry.getKey();
            String value = textEntry.getValue();
            dataOut.writeBytes("--x-application-bes-form-upload\r\n");
            dataOut.writeBytes("Content-Disposition: form-data;name=\"" + name + "\"\r\n");
            dataOut.writeBytes("\r\n");
            if ("j_sysapp_username".equals(name) || "j_sysapp_password".equals(name)) {
                dataOut.writeBytes(this.cncrypt(value));
            } else {
                dataOut.writeBytes(value);
            }
            dataOut.writeBytes("\r\n");
        }
        Set<Map.Entry<String, File>> fileEntrySet = this.fileParameters.entrySet();
        for (Map.Entry<String, File> fileEntry : fileEntrySet) {
            String name = fileEntry.getKey();
            File file = fileEntry.getValue();
            dataOut.writeBytes("--x-application-bes-form-upload\r\n");
            dataOut.writeBytes("Content-Disposition: form-data;name=\"" + name + "\"; filename=\"" + file.getName() + "\"\r\n");
            dataOut.writeBytes("Content-Type: " + this.getContextType(file) + "\r\n");
            dataOut.writeBytes("\r\n");
            this.writeFileBytes(file, dataOut);
            dataOut.writeBytes("\r\n");
        }
        dataOut.writeBytes("--x-application-bes-form-upload--\r\n");
        dataOut.writeBytes("\r\n");
    }

    @Override
    protected Object handleResponse(HttpURLConnection conn) throws IOException {
        int ch;
        InputStream is = conn.getInputStream();
        StringBuilder outBuffer = new StringBuilder();
        while ((ch = is.read()) >= 0) {
            outBuffer.append((char)ch);
        }
        return outBuffer.toString();
    }

    private void writeFileBytes(File file, OutputStream out) throws IOException {
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(file);
            byte[] data = new byte[4096];
            int len = -1;
            while ((len = fIn.read(data)) != -1) {
                out.write(data, 0, len);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getContextType(File file) throws IOException {
        String contentType = Files.probeContentType(Paths.get(file.getPath(), new String[0]));
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private String cncrypt(String value) throws NoSuchAlgorithmException {
        String encodeValue = SecurityUtil.shaDigest(value);
        return encodeValue;
    }

    @Override
    protected void configConnectionProperty(HttpURLConnection conn) throws IOException {
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=x-application-bes-form-upload");
        conn.setRequestProperty("connection", "close");
    }
}

