/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.io.File;

public class OSUtils {
    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isUNIX() {
        return File.separatorChar == '/';
    }

    public static boolean isUnix() {
        return OSUtils.isUNIX();
    }

    public static boolean isHP() {
        return OSUtils.isName("HP-UX");
    }

    public static boolean isSun() {
        return OSUtils.isName("sun");
    }

    public static boolean isSolaris10() {
        return OSUtils.isSun() && OSUtils.isVersion("5.10");
    }

    public static boolean isSunSparc() {
        return OSUtils.isName("sun") && OSUtils.isArch("sparc");
    }

    public static boolean isSunX86() {
        return OSUtils.isName("sun") && OSUtils.isArch("x86");
    }

    public static boolean isLinux() {
        return OSUtils.isName("linux");
    }

    public static boolean isDarwin() {
        return OSUtils.isName("Mac OS X");
    }

    public static boolean isWindowsForSure() {
        return OSUtils.isName("windows") && OSUtils.isWindows();
    }

    public static boolean isDebianLinux() {
        return OSUtils.isLinux() && new File("/etc/debian_version").exists();
    }

    public static boolean isFedoraLinux() {
        return OSUtils.isLinux() && new File("/etc/fedora-release").exists();
    }

    public static boolean isGentooLinux() {
        return OSUtils.isLinux() && new File("/etc/gentoo-release").exists();
    }

    public static boolean isKnoppixLinux() {
        return OSUtils.isLinux() && new File("/etc/knoppix_version").exists();
    }

    public static boolean isMandrakeLinux() {
        return OSUtils.isLinux() && new File("/etc/mandrake-release").exists();
    }

    public static boolean isMandrivaLinux() {
        return OSUtils.isLinux() && new File("/etc/mandriva-release").exists();
    }

    public static boolean isRedHatLinux() {
        return OSUtils.isLinux() && new File("/etc/redhat-release").exists();
    }

    public static boolean isSlackwareLinux() {
        return OSUtils.isLinux() && new File("/etc/slackware-version").exists();
    }

    public static boolean isSuSELinux() {
        return OSUtils.isLinux() && new File("/etc/SuSE-release").exists();
    }

    public static boolean isUbuntuLinux() {
        return OSUtils.isLinux() && new File("/etc/lsb-release").exists();
    }

    public static boolean isAix() {
        return OSUtils.isName("AIX");
    }

    private static boolean isArch(String name) {
        String archname = System.getProperty("os.arch");
        if (archname == null || archname.length() <= 0) {
            return false;
        }
        return (archname = archname.toLowerCase()).indexOf(name = name.toLowerCase()) >= 0;
    }

    private static boolean isName(String name) {
        String osname = System.getProperty("os.name");
        if (osname == null || osname.length() <= 0) {
            return false;
        }
        return (osname = osname.toLowerCase()).indexOf(name = name.toLowerCase()) >= 0;
    }

    private static boolean isVersion(String version) {
        String osversion = System.getProperty("os.version");
        if (osversion == null || osversion.length() <= 0 || version == null || version.length() <= 0) {
            return false;
        }
        return osversion.equals(version);
    }

    public static void main(String[] args) {
        System.out.println("os.version = " + System.getProperty("os.version"));
        System.out.println("os.name = " + System.getProperty("os.name"));
        System.out.println("os.arch = " + System.getProperty("os.arch"));
        System.out.println("isUNIX() returned: " + OSUtils.isUNIX());
        System.out.println("isWindows() returned: " + OSUtils.isWindows());
        System.out.println("isWindowsForSure() returned: " + OSUtils.isWindowsForSure());
        System.out.println("isHP() returned: " + OSUtils.isHP());
        System.out.println("isSun() returned: " + OSUtils.isSun());
        System.out.println("isLinux() returned: " + OSUtils.isLinux());
        System.out.println("isDebianLinux() returned: " + OSUtils.isDebianLinux());
        System.out.println("isFedoraLinux() returned: " + OSUtils.isFedoraLinux());
        System.out.println("isGentooLinux() returned: " + OSUtils.isGentooLinux());
        System.out.println("isKnoppixLinux() returned: " + OSUtils.isKnoppixLinux());
        System.out.println("isMandrakeLinux() returned: " + OSUtils.isMandrakeLinux());
        System.out.println("isMandrivaLinux() returned: " + OSUtils.isMandrivaLinux());
        System.out.println("isRedHatLinux() returned: " + OSUtils.isRedHatLinux());
        System.out.println("isSlackwareLinux() returned: " + OSUtils.isSlackwareLinux());
        System.out.println("isSuSELinux() returned: " + OSUtils.isSuSELinux());
        System.out.println("isUbuntuLinux() returned: " + OSUtils.isUbuntuLinux());
        System.out.println("isSunX86() returned: " + OSUtils.isSunX86());
        System.out.println("isSunSparc() returned: " + OSUtils.isSunSparc());
        System.out.println("isDarwin() returned: " + OSUtils.isDarwin());
        System.out.println("isSolaris10() returned: " + OSUtils.isSolaris10());
        System.out.println("isAix() returned: " + OSUtils.isAix());
    }
}

