/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.aes.AES;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class PasswordUtil {
    public static String PASSWORD_PREFIX = "BES_ADMIN_PASSWORD";
    public static String PASSPORT_PREFIX = "BES_IASTOOL_PASSPORT";
    public static String BES_ADMIN_PREFIX = "BES_ADMIN_";

    public static String decrypt(String password) {
        if (!StringUtils.isBlank(password) && password.startsWith("{AES}")) {
            try {
                return AES.decrypt(password);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return password;
    }

    public static String encrypt(String password) {
        if (password != null && !password.startsWith("{AES}")) {
            try {
                return AES.encrypt(password);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return password;
    }

    public static String readPasswordFromFile(String filePath, String prefix) throws IOException {
        File pwdFile = new File(filePath);
        if (!pwdFile.exists()) {
            throw new FileNotFoundException(filePath + " does not exist!");
        }
        if (!pwdFile.isFile()) {
            throw new IOException(filePath + " is not a file!");
        }
        if (!pwdFile.canRead()) {
            throw new IOException(filePath + " can not read!");
        }
        BufferedReader br = null;
        String decodePassword = null;
        String password = "";
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            while ((line = br.readLine()) != null) {
                if (line.indexOf(prefix) == -1) continue;
                decodePassword = line.substring(prefix.length() + 1);
                break;
            }
            if (decodePassword != null && !"".equals(decodePassword)) {
                password = PasswordUtil.decrypt(decodePassword);
            }
        }
        catch (Exception e2) {
            throw new IOException(e2.getLocalizedMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return password;
    }
}

