/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProxyUtils {
    private static List<Class<?>> javaTypes = new ArrayList();

    private ProxyUtils() {
    }

    public static Object getClassNameInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Object newInstanceByConstructor(Class<?> clazz) {
        try {
            Constructor<?> cons = clazz.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <B> B getClassNameInstance(String className, Class<B> clazz) {
        Object obj = ProxyUtils.getClassNameInstance(className);
        return clazz.cast(obj);
    }

    public static Class<?>[] getAllIntefaces(Class<?> clazz) {
        ArrayList result = new ArrayList();
        result.add(clazz);
        for (Class<?> tempClazz = clazz; tempClazz != null && tempClazz != Object.class; tempClazz = tempClazz.getSuperclass()) {
            result.addAll(ProxyUtils.addInterfaces(tempClazz));
        }
        return result.toArray(new Class[0]);
    }

    public static boolean isImplementsInterface(Class<?> objClazz, Class<?> inClazz) {
        Class<?>[] all;
        if (objClazz == null || inClazz == null) {
            return false;
        }
        for (Class<?> tmp : all = ProxyUtils.getAllIntefaces(objClazz)) {
            if (!tmp.equals(inClazz)) continue;
            return true;
        }
        return false;
    }

    public static Field[] getAllField(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> tempClazz = clazz; tempClazz != Object.class; tempClazz = tempClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = tempClazz.getDeclaredFields()) {
                if (list.contains(field)) continue;
                list.add(field);
            }
        }
        return list.toArray(new Field[0]);
    }

    public static Method[] getAllMethod(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class<?> tempClazz = clazz; tempClazz != Object.class; tempClazz = tempClazz.getSuperclass()) {
            Method[] fields;
            for (Method field : fields = tempClazz.getDeclaredMethods()) {
                if (list.contains(field)) continue;
                list.add(field);
            }
        }
        return list.toArray(new Method[0]);
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method[] fs;
        for (Method f2 : fs = ProxyUtils.getAllMethod(clazz)) {
            if (!f2.getName().equals(methodName)) continue;
            return f2;
        }
        return null;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field[] fs;
        for (Field f2 : fs = ProxyUtils.getAllField(clazz)) {
            if (!f2.getName().equals(fieldName)) continue;
            return f2;
        }
        return null;
    }

    private static List<Class<?>> addInterfaces(Class<?> clazz) {
        Class<?>[] interfaces;
        ArrayList result = new ArrayList();
        result.add(clazz);
        for (Class<?> tempClazz : interfaces = clazz.getInterfaces()) {
            if (result.contains(tempClazz)) continue;
            result.add(tempClazz);
        }
        return result;
    }

    public static String getFullClassName(Class<?> clazz) {
        return clazz.getName();
    }

    public static String getClassName(Class<?> clazz) {
        String fullName = ProxyUtils.getFullClassName(clazz);
        fullName = fullName.substring(fullName.lastIndexOf(".") + 1);
        return fullName;
    }

    public static Object valueOf(Object obj) {
        return String.valueOf(obj);
    }

    public static Class<?> getFieldCommponentType(Field f2) {
        Type pc;
        if (f2 == null) {
            return null;
        }
        f2.setAccessible(true);
        Class<List> fieldType = f2.getType();
        boolean isArrayField = fieldType.isArray();
        if (isArrayField) {
            return fieldType.getComponentType();
        }
        if (fieldType.isAssignableFrom(List.class) && (pc = f2.getGenericType()) != null && pc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)pc;
            Class clazz = (Class)pt.getActualTypeArguments()[0];
            return clazz;
        }
        return null;
    }

    public static void copy(Object sourceObj, Object disObj) {
        try {
            Class<?> objClassType;
            if (sourceObj == null || disObj == null) {
                return;
            }
            Class<?> classType = sourceObj.getClass();
            if (classType.equals(objClassType = disObj.getClass()) && javaTypes.contains(objClassType)) {
                return;
            }
            Field[] fields = classType.getDeclaredFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                String sourceFieldName;
                Field field = fields[i2];
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) continue;
                String objFieldName = sourceFieldName = field.getName();
                Object value = field.get(sourceObj);
                Field objField = objClassType.getDeclaredField(objFieldName);
                if (objField == null || value == null) continue;
                ProxyUtils.doCopyField(objField, disObj, value);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void doCopyField(Field field, Object disObj, Object value) {
        try {
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (type.isArray()) {
                ProxyUtils.doCopyArrayField(field, disObj, value);
            } else if (javaTypes.contains(type)) {
                field.set(disObj, value);
            } else if (ProxyUtils.isImplementsInterface(type, List.class)) {
                ProxyUtils.doCopyListField(field, disObj, value);
            } else if (ProxyUtils.isImplementsInterface(type, Set.class)) {
                ProxyUtils.doCopySetField(field, disObj, value);
            } else if (ProxyUtils.isImplementsInterface(type, Map.class)) {
                ProxyUtils.doCopyMapField(field, disObj, value);
            } else {
                Object obj = ProxyUtils.newInstanceByConstructor(type);
                ProxyUtils.copy(value, obj);
                field.set(disObj, obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void doCopyListField(Field field, Object disObj, Object value) {
        try {
            List srcLst = (List)value;
            ArrayList<Object> objLst = new ArrayList<Object>();
            for (Object obj : srcLst) {
                Class<?> type = obj.getClass();
                if (javaTypes.contains(type)) {
                    objLst.add(obj);
                    continue;
                }
                Object tmp = ProxyUtils.newInstanceByConstructor(type);
                ProxyUtils.copy(obj, tmp);
                objLst.add(tmp);
            }
            field.set(disObj, objLst);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void doCopySetField(Field field, Object disObj, Object value) {
        try {
            Set srcLst = (Set)value;
            HashSet<Object> objLst = new HashSet<Object>();
            for (Object obj : srcLst) {
                Class<?> type = obj.getClass();
                if (javaTypes.contains(type)) {
                    objLst.add(obj);
                    continue;
                }
                Object tmp = ProxyUtils.newInstanceByConstructor(type);
                ProxyUtils.copy(obj, tmp);
                objLst.add(tmp);
            }
            field.set(disObj, objLst);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void doCopyMapField(Field field, Object disObj, Object value) {
        try {
            Object[] keyArr;
            Map srcMap = (Map)value;
            HashMap<Object, Object> objMap = new HashMap<Object, Object>();
            for (Object key : keyArr = srcMap.keySet().toArray()) {
                Object obj = srcMap.get(key);
                if (obj == null) {
                    objMap.put(key, obj);
                    continue;
                }
                Class<?> type = obj.getClass();
                if (javaTypes.contains(type)) {
                    objMap.put(key, obj);
                    continue;
                }
                Object tmp = ProxyUtils.newInstanceByConstructor(type);
                ProxyUtils.copy(obj, tmp);
                objMap.put(key, tmp);
            }
            field.set(disObj, objMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void doCopyArrayField(Field field, Object disObj, Object value) {
        try {
            Class<?> clazz = field.getType();
            Object[] arr = (Object[])value;
            Class<?> type = clazz.getComponentType();
            Object objs = Array.newInstance(type, arr.length);
            if (javaTypes.contains(clazz)) {
                field.set(disObj, value);
            } else {
                for (int j2 = 0; j2 < arr.length; ++j2) {
                    if (javaTypes.contains(type)) {
                        Array.set(objs, j2, arr[j2]);
                        continue;
                    }
                    Object obj = ProxyUtils.newInstanceByConstructor(type);
                    ProxyUtils.copy(arr[j2], obj);
                    Array.set(objs, j2, obj);
                }
                field.set(disObj, objs);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Field getFieldByFieldName(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object getValueByFieldName(Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ProxyUtils.getFieldByFieldName(obj, fieldName);
        Object value = null;
        if (field != null) {
            if (field.isAccessible()) {
                value = field.get(obj);
            } else {
                field.setAccessible(true);
                value = field.get(obj);
                field.setAccessible(false);
            }
        }
        return value;
    }

    public static String getFieldStrValue(Object obj, String fieldName) {
        Field field = ProxyUtils.getFieldByFieldName(obj, fieldName);
        if (field != null) {
            field.setAccessible(true);
            try {
                return StringUtils.nvl(field.get(obj));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ProxyUtils.getFieldByFieldName(obj, fieldName);
        if (field != null) {
            field.setAccessible(true);
            try {
                return field.get(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getGetterValueByMethodName(Object obj, String methodName) {
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        javaTypes.add(Integer.class);
        javaTypes.add(Float.class);
        javaTypes.add(Double.class);
        javaTypes.add(String.class);
        javaTypes.add(java.util.Date.class);
        javaTypes.add(Date.class);
        javaTypes.add(BigDecimal.class);
        javaTypes.add(BigInteger.class);
        javaTypes.add(Boolean.class);
        javaTypes.add(Timestamp.class);
        javaTypes.add(Byte.TYPE);
        javaTypes.add(Short.TYPE);
        javaTypes.add(Integer.TYPE);
        javaTypes.add(Long.TYPE);
        javaTypes.add(Float.TYPE);
        javaTypes.add(Double.TYPE);
        javaTypes.add(Boolean.TYPE);
        javaTypes.add(Character.TYPE);
        javaTypes.add(Integer[].class);
        javaTypes.add(Float[].class);
        javaTypes.add(Double[].class);
        javaTypes.add(String[].class);
        javaTypes.add(java.util.Date[].class);
        javaTypes.add(Date[].class);
        javaTypes.add(BigDecimal[].class);
        javaTypes.add(BigInteger[].class);
        javaTypes.add(Boolean[].class);
        javaTypes.add(Timestamp[].class);
        javaTypes.add(byte[].class);
        javaTypes.add(short[].class);
        javaTypes.add(int[].class);
        javaTypes.add(long[].class);
        javaTypes.add(float[].class);
        javaTypes.add(double[].class);
        javaTypes.add(boolean[].class);
        javaTypes.add(char[].class);
    }
}

