/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.ssl.BasicTrustManager;
import com.bes.enterprise.appserver.common.util.BaseHttpConnection;
import com.bes.enterprise.cipher.jsse.provider.GMSSLContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class RemoteDMSConnection
extends BaseHttpConnection {
    private Map<String, String> postParameters = new HashMap<String, String>();
    private String host = System.getProperty("com.bes.enterprise.dms.host", "localhost");
    private String port = System.getProperty("com.bes.enterprise.dms.port", "6900");
    private boolean secure = Boolean.getBoolean("com.bes.enterprise.dms.secure");
    private boolean gmssl = Boolean.getBoolean("com.bes.enterprise.dms.gmssl");
    private String username = System.getProperty("com.bes.enterprise.dms.username");
    private String password = System.getProperty("com.bes.enterprise.dms.password");
    private Map<String, String> headers = new HashMap<String, String>();

    public RemoteDMSConnection() {
        this.setHost(this.host);
        this.setPort(Integer.parseInt(this.port));
        this.setSecure(this.secure);
    }

    public Map<String, String> getPostParameters() {
        return this.postParameters;
    }

    public void setPostParameters(Map<String, String> postParameters) {
        this.postParameters = postParameters;
    }

    public void addPostParameters(String key, String vlaue) {
        this.postParameters.put(key, vlaue);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public boolean isGmssl() {
        return this.gmssl;
    }

    public void setGmssl(boolean gmssl) {
        this.gmssl = gmssl;
    }

    @Override
    protected void sendData(HttpURLConnection conn) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        OutputStream output = conn.getOutputStream();
        StringBuilder paramBuilder = new StringBuilder();
        if (!this.postParameters.isEmpty()) {
            for (Map.Entry<String, String> entry : this.postParameters.entrySet()) {
                String encodeValue = URLEncoder.encode(entry.getValue(), "UTF-8");
                paramBuilder.append(entry.getKey()).append('=').append(encodeValue);
                paramBuilder.append('&');
            }
            paramBuilder.deleteCharAt(paramBuilder.length() - 1);
        }
        output.write(paramBuilder.toString().getBytes());
        output.flush();
    }

    @Override
    protected Object handleResponse(HttpURLConnection conn) throws IOException, KeyManagementException, NoSuchAlgorithmException, Exception {
        try {
            InputStream is = conn.getInputStream();
            StringBuffer sb = new StringBuffer();
            if (is != null) {
                int ch;
                while ((ch = is.read()) >= 0) {
                    sb.append((char)ch);
                }
                is.close();
            }
            return sb.toString();
        }
        catch (Throwable ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void configConnectionProperty(HttpURLConnection conn) throws IOException {
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        conn.setRequestProperty("connection", "close");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = null;
        sslContext = this.gmssl ? GMSSLContext.getInstance((boolean)false) : SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new BasicTrustManager()}, new SecureRandom());
        return sslContext;
    }
}

