/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.OSUtils;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;

public class SanitizeFile {
    private String path;

    public static File sanitize(File f2) {
        SanitizeFile sf = new SanitizeFile(f2);
        return new File(sf.path);
    }

    public static String sanitize(String filename) {
        SanitizeFile sf = new SanitizeFile(filename);
        return sf.path;
    }

    public static String sanitizePaths(String pathsString) {
        if (!StringUtils.ok(pathsString)) {
            return pathsString;
        }
        try {
            String[] paths = pathsString.split(File.pathSeparator);
            StringBuilder sb = new StringBuilder();
            HashSet<String> pathsSet = new HashSet<String>();
            LinkedList<String> pathsList = new LinkedList<String>();
            for (int i2 = 0; i2 < paths.length; ++i2) {
                String path = paths[i2];
                if (!StringUtils.ok(path) || !pathsSet.add(path = SanitizeFile.sanitize(path))) continue;
                pathsList.add(path);
            }
            boolean firstElement = true;
            for (String path : pathsList) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    sb.append(File.pathSeparator);
                }
                sb.append(path);
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return pathsString;
        }
    }

    private SanitizeFile(File f2) {
        if (f2 == null) {
            throw new NullPointerException();
        }
        this.convert(f2.getAbsolutePath());
    }

    private SanitizeFile(String s2) {
        if (s2 == null) {
            throw new NullPointerException();
        }
        s2 = StringUtils.removeEnclosingQuotes(s2);
        this.convert(new File(s2).getAbsolutePath());
    }

    private void convert(String oldPath) {
        if (OSUtils.isWindows()) {
            this.convertWindows(oldPath);
        } else {
            this.convertNix(oldPath);
        }
    }

    private void convertWindows(String oldPath) {
        try {
            this.path = new File(oldPath).getCanonicalPath();
            if (!this.path.startsWith("\\")) {
                this.path = this.path.replace('\\', '/');
            }
        }
        catch (IOException ex) {
            this.path = oldPath.replace('\\', '/');
        }
    }

    private void convertNix(String oldPath) {
        char[] p2 = oldPath.toCharArray();
        int to = 0;
        for (int from = 0; from < p2.length; ++from) {
            if (p2[from] == '/' && (from + 3 < p2.length && p2[from + 1] == '.' && p2[from + 2] == '.' && p2[from + 3] == '/' || from + 3 == p2.length && p2[from + 1] == '.' && p2[from + 2] == '.')) {
                while (to > 0 && p2[--to] != '/') {
                }
                from += 2;
                continue;
            }
            if (p2[from] == '/' && (from + 2 < p2.length && p2[from + 1] == '.' && p2[from + 2] == '/' || from + 2 == p2.length && p2[from + 1] == '.')) {
                ++from;
                continue;
            }
            p2[to++] = p2[from];
        }
        if (to > 0 && p2[to - 1] == '/') {
            --to;
        }
        this.path = new String(p2, 0, to);
    }
}

