/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.HostAndPort;
import com.bes.enterprise.appserver.common.util.NetUtils;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String NEWLINE;
    public static final String EOL;
    public static Pattern tokenPattern;

    private StringUtils() {
    }

    public static String getHttpUrlString(HostAndPort hostAndPort) {
        String host = hostAndPort.getHost();
        int port = hostAndPort.getPort();
        boolean isSecure = hostAndPort.isSecure();
        InetAddress hostAddress = null;
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e1) {
            host = "127.0.0.1";
        }
        if (hostAddress instanceof Inet6Address) {
            if (host.equals("::")) {
                String[] ips;
                String ipv6LoopbackAddress = "0:0:0:0:0:0:0:1";
                for (String ip : ips = NetUtils.listLocalIP()) {
                    int index = 0;
                    index = ip.indexOf("%");
                    if (index > 0 && !(host = ip.substring(0, index)).equals(ipv6LoopbackAddress)) break;
                }
            }
            host = "[" + host + "]";
        } else if (host.equals("") || host.equals("0.0.0.0")) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e2) {
                host = "127.0.0.1";
            }
        }
        if (isSecure) {
            return "https://" + host + ":" + port;
        }
        return "http://" + host + ":" + port;
    }

    public static int safeLength(String s2) {
        if (s2 == null) {
            return 0;
        }
        return s2.length();
    }

    public static boolean ok(String s2) {
        return s2 != null && s2.length() > 0;
    }

    public static String formatSQLException(SQLException ex) {
        assert (ex != null);
        String s2 = "SQLException:\n";
        do {
            s2 = s2 + "SQLState: " + ex.getSQLState() + "\n";
            s2 = s2 + "Message:  " + ex.getMessage() + "\n";
            s2 = s2 + "Vendor:   " + ex.getErrorCode() + "\n";
            s2 = s2 + "\n";
        } while ((ex = ex.getNextException()) != null);
        return s2;
    }

    public static String formatException(Exception ex) {
        StringBuffer buf = new StringBuffer();
        if (ex != null) {
            buf.append(ex.getMessage()).append("\n\r");
            buf.append(ex.toString()).append("\n\r");
            buf.append(ex.getLocalizedMessage()).append("\n\r");
            for (Throwable th = ex.getCause(); th != null; th = th.getCause()) {
                StackTraceElement[] arr = th.getStackTrace();
                if (arr != null) {
                    for (StackTraceElement e2 : arr) {
                        if (!e2.getClassName().startsWith("com.bes")) continue;
                        buf.append(e2.toString());
                    }
                }
                buf.append("\n").append(th.getMessage()).append("\n");
                buf.append("\n").append(th.toString()).append("\n");
            }
        }
        return buf.toString();
    }

    public static boolean isHex(String s2) {
        int slen = s2.length();
        for (int i2 = 0; i2 < slen; ++i2) {
            if (StringUtils.isHex(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c2) {
        String hex = "0123456789abcdefABCDEF";
        int hexlen = hex.length();
        for (int i2 = 0; i2 < hexlen; ++i2) {
            if (hex.charAt(i2) != c2) continue;
            return true;
        }
        return false;
    }

    public static String getPenultimateDirName(String s2) {
        if (s2 == null || s2.length() <= 0) {
            return s2;
        }
        if (s2.indexOf(47) < 0 && s2.indexOf(92) < 0) {
            return "";
        }
        int index = (s2 = s2.replace('\\', '/')).lastIndexOf(47);
        if (index < 0) {
            return "";
        }
        if ((index = (s2 = s2.substring(0, index)).lastIndexOf(47)) >= 0) {
            s2 = s2.substring(index + 1);
        }
        return s2;
    }

    public static String toShortClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String padRight(String s2, int len) {
        if (s2 == null || s2.length() >= len) {
            return s2;
        }
        for (int i2 = len - s2.length(); i2 > 0; --i2) {
            s2 = s2 + ' ';
        }
        return s2;
    }

    public static String padLeft(String s2, int len) {
        String ss = "";
        if (s2 == null || s2.length() >= len) {
            return s2;
        }
        for (int i2 = len - s2.length(); i2 > 0; --i2) {
            ss = ss + ' ';
        }
        return ss + s2;
    }

    public static String[] toLines(String s2) {
        if (s2 == null) {
            return new String[0];
        }
        ArrayList<String> v2 = new ArrayList<String>();
        int start = 0;
        int end = 0;
        end = s2.indexOf(10, start);
        while (end >= 0 && start < s2.length()) {
            v2.add(s2.substring(start, end));
            start = end + 1;
            end = s2.indexOf(10, start);
        }
        if (start < s2.length()) {
            v2.add(s2.substring(start));
        }
        String[] ss = new String[v2.size()];
        v2.toArray(ss);
        return ss;
    }

    public static void prepend(String[] ss, String what) {
        for (int i2 = 0; i2 < ss.length; ++i2) {
            ss[i2] = what + ss[i2];
        }
    }

    public static String upperCaseFirst(String s2) {
        if (s2 == null || s2.length() <= 0) {
            return s2;
        }
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    public static String lowerCaseFirst(String s2) {
        if (s2 == null || s2.length() == 0) {
            return s2;
        }
        return s2.substring(0, 1).toLowerCase() + s2.substring(1);
    }

    public static String upperCaseFirstOnly(String s2) {
        if (s2 == null || s2.length() == 0) {
            return s2;
        }
        return s2.substring(0, 1).toUpperCase() + s2.substring(1).toLowerCase();
    }

    public static String replace(String s2, String token, String replace) {
        if (s2 == null || s2.length() <= 0 || token == null || token.length() <= 0) {
            return s2;
        }
        int index = s2.indexOf(token);
        if (index < 0) {
            return s2;
        }
        int tokenLength = token.length();
        String ret = s2.substring(0, index);
        ret = ret + replace;
        ret = ret + s2.substring(index + tokenLength);
        return ret;
    }

    public static String toString(Properties props) {
        String key;
        if (props == null || props.size() <= 0) {
            return "No entries";
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        StringBuffer sb = new StringBuffer();
        int keyWidth = 0;
        for (Map.Entry<Object, Object> me : entries) {
            key = (String)me.getKey();
            int len = key.length();
            if (len <= keyWidth) continue;
            keyWidth = len;
        }
        ++keyWidth;
        for (Map.Entry<Object, Object> me : entries) {
            key = (String)me.getKey();
            String val = (String)me.getValue();
            sb.append(StringUtils.padRight(key, keyWidth));
            sb.append("= ");
            sb.append(val);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String makeFilePath(String[] strings, boolean addTrailing) {
        StringBuffer path = null;
        String separator = System.getProperty("file.separator");
        if (strings != null) {
            path = new StringBuffer();
            for (int i2 = 0; i2 < strings.length; ++i2) {
                String element = strings[i2];
                if (element == null || element.length() == 0) {
                    throw new IllegalArgumentException();
                }
                path.append(element);
                if (i2 >= strings.length - 1) continue;
                path.append(separator);
            }
            if (addTrailing) {
                path.append(separator);
            }
        } else {
            return null;
        }
        return path.toString();
    }

    public static List<String> parseStringList(String line) {
        return StringUtils.parseStringList(line, null);
    }

    public static List<String> parseStringList(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String[] split(String str, String rex) {
        return StringUtils.parseStringList(str, rex).toArray(new String[0]);
    }

    public static String join(List<String> args, String split) {
        if (args == null) {
            return null;
        }
        StringBuffer tmp = new StringBuffer();
        for (int i2 = 0; i2 < args.size(); ++i2) {
            if (0 == i2) {
                tmp.append(args.get(i2));
                continue;
            }
            tmp.append(split).append(args.get(i2));
        }
        return tmp.toString();
    }

    public static String join(String[] args, String split) {
        if (args == null) {
            return null;
        }
        StringBuffer tmp = new StringBuffer();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (0 == i2) {
                tmp.append(args[i2]);
                continue;
            }
            tmp.append(split).append(args[i2]);
        }
        return tmp.toString();
    }

    public static String arrayToString(String[] args) {
        return StringUtils.join(args, ",");
    }

    public static String lstToString(List<String> lst) {
        return StringUtils.join(lst, ",");
    }

    public static List<String> splitString(String str, int length) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < str.length(); i2 += length) {
            int endIndex = i2 + length;
            if (endIndex <= str.length()) {
                list.add(str.substring(i2, i2 + length));
                continue;
            }
            list.add(str.substring(i2, str.length() - 1));
        }
        return list;
    }

    public static String getProperty(String propName) {
        String value = System.getProperty(propName);
        if (value != null) {
            return value;
        }
        value = System.getProperty(propName.toUpperCase());
        if (value != null) {
            System.setProperty(propName, value);
            return value;
        }
        value = System.getProperty(propName.replace('.', '_'));
        if (value != null) {
            System.setProperty(propName, value);
            return value;
        }
        value = System.getProperty(propName.toUpperCase().replace('.', '_'));
        if (value != null) {
            System.setProperty(propName, value);
        }
        return value;
    }

    public static String removeChar(String strOrig, char c2) {
        String strNew = "";
        for (int i2 = 0; i2 < strOrig.length(); ++i2) {
            if (strOrig.charAt(i2) == c2) continue;
            strNew = strNew + strOrig.charAt(i2);
        }
        return strNew;
    }

    public static String getStackTrace(Throwable t2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t2.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static final boolean isToken(String s2) {
        return s2 != null && s2.startsWith("${") && s2.endsWith("}") && s2.length() > 3;
    }

    public static final String stripToken(String s2) {
        if (StringUtils.isToken(s2)) {
            return s2.substring(2, s2.length() - 1);
        }
        return s2;
    }

    public static String substituteToken(String value) {
        return StringUtils.substituteToken(value, new HashMap<String, String>());
    }

    public static String substituteToken(String value, Map<String, String> props) {
        if (value == null || value.indexOf(36) == -1) {
            return value;
        }
        Matcher m2 = tokenPattern.matcher(value);
        while (m2.find()) {
            String newValue = props.get(m2.group(2).trim());
            if (newValue == null) {
                newValue = System.getProperty(m2.group(2).trim());
            }
            if (newValue == null) continue;
            value = m2.replaceFirst(Matcher.quoteReplacement(m2.group(1) + newValue + m2.group(3)));
            m2.reset(value);
        }
        return value;
    }

    public static String cat(String separator, String ... list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s2 : list) {
            if (!StringUtils.ok(s2)) continue;
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    public static String removeEnclosingQuotes(String s2) {
        if (s2 == null) {
            return null;
        }
        if (StringUtils.isDoubleQuoted(s2) || StringUtils.isSingleQuoted(s2)) {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    public static String quotePathIfNecessary(String path) {
        if (!StringUtils.ok(path) || !StringUtils.needsQuoting(path) || StringUtils.isDoubleQuoted(path) || StringUtils.isSingleQuoted(path)) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(path);
        sb.append('\"');
        return sb.toString();
    }

    private static boolean needsQuoting(String path) {
        return StringUtils.ok(path) && (path.indexOf(32) >= 0 || path.indexOf(9) >= 0);
    }

    private static boolean isDoubleQuoted(String s2) {
        return s2.startsWith("\"") && s2.endsWith("\"") && s2.length() > 1;
    }

    private static boolean isSingleQuoted(String s2) {
        return s2.startsWith("'") && s2.endsWith("'") && s2.length() > 1;
    }

    public static String formatDir(String fileDir) {
        if (fileDir == null) {
            return "";
        }
        fileDir = fileDir.trim();
        fileDir = fileDir.replace('\\', '/');
        String regEx = "//*";
        Pattern p2 = Pattern.compile(regEx);
        Matcher m2 = p2.matcher(fileDir);
        fileDir = m2.replaceAll("/");
        return fileDir;
    }

    public static String nvl(Object obj) {
        return StringUtils.nvl(obj, true);
    }

    public static String nvl(Object obj, boolean trimAble) {
        if (obj == null) {
            return "";
        }
        if (trimAble) {
            return obj.toString().trim();
        }
        return obj.toString();
    }

    public static String defaultString(String v2) {
        if (v2 == null) {
            return "";
        }
        return v2;
    }

    public static boolean isBlank(String v2) {
        return v2 == null || v2.trim().length() == 0;
    }

    public static boolean isNotBlank(String v2) {
        return !StringUtils.isBlank(v2);
    }

    public static boolean isEmpty(String v2) {
        return v2 == null || v2.length() == 0;
    }

    public static boolean isNotEmpty(String v2) {
        return !StringUtils.isEmpty(v2);
    }

    public static boolean isPositiveNumber(String v2) {
        try {
            int i2 = Integer.parseInt(v2);
            return i2 > 0;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static String removeEnd(String str, String removeStr) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(removeStr)) {
            return str;
        }
        if (str.endsWith(removeStr)) {
            return str.substring(0, str.length() - removeStr.length());
        }
        return str;
    }

    public static String removeStart(String str, String removeStr) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(removeStr)) {
            return str;
        }
        if (str.startsWith(removeStr)) {
            return str.substring(removeStr.length());
        }
        return str;
    }

    public static boolean isPathEquals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        str1 = str1.replaceAll("\\\\", "/");
        str2 = str2.replaceAll("\\\\", "/");
        if (str1.endsWith("/")) {
            str1 = str1.substring(0, str1.length() - 1);
        }
        if (str2.endsWith("/")) {
            str2 = str2.substring(0, str2.length() - 1);
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static Map<String, String> toStrikeAttributes(Map<String, String> attributes) {
        HashMap<String, String> strikethroughAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            strikethroughAttributes.put(StringUtils.camelToStrike(attr.getKey()), attr.getValue());
        }
        return strikethroughAttributes;
    }

    public static List<String> toStrikeAttributes(List<String> attributes) {
        LinkedList<String> strikethroughAttributes = new LinkedList<String>();
        for (String attr : attributes) {
            strikethroughAttributes.add(StringUtils.camelToStrike(attr));
        }
        return strikethroughAttributes;
    }

    public static Map<String, String> toCamelAttributes(Map<String, String> attributes) {
        HashMap<String, String> camelAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            camelAttributes.put(StringUtils.strikeToCamel(attr.getKey()), attr.getValue());
        }
        return camelAttributes;
    }

    public static String camelToStrike(String param) {
        if (StringUtils.isBlank(param)) {
            return "";
        }
        StringBuilder strike = new StringBuilder();
        for (int i2 = 0; i2 < param.length(); ++i2) {
            char ch = param.charAt(i2);
            if (Character.isUpperCase(ch)) {
                strike.append("-");
                strike.append(Character.toLowerCase(ch));
                continue;
            }
            strike.append(ch);
        }
        return strike.toString();
    }

    public static String camelSepFirstUp(String param) {
        if (StringUtils.isBlank(param)) {
            return "";
        }
        StringBuilder strike = new StringBuilder();
        for (int i2 = 0; i2 < param.length(); ++i2) {
            char ch = param.charAt(i2);
            if (i2 == 0) {
                ch = Character.toUpperCase(ch);
            }
            if (Character.isUpperCase(ch) && i2 != 0) {
                strike.append(' ');
                strike.append(Character.toLowerCase(ch));
                continue;
            }
            strike.append(ch);
        }
        return strike.toString();
    }

    public static String strikeToCamel(String param) {
        if (StringUtils.isBlank(param)) {
            return "";
        }
        StringBuilder strike = new StringBuilder();
        for (int i2 = 0; i2 < param.length(); ++i2) {
            char ch = param.charAt(i2);
            if (ch == '-') {
                strike.append(Character.toUpperCase(param.charAt(++i2)));
                continue;
            }
            strike.append(ch);
        }
        return strike.toString();
    }

    public static String getUpperChar(String qualifiedName) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < qualifiedName.length(); ++i2) {
            char c2 = qualifiedName.charAt(i2);
            if (c2 < 'A' || c2 > 'Z') continue;
            sb.append(c2);
        }
        return sb.toString();
    }

    public static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
    }

    public static String qualifier(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? "" : qualifiedName.substring(0, loc);
    }

    public static String sqlFilter(String str) {
        str = StringUtils.nvl(str);
        StringBuffer buf = new StringBuffer("");
        int count = str.length();
        block8: for (int i2 = 0; i2 < count; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\'': {
                    buf.append("''");
                    continue block8;
                }
                case '\"': {
                    buf.append("\"");
                    continue block8;
                }
                case '%': {
                    buf.append("\\%");
                    continue block8;
                }
                case '$': {
                    buf.append("\\$");
                    continue block8;
                }
                case '^': {
                    buf.append("\\^");
                    continue block8;
                }
                case '_': {
                    buf.append("\\_");
                    continue block8;
                }
                default: {
                    buf.append(c2);
                }
            }
        }
        return buf.toString();
    }

    public static String getPropertyName(String str) {
        StringBuffer result = new StringBuffer();
        String[] strs = str.split("_");
        if (strs != null && strs.length > 0) {
            result.append(strs[0].toLowerCase());
            for (int i2 = 1; i2 < strs.length; ++i2) {
                result.append(StringUtils.upperCaseFirstOnly(strs[i2]));
            }
        }
        return result.toString();
    }

    public static String getTableNameForProperty(String tableName) {
        return StringUtils.lowerCaseFirst(StringUtils.getClassName(tableName));
    }

    public static String getClassName(String str) {
        str = StringUtils.nvl(str);
        StringBuffer result = new StringBuffer();
        String[] strs = str.split("_");
        if (strs != null && strs.length > 0) {
            for (int i2 = 0; i2 < strs.length; ++i2) {
                result.append(StringUtils.upperCaseFirst(strs[i2]));
            }
        }
        return result.toString();
    }

    public static String getTableName(String str) {
        if ((str = StringUtils.nvl(str)).length() == 0) {
            return str;
        }
        if (str.endsWith("Model")) {
            str = str.substring(0, str.lastIndexOf("Model"));
        }
        StringBuffer result = new StringBuffer();
        result.append(str.charAt(0));
        for (int i2 = 1; i2 < str.length(); ++i2) {
            if (Character.isUpperCase(str.charAt(i2))) {
                result.append("_");
            }
            result.append(str.charAt(i2));
        }
        return result.toString().toLowerCase();
    }

    public static String getRouteName(String packageName) {
        return packageName.replace(".", System.getProperty("file.separator"));
    }

    public static String getPackageName(String path) {
        return path.replaceAll(System.getProperty("file.separator"), ".");
    }

    public static InputStream getInputStream(String fileName) {
        try {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getTmpdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static boolean isContainsCn(String str) {
        if ((str = StringUtils.nvl(str)).equals("")) {
            return false;
        }
        return str.matches("^.*[^\\x00-\\xff]+.*$");
    }

    public static List<String> getKeyValuePairWithOutQoute(String str) {
        return StringUtils.getKeyValuePair(str, false);
    }

    public static List<String> getKeyValuePair(String str) {
        return StringUtils.getKeyValuePair(str, true);
    }

    public static List<String> getKeyValuePair(String str, boolean quoteAble) {
        ArrayList<String> list = new ArrayList<String>(2);
        int index = str.indexOf("=");
        String key = "";
        String value = "";
        if (index != -1) {
            key = str.substring(0, str.indexOf("="));
            value = str.substring(str.indexOf("=") + 1, str.length());
        } else {
            key = str;
        }
        if (quoteAble && key.startsWith("-XX:")) {
            key = "\"" + key + "\"";
        }
        list.add(0, key);
        list.add(1, value);
        return list;
    }

    public static List<String> getListFromMapKey(List<Map<String, String>> props, String ... ids) {
        ArrayList<String> keyList = new ArrayList<String>();
        String id = "name";
        if (ids != null) {
            String string = id = ids.length > 0 ? ids[0] : "name";
        }
        if (props != null) {
            for (Map<String, String> oneProp : props) {
                keyList.add(oneProp.get(id));
            }
        }
        return keyList;
    }

    public static Map<String, String> getMapFromMapKey(List<Map<String, String>> props, String ... ids) {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        String id = "name";
        if (ids != null) {
            String string = id = ids.length > 0 ? ids[0] : "name";
        }
        if (props != null) {
            for (Map<String, String> oneProp : props) {
                if (oneProp.get(id).contains("=")) {
                    String key = oneProp.get(id);
                    propsMap.put(key.substring(0, key.indexOf("=")), key.substring(key.indexOf("=") + 1));
                    continue;
                }
                propsMap.put(oneProp.get(id), oneProp.get("value"));
            }
        }
        return propsMap;
    }

    public static boolean isChinese(String str) {
        if ((str = StringUtils.nvl(str)).equals("")) {
            return false;
        }
        return str.matches("^.*[^\\x00-\\xff]+.*$");
    }

    public static boolean isAttribute(String key) {
        if ((key = StringUtils.nvl(key)).equals("")) {
            return false;
        }
        if (StringUtils.isChinese(key)) {
            return false;
        }
        return key.matches("^[a-zA-Z_0-9][a-zA-Z_0-9-\\.]*$");
    }

    public static boolean contains(List<String> arr, String key) {
        key = StringUtils.nvl(key);
        boolean flag = false;
        if (arr != null && arr.size() > 0) {
            for (String str : arr) {
                if (!str.equals(key)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean contains(String[] arr, String key) {
        key = StringUtils.nvl(key);
        boolean flag = false;
        if (arr != null && arr.length > 0) {
            for (String str : arr) {
                if (!str.equals(key)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean contains(String[] hiArr, String[] loArr) {
        for (String s2 : loArr) {
            if (StringUtils.contains(hiArr, s2)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> combine(List<T> oneLst, List<T> otherLst) {
        ArrayList<T> result = new ArrayList<T>();
        if (oneLst != null) {
            for (T t2 : oneLst) {
                if (result.contains(t2)) continue;
                result.add(t2);
            }
        }
        if (otherLst != null) {
            for (T t2 : otherLst) {
                if (result.contains(t2)) continue;
                result.add(t2);
            }
        }
        return result;
    }

    public static String formatAccessResources(String str) {
        if (!(str = StringUtils.removeSpace(str)).equals("")) {
            String[] arr = str.split(",");
            StringBuffer buf = new StringBuffer();
            int count = arr.length;
            for (int i2 = 0; i2 < count; ++i2) {
                String tmp = StringUtils.formatOneAccessResources(arr[i2]);
                if (i2 > 0) {
                    buf.append(',');
                }
                buf.append(tmp);
            }
            str = buf.toString();
        }
        return str;
    }

    private static String formatOneAccessResources(String str) {
        String tmp = StringUtils.nvl(str);
        while (tmp.length() >= 3 && tmp.endsWith("/*/*")) {
            tmp = tmp.substring(0, tmp.length() - 2);
        }
        while (tmp.length() >= 2 && tmp.endsWith("//")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    public static String removeSpace(String accessResource) {
        if (!StringUtils.isBlank(accessResource = StringUtils.nvl(accessResource))) {
            String[] res = StringUtils.split(accessResource, ",");
            return StringUtils.join(res, ",");
        }
        return accessResource;
    }

    public static String htmlStr(String str) {
        String message = StringUtils.nvl(str);
        message = message.replace(">", "&gt;");
        message = message.replace("<", "&lt;");
        message = message.replace("'", "&apos;");
        message = message.replace("\"", "&quot;");
        message = message.replace("\n", "<br/>");
        return message;
    }

    public static boolean isPortValid(String port) {
        try {
            port = port.trim();
            int aa2 = Integer.parseInt(port);
            if (aa2 < 1 || aa2 > 65535) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String getExtension(File f2) {
        if (f2 != null && f2.isFile()) {
            return f2.getName().substring(f2.getName().lastIndexOf(".") + 1);
        }
        return "";
    }

    public static List<String> formatLstStr(List<String> lst, String splitStr, int index) {
        ArrayList<String> result = new ArrayList<String>();
        if (lst != null) {
            for (String str : lst) {
                String[] arr = str.split(splitStr);
                if (arr.length <= index) {
                    result.add(str);
                    continue;
                }
                result.add(arr[index]);
            }
        }
        return result;
    }

    public static String formatcitycode(String citycode) {
        if ((citycode = StringUtils.nvl(citycode)).length() == 0) {
            return citycode;
        }
        try {
            citycode = String.valueOf(Integer.parseInt(citycode));
            if (citycode.length() < 4) {
                switch (citycode.length()) {
                    case 3: {
                        return "0" + citycode;
                    }
                    case 2: {
                        return "00" + citycode;
                    }
                    case 1: {
                        return "000" + citycode;
                    }
                }
                return citycode;
            }
            if (citycode.length() > 4) {
                return citycode.substring(0, 4);
            }
            return citycode;
        }
        catch (Exception ex) {
            return "0131";
        }
    }

    public static String formatNumberOned(String v2) {
        if ((v2 = StringUtils.nvl(v2)).length() > 0) {
            try {
                DecimalFormat f2 = new DecimalFormat("#.#");
                return f2.format(Double.parseDouble(v2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "0.0";
    }

    public static String reverse(String str) {
        str = StringUtils.nvl(str);
        return new StringBuffer(str).reverse().toString();
    }

    public static boolean isMobile(String str) {
        try {
            Pattern pattern;
            Matcher matcher;
            if (str.startsWith("+")) {
                str = str.substring(1);
            }
            if (str.startsWith("861")) {
                str = str.substring(2);
            }
            return (matcher = (pattern = Pattern.compile("^18\\d{9}||13\\d{9}||11[0,9]\\d{8}||15\\d{9}$")).matcher(str)).matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("windows");
    }

    public static long formatStrToLong(String str) {
        String v2 = StringUtils.nvl(str);
        if (v2.length() > 0) {
            try {
                return Long.parseLong(v2);
            }
            catch (Exception ex) {
                return 0L;
            }
        }
        return 0L;
    }

    public static boolean isNumeric(String str) {
        boolean isNumeric = true;
        try {
            Integer.parseInt(str);
        }
        catch (Exception e2) {
            isNumeric = false;
        }
        return isNumeric;
    }

    public static boolean isEquals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean isValueEquals(String str1, String str2, boolean ignoreCase) {
        if (StringUtils.isEmpty(str1) || StringUtils.isEmpty(str2)) {
            return false;
        }
        return ignoreCase && str1.equalsIgnoreCase(str2) || !ignoreCase && str1.equals(str2);
    }

    public static Set<String> parseStringSet(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        HashSet<String> tokens = new HashSet<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    static {
        EOL = NEWLINE = System.getProperty("line.separator");
        tokenPattern = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}([^\\$]*)");
    }
}

