/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.OSUtils;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TokenResolver {
    private final Map<String, String> props;

    public TokenResolver(Map<String, String> map) {
        this.props = map;
    }

    public void resolve(Map<String, String> map) {
        this.resolveHandleForWindows(map, true);
    }

    public void resolveHandleForWindows(Map<String, String> map, boolean handleForWindows) {
        LinkedHashMap<String, String> newEntries = new LinkedHashMap<String, String>();
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            newEntries.put(key, value);
            if (TokenResolver.hasToken(value)) {
                value = this.resolve(value, handleForWindows);
                newEntries.put(key, value);
            }
            if (!TokenResolver.hasToken(key)) continue;
            String newKey = this.resolve(key, handleForWindows);
            newEntries.remove(key);
            newEntries.put(newKey, value);
        }
        map.clear();
        map.putAll(newEntries);
    }

    public void resolve(List<String> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String s2 = list.get(i2);
            if (!TokenResolver.hasToken(s2)) continue;
            list.set(i2, this.resolve(s2));
        }
    }

    public String resolve(String s2) {
        return this.resolve(s2, true);
    }

    public String resolve(String s2, boolean handleForWindows) {
        if (s2 == null || s2.length() <= 0) {
            return s2;
        }
        if (TokenResolver.hasWindowsToken(s2) && handleForWindows) {
            s2 = this.windowsToUnixTokens(s2);
        }
        List<Token> tokens = this.getTokens(s2);
        String resolved = s2;
        for (Token token : tokens) {
            resolved = StringUtils.replace(resolved, token.token, token.value);
        }
        return resolved;
    }

    private String windowsToUnixTokens(String s2) {
        String replaced = s2;
        while (replaced != null && replaced.indexOf(37) >= 0) {
            replaced = StringUtils.replace(replaced, "%", "${");
            replaced = StringUtils.replace(replaced, "%", "}");
        }
        if (replaced == null) {
            return s2;
        }
        return replaced;
    }

    private static boolean hasWindowsToken(String s2) {
        int index = s2.indexOf(37);
        if (index < 0 || index >= s2.length() - 1) {
            return false;
        }
        return s2.indexOf(37, index + 1) >= 0;
    }

    private List<Token> getTokens(String s2) {
        Token token;
        int index = 0;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((token = this.getToken(s2, index)) != null) {
            tokens.add(token);
            index = token.start + "${".length();
        }
        return tokens;
    }

    private Token getToken(String s2, int index) {
        if (s2 == null || index >= s2.length()) {
            return null;
        }
        Token token = new Token();
        token.start = s2.indexOf("${", index);
        token.end = s2.indexOf("}", token.start + 2);
        if (token.end <= 0 || token.start < 0) {
            return null;
        }
        token.token = s2.substring(token.start, token.end + 1);
        token.name = s2.substring(token.start + "${".length(), token.end);
        token.value = this.props.get(token.name);
        if (token.value == null) {
            token.value = token.token;
        }
        return token;
    }

    public static boolean hasToken(String s2) {
        if (s2 == null) {
            return false;
        }
        if (OSUtils.isWindows() && TokenResolver.hasWindowsToken(s2)) {
            return true;
        }
        return s2.contains("${");
    }

    private static class Token {
        int start;
        int end;
        String token;
        String name;
        String value;

        private Token() {
        }

        public String toString() {
            return "name: " + this.name + ", token: " + this.token + ", value: " + this.value;
        }
    }
}

