/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionUtil {
    private static final String PRODUCT_NAME;
    private static final String FULL_VERSION;
    private static final String MAJOR_VERSION;
    private static final String MINOR_VERSION;
    private static final String SHORT_VERSION;
    private static final String BUILD_ID;
    private static final String VERSION_PREFIX;
    private static final String VERSION_SUFFIX;
    private static final String COPYRIGHT_DURATION;
    private static final String PATCH_FILE_PATH = "license/version";
    private static final String PATCH_TIME = "PatchTime";
    private static final String PATCH_VERSION = "PatchVersion";

    public static String getVersion() {
        if (PRODUCT_NAME == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(PRODUCT_NAME);
        if (VersionUtil.ok(VERSION_PREFIX)) {
            sb.append(' ').append(VERSION_PREFIX);
        }
        if (FULL_VERSION != null) {
            sb.append(' ').append(FULL_VERSION);
        }
        if (VersionUtil.ok(VERSION_SUFFIX)) {
            sb.append(' ').append(VERSION_SUFFIX);
        }
        return sb.toString();
    }

    public static String getShortVersion() {
        if (PRODUCT_NAME == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(PRODUCT_NAME);
        if (VersionUtil.ok(VERSION_PREFIX)) {
            sb.append(' ').append(VERSION_PREFIX);
        }
        if (SHORT_VERSION != null) {
            sb.append(' ').append(SHORT_VERSION);
        }
        if (VersionUtil.ok(VERSION_SUFFIX)) {
            sb.append(' ').append(VERSION_SUFFIX);
        }
        return sb.toString();
    }

    public static String getFullVersion() {
        String version = VersionUtil.getVersion() + " (build " + BUILD_ID + ")";
        String patch = VersionUtil.getPatchVersion();
        if (!"".equals(patch.trim())) {
            version = version + "\r\n" + patch;
        }
        return version;
    }

    public static String getBuildVersion() {
        return BUILD_ID;
    }

    public static String getVersionPrefix() {
        return VERSION_PREFIX;
    }

    public static String getVersionSuffix() {
        return VERSION_SUFFIX;
    }

    public static String getProductName() {
        return PRODUCT_NAME;
    }

    public static String getCopyrightDuration() {
        return COPYRIGHT_DURATION;
    }

    private static boolean ok(String s2) {
        return s2 != null && s2.length() > 0;
    }

    public static String getPatchVersion() {
        Properties patchProperties = VersionUtil.getPatchFromFile();
        if (null != patchProperties.get(PATCH_TIME) && null != patchProperties.get(PATCH_VERSION)) {
            return "(patch time " + patchProperties.get(PATCH_TIME) + ") (patch build " + patchProperties.get(PATCH_VERSION) + ")";
        }
        return "";
    }

    public static String getBriefPatchVersion() {
        Properties patchProperties = VersionUtil.getPatchFromFile();
        if (null != patchProperties.get(PATCH_VERSION)) {
            return patchProperties.getProperty(PATCH_VERSION);
        }
        return FULL_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPatchFromFile() {
        Properties prop = new Properties();
        String patchFilePath = System.getProperty("com.bes.patchRoot");
        if (patchFilePath == null || patchFilePath.trim().isEmpty()) {
            patchFilePath = System.getProperty("com.bes.installRoot");
        }
        File patchFile = new File(patchFilePath, PATCH_FILE_PATH);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(patchFile));
            prop.load(in);
        }
        catch (Exception e2) {
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    static {
        Properties props = new Properties();
        try (InputStream is = VersionUtil.class.getResourceAsStream("version.properties");){
            props.load(is);
            PRODUCT_NAME = props.getProperty("product.name");
            MAJOR_VERSION = props.getProperty("major.version");
            MINOR_VERSION = props.getProperty("minor.version");
            SHORT_VERSION = props.getProperty("short.version");
            VERSION_PREFIX = props.getProperty("version.prefix");
            VERSION_SUFFIX = props.getProperty("version.suffix");
            BUILD_ID = props.getProperty("build.id");
            COPYRIGHT_DURATION = props.getProperty("copyright.duration");
            FULL_VERSION = MAJOR_VERSION + "." + MINOR_VERSION;
        }
        catch (Throwable t2) {
            throw new RuntimeException("Failed to initialize server version information.", t2);
        }
    }
}

