/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.startup;

import com.bes.enterprise.appserver.startup.ASURLClassLoader;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CommonClassLoader
extends ASURLClassLoader {
    private static final Log log = LogFactory.getLog(CommonClassLoader.class);
    private final Map<String, Long> resources = new ConcurrentHashMap<String, Long>();
    private static final File libDirectory = new File(System.getProperty("com.bes.installRoot"), "lib");
    private static final File instLibDirectory = new File(System.getProperty("com.bes.instanceRoot"), "lib");
    private Thread monitorThread;

    public CommonClassLoader(URL[] urls) {
        super(urls);
        this.watchResources(urls);
    }

    public CommonClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.watchResources(urls);
    }

    public CommonClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.watchResources(urls);
    }

    private void watchResources(URL ... urls) {
        try {
            for (URL url : urls) {
                File f2 = new File(url.toURI());
                this.resources.put(f2.getName(), f2.lastModified());
            }
        }
        catch (URISyntaxException e2) {
            log.warn("Exception occurred, directory monitor exited!", e2);
            return;
        }
        this.monitorThread = new Thread(){

            @Override
            public void run() {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                };
                block4: while (true) {
                    File[] instLibJars;
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ArrayList<File> allJars = new ArrayList<File>();
                    File[] libJars = libDirectory.listFiles(filter);
                    if (libJars != null) {
                        allJars.addAll(Arrays.asList(libJars));
                    }
                    if ((instLibJars = instLibDirectory.listFiles(filter)) != null) {
                        allJars.addAll(Arrays.asList(instLibJars));
                    }
                    Iterator iterator = allJars.iterator();
                    while (true) {
                        Long recordedLastModified;
                        if (!iterator.hasNext()) continue block4;
                        File jar = (File)iterator.next();
                        if (!jar.isFile() || !jar.canRead() || (recordedLastModified = (Long)CommonClassLoader.this.resources.get(jar.getName())) != null) continue;
                        try {
                            CommonClassLoader.this.addURL(jar.toURI().toURL());
                            ConcurrentHashMap chm = CommonClassLoader.this.getCacheMap();
                            if (chm == null) continue;
                            chm.clear();
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                    }
                    break;
                }
            }
        };
        this.monitorThread.setName("Common Lib Watcher");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

