/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.common.request.dispatcher;

import com.bes.enterprise.common.cache.ConcurrentLRUCache;
import com.bes.enterprise.common.request.dispatcher.PatternMatchResult;
import com.bes.enterprise.common.request.dispatcher.URIPatternMatcher;
import com.bes.enterprise.common.request.dispatcher.config.RequestDispatcherConfig;
import com.bes.enterprise.common.request.dispatcher.config.RequestRuleConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class RequestDispatcher {
    private RequestDispatcherConfig config;
    private final Map<String, URIPatternMatcher> urlPatterns = new HashMap<String, URIPatternMatcher>();
    private final LinkedBlockingQueue<URIPatternMatcher> exactMatchers = new LinkedBlockingQueue();
    private ConcurrentLRUCache<String, PatternMatchResult> resultCache = null;

    public RequestDispatcher(RequestDispatcherConfig config) {
        this.config = config;
        this.init();
    }

    public RequestDispatcherConfig getConfig() {
        return this.config;
    }

    public void init() {
        if (this.config == null) {
            throw new RuntimeException("The config could not be null!");
        }
        if (this.config.isCacheSupport()) {
            this.resultCache = new ConcurrentLRUCache(this.config.getCacheSize());
        }
    }

    public void addRule(RequestRuleConfig rule) {
        URIPatternMatcher matcher = new URIPatternMatcher(rule);
        this.exactMatchers.add(matcher);
        this.urlPatterns.put(rule.getUrlPattern(), matcher);
    }

    private void removeRule(URIPatternMatcher matcher) {
        RequestRuleConfig rule = matcher.getRule();
        if (rule != null) {
            this.exactMatchers.remove(matcher);
        }
    }

    public synchronized void configRules(List<? extends RequestRuleConfig> rules) {
        if (rules == null || rules.isEmpty()) {
            return;
        }
        for (RequestRuleConfig requestRuleConfig : rules) {
            this.addRule(requestRuleConfig);
        }
    }

    public synchronized void reconfigRules(List<? extends RequestRuleConfig> rules) {
        URIPatternMatcher matcher;
        if (rules == null || rules.isEmpty()) {
            this.urlPatterns.clear();
            this.exactMatchers.clear();
            this.invalidCache();
            return;
        }
        ArrayList<String> newPatterns = new ArrayList<String>();
        for (RequestRuleConfig requestRuleConfig : rules) {
            String urlPattern = requestRuleConfig.getUrlPattern();
            newPatterns.add(urlPattern);
            matcher = this.urlPatterns.get(urlPattern);
            if (matcher == null) {
                this.addRule(requestRuleConfig);
                continue;
            }
            RequestRuleConfig oldRule = matcher.getRule();
            if (oldRule.equals(requestRuleConfig)) continue;
            this.removeRule(matcher);
            this.addRule(requestRuleConfig);
        }
        List<String> oldPatterns = this.getOldPatterns();
        oldPatterns.removeAll(newPatterns);
        if (!oldPatterns.isEmpty()) {
            for (String removePattern : oldPatterns) {
                matcher = this.urlPatterns.remove(removePattern);
                this.removeRule(matcher);
            }
        }
        this.invalidCache();
    }

    private List<String> getOldPatterns() {
        ArrayList<String> oldPatterns = new ArrayList<String>();
        oldPatterns.addAll(this.urlPatterns.keySet());
        return oldPatterns;
    }

    public RequestRuleConfig findDispatcherRule(String requestURI, String queryString) {
        PatternMatchResult result;
        String requestURL = requestURI + "?" + queryString;
        if (this.config.isCacheSupport() && (result = this.resultCache.get(requestURL)) != null) {
            return result.getRule();
        }
        PatternMatchResult finalResult = this.findExactMatch(requestURI, queryString);
        if (finalResult == null) {
            finalResult = PatternMatchResult.NO_MATCH_RULE;
        }
        if (this.config.isCacheSupport()) {
            this.resultCache.add(requestURL, finalResult);
        }
        return finalResult.getRule();
    }

    private PatternMatchResult findExactMatch(String requestURI, String queryString) {
        for (URIPatternMatcher matcher : this.exactMatchers) {
            PatternMatchResult candidate = matcher.match(requestURI, queryString);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public void invalidCache() {
        if (this.resultCache != null) {
            this.resultCache.destroy();
        }
    }
}

