/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.common.request.dispatcher;

import com.bes.enterprise.common.request.dispatcher.PatternMatchResult;
import com.bes.enterprise.common.request.dispatcher.PatternMatchUtils;
import com.bes.enterprise.common.request.dispatcher.config.RequestRuleConfig;

public class URIPatternMatcher {
    private final RequestRuleConfig rule;
    private String[] childrenPath;
    private String[] query;

    public URIPatternMatcher(RequestRuleConfig rule) {
        String urlPattern = rule.getUrlPattern();
        if (urlPattern.startsWith("/")) {
            urlPattern = urlPattern.substring(1);
        }
        String requsetURI = urlPattern;
        String queryString = null;
        if (urlPattern.contains("?")) {
            int index = urlPattern.indexOf("?");
            requsetURI = urlPattern.substring(0, index);
            queryString = urlPattern.substring(index + 1);
        }
        this.rule = rule;
        this.childrenPath = PatternMatchUtils.split(requsetURI, "/");
        if (queryString != null) {
            this.query = PatternMatchUtils.split(queryString, "&");
        }
    }

    public RequestRuleConfig getRule() {
        return this.rule;
    }

    public PatternMatchResult match(String requestURI, String queryString) {
        return this.exactMatch(requestURI, queryString);
    }

    private PatternMatchResult exactMatch(String requestURI, String queryString) {
        String[] items;
        boolean uriMatches;
        if (requestURI.startsWith("/")) {
            requestURI = requestURI.substring(1);
        }
        if (!(uriMatches = PatternMatchUtils.stringArrayMatches(this.childrenPath, items = PatternMatchUtils.split(requestURI, "/")))) {
            return null;
        }
        if (queryString == null || "".equals(queryString.trim())) {
            if (this.query == null || this.query.length == 0) {
                PatternMatchResult matcherResult = new PatternMatchResult(uriMatches, this.rule);
                return matcherResult;
            }
            return null;
        }
        if (this.query == null || this.query.length == 0) {
            return null;
        }
        String[] queryItems = PatternMatchUtils.split(queryString, "&");
        boolean queryMatches = PatternMatchUtils.stringArrayMatches(this.query, queryItems);
        if (queryMatches) {
            PatternMatchResult matcherResult = new PatternMatchResult(uriMatches, this.rule);
            return matcherResult;
        }
        return null;
    }
}

