/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.miniparser;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ConfigBeanPath
implements Serializable {
    private final ConfigBeanPath parent;
    private final String elementName;
    private final String attributeName;
    private final String attributeValue;

    public static ConfigBeanPath buildConfigBeanPath(String pathExpression) {
        if (pathExpression.startsWith("/")) {
            pathExpression = pathExpression.substring(1);
        }
        List<String> paths = ConfigBeanPath.splitPath(pathExpression);
        ConfigBeanPath parentPath = null;
        for (String path : paths) {
            ConfigBeanPath currentPath;
            String element = ConfigBeanPath.getElementInPath(path);
            String keyAtribute = ConfigBeanPath.getAttributeNameInPath(path);
            String keyAttributeValue = ConfigBeanPath.getAttributeValueInPath(path);
            parentPath = currentPath = new ConfigBeanPath(parentPath, element, keyAtribute, keyAttributeValue);
        }
        return parentPath;
    }

    public static ConfigBeanPath buildConfigBeanPath(String pathExpression, String attributeName, String attributeValue) {
        ConfigBeanPath path = ConfigBeanPath.buildConfigBeanPath(pathExpression);
        return ConfigBeanPath.buildConfigBeanPath(path.getParentPath(), path.getElementName(), attributeName, attributeValue);
    }

    public static ConfigBeanPath buildConfigBeanPath(ConfigBeanPath parent, String elementName) {
        return new ConfigBeanPath(parent, elementName);
    }

    public static ConfigBeanPath buildConfigBeanPath(ConfigBeanPath path, String attributeName, String attributeValue) {
        return new ConfigBeanPath(path.getParentPath(), path.getElementName(), attributeName, attributeValue);
    }

    public static ConfigBeanPath buildConfigBeanPath(ConfigBeanPath parent, String elementName, String attributeName, String attributeValue) {
        return new ConfigBeanPath(parent, elementName, attributeName, attributeValue);
    }

    private ConfigBeanPath(ConfigBeanPath parent, String elementName) {
        this(parent, elementName, null, null);
    }

    private ConfigBeanPath(ConfigBeanPath parent, String elementName, String attributeName, String attributeValue) {
        this.parent = parent;
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getParentElementName() {
        if (this.parent != null) {
            return this.parent.getElementName();
        }
        return null;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public String getRootPath() {
        if (this.parent == null) {
            return this.elementName;
        }
        return this.parent.getRootPath();
    }

    public ConfigBeanPath getParentPath() {
        return this.parent;
    }

    public String getSimplePath() {
        StringBuilder builder = new StringBuilder();
        if (this.parent != null) {
            builder.append(this.parent.getSimplePath());
        }
        builder.append("/");
        builder.append(this.elementName);
        return builder.toString();
    }

    public String getFullPath() {
        StringBuilder builder = new StringBuilder();
        if (this.parent != null) {
            builder.append(this.parent.getFullPath());
        }
        builder.append("/");
        builder.append(this.elementName);
        if (this.attributeName != null) {
            builder.append("[@");
            builder.append(this.attributeName);
            builder.append("=");
            builder.append(this.attributeValue);
            builder.append("]");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getFullPath();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.parent);
        hash = 97 * hash + Objects.hashCode(this.elementName);
        hash = 97 * hash + Objects.hashCode(this.attributeName);
        hash = 97 * hash + Objects.hashCode(this.attributeValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigBeanPath other = (ConfigBeanPath)obj;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.elementName, other.elementName)) {
            return false;
        }
        if (!Objects.equals(this.attributeName, other.attributeName)) {
            return false;
        }
        return Objects.equals(this.attributeValue, other.attributeValue);
    }

    public static String getElementInPath(String complicatedPath) {
        if (!complicatedPath.contains("[@")) {
            return complicatedPath;
        }
        return complicatedPath.substring(0, complicatedPath.indexOf("[@"));
    }

    public static String getAttributeNameInPath(String complicatedPath) {
        if (!complicatedPath.contains("[@")) {
            return null;
        }
        return complicatedPath.substring(complicatedPath.indexOf("[@") + "[@".length(), complicatedPath.indexOf("="));
    }

    public static String getAttributeValueInPath(String complicatedPath) {
        if (!complicatedPath.contains("[@")) {
            return null;
        }
        return complicatedPath.substring(complicatedPath.indexOf("=") + "=".length(), complicatedPath.indexOf("]"));
    }

    public static List<String> splitPath(String string) {
        LinkedList<String> result = new LinkedList<String>();
        int pos_start = string.indexOf("/");
        if (pos_start >= 0) {
            int pos_end = -1;
            while (pos_start >= 0) {
                String path = string.substring(pos_end + 1, pos_start);
                if (path.indexOf("[@") > 0 && path.indexOf("]") < 0) {
                    int endValue = string.indexOf("]", pos_start);
                    path = string.substring(pos_end + 1, endValue + 1);
                    pos_start = endValue + 1;
                }
                pos_end = pos_start;
                result.add(path);
                pos_start = string.indexOf("/", pos_end + 1);
            }
            if (pos_end < string.length() - 1) {
                result.add(string.substring(pos_end + 1, string.length()));
            }
        } else {
            result.add(string);
        }
        return result;
    }
}

